/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import static java.lang.String.format;

public class LogVerificationException extends RuntimeException {

	private static final long serialVersionUID = 2565558074861134325L;
	
	private final ILog expected;
	private final ILog actual;

	public LogVerificationException(final ILog expected, final ILog actual) {
		super();
		this.expected = expected;
		this.actual = actual;
	}

	public ILog getExpected() {
		return expected;
	}

	public ILog getActual() {
		return actual;
	}

	@Override
	public String getMessage() {
		return format(
				"[expected]\n%s\n\n[actual]\n%s\n",
				expected == null ? "No Log" : expected.asOutputString(),
				actual == null ? "No Log" : actual.asOutputString());
	}
}
