/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import org.apache.commons.logging.Log;

public class JclReceiver implements Log {

	private static ILoggable logs = null;
	private final String clazzName;

	public JclReceiver(final String name) {
		this.clazzName = name;
	}
	
	public static void setLogger(final ILoggable logger) {
		logs = logger;
	}
	
	private void addToLogs(final Object obj, final JclLogLevel level) {
		logs.addLog(new JclLogInfo(obj.toString(), clazzName, level));
	}
	

	public boolean isTraceEnabled() {
		return true;
	}

	public boolean isDebugEnabled() {
		return true;
	}

	public boolean isInfoEnabled() {
		return true;
	}

	public boolean isWarnEnabled() {
		return true;
	}

	public boolean isErrorEnabled() {
		return true;
	}

	public boolean isFatalEnabled() {
		return true;
	}

	public void trace(final Object obj) {
		addToLogs(obj, JclLogLevel.TRACE);
	}

	public void trace(final Object obj, final Throwable ex) {
	}

	public void debug(final Object obj) {
		addToLogs(obj, JclLogLevel.DEBUG);
	}

	public void debug(final Object obj, final Throwable ex) {
	}

	public void info(final Object obj) {
		addToLogs(obj, JclLogLevel.INFO);
	}

	public void info(final Object obj, final Throwable ex) {
	}

	public void warn(final Object obj) {
		addToLogs(obj, JclLogLevel.WARN);
	}

	public void warn(final Object obj, final Throwable ex) {
	}

	public void error(final Object obj) {
		addToLogs(obj, JclLogLevel.ERROR);
	}

	public void error(final Object obj, final Throwable ex) {
	}

	public void fatal(final Object obj) {
		addToLogs(obj, JclLogLevel.FATAL);
	}

	public void fatal(final Object obj, final Throwable ex) {
	}
}
