/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jlogtest;

import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.JclLogInfo;
import jp.sourceforge.jlogtest.JclLogLevel;
import org.apache.commons.logging.Log;

public class JclReceiver
implements Log {
    private static ILoggable logs = null;
    private final String clazzName;

    public JclReceiver(String name) {
        this.clazzName = name;
    }

    public static void setLogger(ILoggable logger) {
        logs = logger;
    }

    private void addToLogs(Object obj, JclLogLevel level) {
        logs.addLog(new JclLogInfo(obj.toString(), this.clazzName, level));
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void trace(Object obj) {
        this.addToLogs(obj, JclLogLevel.TRACE);
    }

    public void trace(Object obj, Throwable ex) {
    }

    public void debug(Object obj) {
        this.addToLogs(obj, JclLogLevel.DEBUG);
    }

    public void debug(Object obj, Throwable ex) {
    }

    public void info(Object obj) {
        this.addToLogs(obj, JclLogLevel.INFO);
    }

    public void info(Object obj, Throwable ex) {
    }

    public void warn(Object obj) {
        this.addToLogs(obj, JclLogLevel.WARN);
    }

    public void warn(Object obj, Throwable ex) {
    }

    public void error(Object obj) {
        this.addToLogs(obj, JclLogLevel.ERROR);
    }

    public void error(Object obj, Throwable ex) {
    }

    public void fatal(Object obj) {
        this.addToLogs(obj, JclLogLevel.FATAL);
    }

    public void fatal(Object obj, Throwable ex) {
    }
}

