/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import jp.sfjp.jindolf.VerInfo;
import jp.sfjp.jindolf.editor.TalkPreview;
import jp.sfjp.jindolf.log.LogFrame;
import jp.sfjp.jindolf.summary.DaySummary;
import jp.sfjp.jindolf.summary.VillageDigest;
import jp.sfjp.jindolf.view.AccountPanel;
import jp.sfjp.jindolf.view.FilterPanel;
import jp.sfjp.jindolf.view.FindPanel;
import jp.sfjp.jindolf.view.HelpFrame;
import jp.sfjp.jindolf.view.OptionPanel;
import jp.sfjp.jindolf.view.TopFrame;

public class WindowManager {
    private static final String TITLE_FILTER = WindowManager.getFrameTitle("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf");
    private static final String TITLE_LOGGER = WindowManager.getFrameTitle("\u30ed\u30b0\u8868\u793a");
    private static final String TITLE_EDITOR = WindowManager.getFrameTitle("\u767a\u8a00\u30a8\u30c7\u30a3\u30bf");
    private static final String TITLE_OPTION = WindowManager.getFrameTitle("\u30aa\u30d7\u30b7\u30e7\u30f3\u8a2d\u5b9a");
    private static final String TITLE_FIND = WindowManager.getFrameTitle("\u767a\u8a00\u691c\u7d22");
    private static final String TITLE_ACCOUNT = WindowManager.getFrameTitle("\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406");
    private static final String TITLE_DIGEST = WindowManager.getFrameTitle("\u6751\u306e\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8");
    private static final String TITLE_DAYSUMMARY = WindowManager.getFrameTitle("\u767a\u8a00\u96c6\u8a08");
    private static final String TITLE_HELP = WindowManager.getFrameTitle("\u30d8\u30eb\u30d7");
    private static final Frame NULLPARENT = null;
    private FilterPanel filterPanel;
    private LogFrame logFrame;
    private TalkPreview talkPreview;
    private OptionPanel optionPanel;
    private FindPanel findPanel;
    private AccountPanel accountPanel;
    private VillageDigest villageDigest;
    private DaySummary daySummary;
    private HelpFrame helpFrame;
    private TopFrame topFrame;
    private final List<Window> windowSet = new LinkedList<Window>();

    private static String getFrameTitle(String text) {
        String result = VerInfo.getFrameTitle(text);
        return result;
    }

    protected FilterPanel createFilterPanel() {
        FilterPanel result = new FilterPanel(NULLPARENT);
        result.setTitle(TITLE_FILTER);
        result.pack();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public FilterPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = this.createFilterPanel();
        }
        return this.filterPanel;
    }

    protected LogFrame createLogFrame() {
        LogFrame result = new LogFrame(NULLPARENT);
        result.setTitle(TITLE_LOGGER);
        result.pack();
        result.setSize(600, 500);
        result.setLocationByPlatform(true);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public LogFrame getLogFrame() {
        if (this.logFrame == null) {
            this.logFrame = this.createLogFrame();
        }
        return this.logFrame;
    }

    protected TalkPreview createTalkPreview() {
        TalkPreview result = new TalkPreview();
        result.setTitle(TITLE_EDITOR);
        result.pack();
        result.setSize(700, 500);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public TalkPreview getTalkPreview() {
        if (this.talkPreview == null) {
            this.talkPreview = this.createTalkPreview();
        }
        return this.talkPreview;
    }

    protected OptionPanel createOptionPanel() {
        OptionPanel result = new OptionPanel(NULLPARENT);
        result.setTitle(TITLE_OPTION);
        result.pack();
        result.setSize(450, 500);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public OptionPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = this.createOptionPanel();
        }
        return this.optionPanel;
    }

    protected FindPanel createFindPanel() {
        FindPanel result = new FindPanel(NULLPARENT);
        result.setTitle(TITLE_FIND);
        result.pack();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public FindPanel getFindPanel() {
        if (this.findPanel == null) {
            this.findPanel = this.createFindPanel();
        }
        return this.findPanel;
    }

    protected AccountPanel createAccountPanel() {
        AccountPanel result = new AccountPanel(NULLPARENT);
        result.setTitle(TITLE_ACCOUNT);
        result.pack();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public AccountPanel getAccountPanel() {
        if (this.accountPanel == null) {
            this.accountPanel = this.createAccountPanel();
        }
        return this.accountPanel;
    }

    protected VillageDigest createVillageDigest() {
        VillageDigest result = new VillageDigest(NULLPARENT);
        result.setTitle(TITLE_DIGEST);
        result.pack();
        result.setSize(600, 550);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public VillageDigest getVillageDigest() {
        if (this.villageDigest == null) {
            this.villageDigest = this.createVillageDigest();
        }
        return this.villageDigest;
    }

    protected DaySummary createDaySummary() {
        DaySummary result = new DaySummary(NULLPARENT);
        result.setTitle(TITLE_DAYSUMMARY);
        result.pack();
        result.setSize(400, 500);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public DaySummary getDaySummary() {
        if (this.daySummary == null) {
            this.daySummary = this.createDaySummary();
        }
        return this.daySummary;
    }

    protected HelpFrame createHelpFrame() {
        HelpFrame result = new HelpFrame();
        result.setTitle(TITLE_HELP);
        result.pack();
        result.setSize(450, 450);
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public HelpFrame getHelpFrame() {
        if (this.helpFrame == null) {
            this.helpFrame = this.createHelpFrame();
        }
        return this.helpFrame;
    }

    protected TopFrame createTopFrame() {
        TopFrame result = new TopFrame();
        result.setVisible(false);
        this.windowSet.add(result);
        return result;
    }

    public TopFrame getTopFrame() {
        if (this.topFrame == null) {
            this.topFrame = this.createTopFrame();
        }
        return this.topFrame;
    }

    public void changeAllWindowUI() {
        for (Window window : this.windowSet) {
            WindowManager.updateTreeUI(window);
        }
        if (this.filterPanel != null) {
            this.filterPanel.pack();
        }
        if (this.findPanel != null) {
            this.findPanel.pack();
        }
        if (this.accountPanel != null) {
            this.accountPanel.pack();
        }
    }

    public static void updateTreeUI(Component comp) {
        WindowManager.updateTreeUI(comp, true);
    }

    public static void updateTreeUI(Component comp, boolean isRoot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.updateUI();
            JPopupMenu popup = jcomp.getComponentPopupMenu();
            if (popup != null) {
                WindowManager.updateTreeUI(popup, true);
            }
        }
        if (comp instanceof JMenu) {
            JMenu menu = (JMenu)comp;
            for (Component child : menu.getMenuComponents()) {
                WindowManager.updateTreeUI(child, false);
            }
        } else if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (Component child : cont.getComponents()) {
                WindowManager.updateTreeUI(child, false);
            }
        }
        if (isRoot) {
            comp.invalidate();
            comp.validate();
            comp.repaint();
        }
    }
}

