/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.log;

import java.awt.EventQueue;
import java.util.logging.Handler;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jp.sfjp.jindolf.dxchg.TextPopup;
import jp.sfjp.jindolf.log.LogUtils;
import jp.sfjp.jindolf.log.SwingDocHandler;
import jp.sfjp.jindolf.util.Monodizer;

public class LogPanel
extends JScrollPane {
    private static final Document DOC_EMPTY = new PlainDocument();
    private final Document document = new PlainDocument();
    private final Handler handler;
    private final JTextArea textarea = new JTextArea();

    public LogPanel() {
        this.handler = LogUtils.hasLoggingPermission() ? new SwingDocHandler(this.document) : null;
        this.textarea.setDocument(DOC_EMPTY);
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        Monodizer.monodize(this.textarea);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.textarea.setBorder(border);
        TextPopup popup = new TextPopup();
        this.textarea.setComponentPopupMenu(popup);
        this.setViewportView(this.textarea);
        DocWatcher docListener = new DocWatcher();
        this.document.addDocumentListener(docListener);
        AncestorWatcher ancestorListener = new AncestorWatcher();
        this.addAncestorListener(ancestorListener);
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void showLastPos() {
        if (this.textarea.getDocument() != this.document) {
            return;
        }
        final JScrollBar yPos = this.getVerticalScrollBar();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                yPos.setValue(Integer.MAX_VALUE);
            }
        });
    }

    private void attachModel() {
        if (this.textarea.getDocument() != this.document) {
            this.textarea.setDocument(this.document);
        }
        this.showLastPos();
    }

    private void detachModel() {
        if (this.textarea.getDocument() == DOC_EMPTY) {
            return;
        }
        this.textarea.setDocument(DOC_EMPTY);
    }

    public void clearLog() {
        block2: {
            try {
                int docLength = this.document.getLength();
                this.document.remove(0, docLength);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private final class DocWatcher
    implements DocumentListener {
        DocWatcher() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            LogPanel.this.showLastPos();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            LogPanel.this.showLastPos();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            LogPanel.this.showLastPos();
        }
    }

    private final class AncestorWatcher
    implements AncestorListener {
        AncestorWatcher() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            LogPanel.this.attachModel();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            LogPanel.this.detachModel();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

