/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.jindolf.dxchg;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jp.sfjp.jindolf.data.Avatar;
import jp.sfjp.jindolf.data.Period;
import jp.sfjp.jindolf.data.Talk;
import jp.sfjp.jindolf.data.Topic;
import jp.sfjp.jindolf.data.Village;
import jp.sfjp.jindolf.view.TopicFilter;
import jp.sourceforge.jindolf.corelib.TalkType;

public final class CsvExporter {
    private static final String[] ENCNAMES = new String[]{"UTF-8", "ISO-2022-JP", "ISO-2022-JP-2", "ISO-2022-JP-3", "ISO-2022-JP-2004", "EUC-JP", "x-euc-jp-linux", "x-eucJP-Open", "Shift_JIS", "windows-31j", "x-MS932_0213", "x-SJIS_0213", "x-PCK"};
    private static final String JPCHECK = "[]09AZ\u3042\u3093\u30a2\u30f3\uff71\uff9d\u3090\u3091\u30f5\u30f6\u30f4\u30f0\u30f1\u30ee\u4e9c\u7464\u51dc\u7199\u58f7\u58fa\u5c2d\u582f\u5ce0\u3012\u254b";
    private static final String CSVEXT = ".csv";
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";
    private static final int BUFSIZ = 1024;
    private static final List<Charset> CHARSET_LIST = CsvExporter.buildCharsetList();
    private static final FileFilter CSV_FILTER = new CsvFileFilter();
    private static final JComboBox<Charset> encodeBox = new JComboBox();
    private static final JFileChooser chooser = CsvExporter.buildChooser();

    private CsvExporter() {
        assert (false);
        throw new AssertionError();
    }

    private static boolean hasJPencoder(Charset cs) {
        if (!cs.canEncode()) {
            return false;
        }
        CharsetEncoder encoder = cs.newEncoder();
        try {
            if (encoder.canEncode(JPCHECK)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static List<Charset> buildCharsetList() {
        LinkedList<Charset> csList = new LinkedList<Charset>();
        for (String name : ENCNAMES) {
            Charset cs;
            if (!Charset.isSupported(name) || csList.contains(cs = Charset.forName(name)) || !CsvExporter.hasJPencoder(cs)) continue;
            csList.add(cs);
        }
        Charset defcs = Charset.defaultCharset();
        if (defcs.name().equals("windows-31j") && Charset.isSupported("Shift_JIS")) {
            defcs = Charset.forName("Shift_JIS");
        }
        if (CsvExporter.hasJPencoder(defcs) || csList.size() <= 0) {
            if (csList.contains(defcs)) {
                csList.remove(defcs);
            }
            csList.add(0, defcs);
        }
        return csList;
    }

    private static JFileChooser buildChooser() {
        JFileChooser result = new JFileChooser();
        result.setFileSelectionMode(0);
        result.setMultiSelectionEnabled(false);
        result.setFileHidingEnabled(true);
        result.setAcceptAllFileFilterUsed(true);
        result.setFileFilter(CSV_FILTER);
        JComponent accessory = CsvExporter.buildAccessory();
        result.setAccessory(accessory);
        return result;
    }

    private static JComponent buildAccessory() {
        for (Charset cs : CHARSET_LIST) {
            encodeBox.addItem(cs);
        }
        TitledBorder border = BorderFactory.createTitledBorder("\u51fa\u529b\u30a8\u30f3\u30b3\u30fc\u30c9");
        encodeBox.setBorder(border);
        JPanel accessory = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        accessory.setLayout(layout);
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 18;
        accessory.add(encodeBox, constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        accessory.add((Component)new JPanel(), constraints);
        return accessory;
    }

    private static void writeError(File file) {
        Component parent = null;
        String title = "\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc";
        String message = "\u30d5\u30a1\u30a4\u30eb\u300c" + file.toString() + "\u300d\n" + "\u306b\u66f8\u304d\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    private static boolean confirmOverwrite(File file) {
        Component parent = null;
        String title = "\u4e0a\u66f8\u304d\u78ba\u8a8d";
        String message = "\u65e2\u5b58\u306e\u30d5\u30a1\u30a4\u30eb\u300c" + file.toString() + "\u300d\n" + "\u3092\u4e0a\u66f8\u304d\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002\u7d9a\u3051\u307e\u3059\u304b\uff1f";
        int confirm = JOptionPane.showConfirmDialog(parent, message, title, 2, 2);
        return confirm == 0;
    }

    private static void setTitle(Period period) {
        Village village = period.getVillage();
        String villageName = village.getVillageName();
        String title = villageName + "\u6751 " + period.getCaption();
        title = title + "\u306e\u767a\u8a00\u3092CSV\u30d5\u30a1\u30a4\u30eb\u3078\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3059";
        chooser.setDialogTitle(title);
    }

    private static String createUniqueFileName(Period period) {
        String csvName;
        File current;
        File saveFile;
        Village village = period.getVillage();
        String villageName = village.getVillageName();
        String base = "JIN_" + villageName;
        switch (period.getType()) {
            case PROLOGUE: {
                base = base + "_Prologue";
                break;
            }
            case EPILOGUE: {
                base = base + "_Epilogue";
                break;
            }
            case PROGRESS: {
                base = base + "_Day";
                base = base + period.getDay();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int serial = 1;
        do {
            csvName = base;
            if (serial > 1) {
                csvName = csvName + "(" + serial + ")";
            }
            ++serial;
            csvName = csvName + CSVEXT;
        } while ((saveFile = new File(current = chooser.getCurrentDirectory(), csvName)).exists());
        return csvName;
    }

    private static void dumpPeriod(Appendable out, Period period, TopicFilter topicFilter) throws IOException {
        String day = String.valueOf(period.getDay());
        List<Topic> topicList = period.getTopicList();
        for (Topic topic : topicList) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkCount() <= 0 || topicFilter.isFiltered(talk)) continue;
            Avatar avatar = talk.getAvatar();
            String name = avatar.getName();
            int hour = talk.getHour();
            int minute = talk.getMinute();
            TalkType type = talk.getTalkType();
            CharSequence dialog = talk.getDialog();
            out.append(name).append(',');
            out.append(day).append(',');
            out.append(Character.forDigit(hour / 10, 10));
            out.append(Character.forDigit(hour % 10, 10));
            out.append(':');
            out.append(Character.forDigit(minute / 10, 10));
            out.append(Character.forDigit(minute % 10, 10));
            out.append(',');
            switch (type) {
                case PUBLIC: {
                    out.append("say");
                    break;
                }
                case PRIVATE: {
                    out.append("think");
                    break;
                }
                case WOLFONLY: {
                    out.append("whisper");
                    break;
                }
                case GRAVE: {
                    out.append("groan");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            out.append(',');
            CsvExporter.escapeCSV(out, dialog);
            out.append(CRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File exportPeriod(Period period, TopicFilter topicFilter) {
        OutputStream os;
        FileFilter filter;
        CsvExporter.setTitle(period);
        String uniqName = CsvExporter.createUniqueFileName(period);
        File uniqFile = new File(uniqName);
        chooser.setSelectedFile(uniqFile);
        int result = chooser.showSaveDialog(null);
        if (result != 0) {
            return null;
        }
        File selected = chooser.getSelectedFile();
        if (!CsvExporter.hasExtent(selected.getName()) && (filter = chooser.getFileFilter()) == CSV_FILTER) {
            String path = selected.getPath();
            path = path + CSVEXT;
            selected = new File(path);
        }
        if (selected.exists()) {
            if (!selected.isFile() || !selected.canWrite()) {
                CsvExporter.writeError(selected);
                return null;
            }
            boolean confirmed = CsvExporter.confirmOverwrite(selected);
            if (!confirmed) {
                return null;
            }
        } else {
            boolean confirmed;
            boolean created;
            try {
                created = selected.createNewFile();
            }
            catch (IOException e) {
                CsvExporter.writeError(selected);
                return null;
            }
            if (!created && !(confirmed = CsvExporter.confirmOverwrite(selected))) {
                return null;
            }
        }
        try {
            os = new FileOutputStream(selected);
        }
        catch (FileNotFoundException e) {
            CsvExporter.writeError(selected);
            return null;
        }
        os = new BufferedOutputStream(os, 1024);
        Charset cs = (Charset)encodeBox.getSelectedItem();
        boolean hasIOError = false;
        OutputStreamWriter writer = new OutputStreamWriter(os, cs);
        try {
            CsvExporter.dumpPeriod(writer, period, topicFilter);
        }
        catch (IOException e) {
            hasIOError = true;
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                hasIOError = true;
            }
        }
        if (hasIOError) {
            CsvExporter.writeError(selected);
        }
        return selected;
    }

    public static Appendable escapeCSV(Appendable app, CharSequence seq) throws IOException {
        app.append('\"');
        int length = seq.length();
        block4: for (int pos = 0; pos < length; ++pos) {
            char ch = seq.charAt(pos);
            switch (ch) {
                case '\"': {
                    app.append("\"\"");
                    continue block4;
                }
                case '\n': {
                    app.append(CRLF);
                    continue block4;
                }
                default: {
                    app.append(ch);
                }
            }
        }
        app.append('\"');
        return app;
    }

    public static boolean hasExtent(CharSequence filename, CharSequence extent) {
        int flength = filename.length();
        int elength = extent.length();
        if (elength < 2) {
            return false;
        }
        if (flength <= elength) {
            return false;
        }
        if (filename.charAt(0) == '.') {
            return false;
        }
        int offset = flength - elength;
        assert (offset > 0);
        for (int pos = 0; pos < elength; ++pos) {
            char ech = Character.toLowerCase(extent.charAt(pos));
            char fch = Character.toLowerCase(filename.charAt(pos + offset));
            if (fch == ech) continue;
            return false;
        }
        return true;
    }

    public static boolean hasExtent(CharSequence filename) {
        int length = filename.length();
        if (length < 3) {
            return false;
        }
        if (filename.charAt(0) == '.') {
            return false;
        }
        int lastPos = length - 1;
        if (filename.charAt(lastPos) == '.') {
            return false;
        }
        for (int pos = 1; pos <= lastPos - 1; ++pos) {
            char ch = filename.charAt(pos);
            if (ch != '.') continue;
            return true;
        }
        return false;
    }

    private static class CsvFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (!file.isFile()) {
                return false;
            }
            return CsvExporter.hasExtent(file.getName(), CsvExporter.CSVEXT);
        }

        @Override
        public String getDescription() {
            return "CSV\u30d5\u30a1\u30a4\u30eb (*.csv)";
        }
    }
}

