/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.parser.ChainedParser;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlParseException;

public abstract class AbstractParser
implements ChainedParser {
    protected static final String SPCHAR = " \\t\\n\\r";
    protected static final String SP_I = "[ \\t\\n\\r]*";
    private static final Pattern DUMMY_PATTERN = AbstractParser.compile("\u0000");
    private final ChainedParser parent;
    private DecodedContent content;
    private Matcher matcher;
    private String contextErrorMessage;

    protected static Pattern compile(CharSequence regex) {
        Pattern result = Pattern.compile(((Object)regex).toString(), 32);
        return result;
    }

    protected AbstractParser() {
        this(null);
    }

    protected AbstractParser(ChainedParser parent) {
        this.parent = parent;
        this.resetImpl();
    }

    private void resetImpl() {
        this.content = null;
        this.matcher = null;
        this.contextErrorMessage = null;
    }

    public void reset() {
        if (this.parent != null) {
            throw new UnsupportedOperationException();
        }
        this.resetImpl();
    }

    public void setContent(DecodedContent content) {
        if (this.parent != null) {
            throw new UnsupportedOperationException();
        }
        CharSequence rawContent = content.getRawContent();
        this.content = content;
        this.matcher = DUMMY_PATTERN.matcher(rawContent);
    }

    public DecodedContent getContent() {
        if (this.parent != null) {
            return this.parent.getContent();
        }
        return this.content;
    }

    public Matcher getMatcher() {
        if (this.parent != null) {
            return this.parent.getMatcher();
        }
        return this.matcher;
    }

    protected void setContextErrorMessage(String errorMessage) {
        this.contextErrorMessage = errorMessage;
    }

    protected HtmlParseException buildParseException() {
        HtmlParseException result = new HtmlParseException(this.contextErrorMessage, this.regionStart());
        return result;
    }

    protected void switchPattern(Pattern pattern) {
        this.getMatcher().usePattern(pattern);
    }

    protected void shrinkRegion() {
        int lastMatchedEnd;
        try {
            lastMatchedEnd = this.matchEnd();
        }
        catch (IllegalStateException e) {
            return;
        }
        int regionEnd = this.regionEnd();
        this.getMatcher().region(lastMatchedEnd, regionEnd);
    }

    protected boolean findProbe(Pattern pattern) {
        this.switchPattern(pattern);
        return this.getMatcher().find();
    }

    protected boolean lookingAtProbe(Pattern pattern) {
        this.switchPattern(pattern);
        return this.getMatcher().lookingAt();
    }

    protected boolean matchesProbe(Pattern pattern) {
        this.switchPattern(pattern);
        return this.getMatcher().matches();
    }

    protected void findAffirm(Pattern pattern) throws HtmlParseException {
        if (!this.findProbe(pattern)) {
            throw this.buildParseException();
        }
    }

    protected void lookingAtAffirm(Pattern pattern) throws HtmlParseException {
        if (!this.lookingAtProbe(pattern)) {
            throw this.buildParseException();
        }
    }

    protected void matchesAffirm(Pattern pattern) throws HtmlParseException {
        if (!this.matchesProbe(pattern)) {
            throw this.buildParseException();
        }
    }

    protected boolean isGroupMatched(int group) {
        return this.matchStart(group) >= 0;
    }

    protected int parseGroupedInt(int group) {
        int result = 0;
        CharSequence rawContent = this.getContent().getRawContent();
        int start = this.matchStart(group);
        int end = this.matchEnd(group);
        for (int pos = start; pos < end; ++pos) {
            char letter = rawContent.charAt(pos);
            int digit = Character.digit(letter, 10);
            result = result * 10 + digit;
        }
        return result;
    }

    protected int matchStart(int group) {
        return this.getMatcher().start(group);
    }

    protected int matchEnd(int group) {
        return this.getMatcher().end(group);
    }

    protected int matchStart() {
        return this.getMatcher().start();
    }

    protected int matchEnd() {
        return this.getMatcher().end();
    }

    protected int regionStart() {
        return this.getMatcher().regionStart();
    }

    protected int regionEnd() {
        return this.getMatcher().regionEnd();
    }

    protected void sweepSpace() {
        int regionStart;
        CharSequence rawContent = this.getContent().getRawContent();
        boolean hasSpace = false;
        int regionEnd = this.regionEnd();
        block3: for (regionStart = this.regionStart(); regionStart < regionEnd; ++regionStart) {
            char letter = rawContent.charAt(regionStart);
            switch (letter) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    hasSpace = true;
                    continue block3;
                }
            }
        }
        if (hasSpace) {
            this.getMatcher().region(regionStart, regionEnd);
        }
    }

    protected GameRole lookingAtRole() {
        GameRole role = GameRole.lookingAtRole(this.getMatcher());
        return role;
    }
}

