/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.nio.CharBuffer;
import java.text.AttributedCharacterIterator;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class TextEditor
extends JTextArea
implements InputMethodListener {
    private static final int MAX_DOCUMENT = 10000;
    private final DocumentFilter documentFilter = new CustomFilter();
    private boolean onIMEoperation = false;

    public TextEditor() {
        this.setLineWrap(true);
        this.setWrapStyleWord(false);
        PlainDocument document = new PlainDocument();
        this.setDocument(document);
        this.addInputMethodListener(this);
    }

    public boolean onIMEoperation() {
        return this.onIMEoperation;
    }

    public void scrollCaretToVisible() {
        Rectangle caretBounds;
        int caretPosition = this.getCaretPosition();
        try {
            caretBounds = this.modelToView(caretPosition);
        }
        catch (BadLocationException e) {
            assert (false);
            return;
        }
        this.scrollRectToVisible(caretBounds);
    }

    public final void setDocument(Document document) {
        AbstractDocument abstractDocument;
        Document oldDocument = this.getDocument();
        if (oldDocument instanceof AbstractDocument) {
            abstractDocument = (AbstractDocument)oldDocument;
            abstractDocument.setDocumentFilter(null);
        }
        super.setDocument(document);
        if (document instanceof AbstractDocument) {
            abstractDocument = (AbstractDocument)document;
            abstractDocument.setDocumentFilter(this.documentFilter);
        }
    }

    public void scrollRectToVisible(Rectangle rect) {
        if (!this.hasFocus()) {
            return;
        }
        super.scrollRectToVisible(rect);
    }

    public void caretPositionChanged(InputMethodEvent event) {
    }

    public void inputMethodTextChanged(InputMethodEvent event) {
        int committed = event.getCommittedCharacterCount();
        AttributedCharacterIterator aci = event.getText();
        if (aci == null) {
            this.onIMEoperation = false;
            return;
        }
        int begin = aci.getBeginIndex();
        int end = aci.getEndIndex();
        int span = end - begin;
        this.onIMEoperation = committed < span;
    }

    private class CustomFilter
    extends DocumentFilter {
        private boolean isValid(char ch) {
            if (TextEditor.this.onIMEoperation()) {
                return true;
            }
            if (ch == '\n') {
                return true;
            }
            if (ch == '\uffff') {
                return false;
            }
            if (Character.isISOControl(ch)) {
                return false;
            }
            if (Character.isHighSurrogate(ch)) {
                return false;
            }
            return !Character.isLowSurrogate(ch);
        }

        private String filter(CharSequence input) {
            if (TextEditor.this.onIMEoperation()) {
                return ((Object)input).toString();
            }
            int length = input.length();
            CharBuffer buf = CharBuffer.allocate(length);
            for (int pos = 0; pos < length; ++pos) {
                char ch = input.charAt(pos);
                if (ch == '\u2211') {
                    ch = '\u03a3';
                }
                if (ch == '\u00ac') {
                    ch = '\uffe2';
                }
                if (!this.isValid(ch)) continue;
                buf.append(ch);
            }
            buf.flip();
            return buf.toString();
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
            String filtered = this.filter(text);
            if (!TextEditor.this.onIMEoperation()) {
                Document document = fb.getDocument();
                int docLength = document.getLength();
                int rest = 10000 - docLength;
                if (rest < 0) {
                    return;
                }
                if (rest < filtered.length()) {
                    filtered = filtered.substring(0, rest);
                }
            }
            fb.insertString(offset, filtered, attrs);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            String filtered = this.filter(text);
            if (!TextEditor.this.onIMEoperation()) {
                Document document = fb.getDocument();
                int docLength = document.getLength();
                int rest = 10000 - (docLength -= length);
                if (rest < 0) {
                    return;
                }
                if (rest < filtered.length()) {
                    filtered = filtered.substring(0, rest);
                }
            }
            fb.replace(offset, length, filtered, attrs);
        }
    }
}

