/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.util.regex.Pattern;
import jp.sourceforge.jindolf.corelib.EventFamily;
import jp.sourceforge.jindolf.corelib.GameRole;
import jp.sourceforge.jindolf.corelib.SysEventType;
import jp.sourceforge.jindolf.corelib.Team;
import jp.sourceforge.jindolf.parser.AbstractParser;
import jp.sourceforge.jindolf.parser.ChainedParser;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.SeqRange;
import jp.sourceforge.jindolf.parser.SysEventHandler;

public class SysEventParser
extends AbstractParser {
    private static final String AVATAR_REGEX = "[^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+";
    private static final Pattern C_DIV_PATTERN = SysEventParser.compile("[ \\t\\n\\r]*</div>[ \\t\\n\\r]*");
    private static final Pattern AVATAR_PATTERN = SysEventParser.compile("[^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+");
    private SysEventHandler sysEventHandler;
    private int pushedRegionStart = -1;
    private int pushedRegionEnd = -1;
    private final SeqRange rangepool_1 = new SeqRange();
    private final SeqRange rangepool_2 = new SeqRange();
    private final SeqRange rangepool_3 = new SeqRange();
    private static final Pattern STARTENTRY_PATTERN = SysEventParser.compile("\u663c\u9593\u306f\u4eba\u9593\u306e\u3075\u308a\u3092\u3057\u3066\u3001\u591c\u306b\u6b63\u4f53\u3092\u73fe\u3059\u3068\u3044\u3046\u4eba\u72fc\u3002<br />\u305d\u306e\u4eba\u72fc\u304c\u3001\u3053\u306e\u6751\u306b\u7d1b\u308c\u8fbc\u3093\u3067\u3044\u308b\u3068\u3044\u3046\u5642\u304c\u5e83\u304c\u3063\u305f\u3002<br /><br />\u6751\u4eba\u9054\u306f\u534a\u4fe1\u534a\u7591\u306a\u304c\u3089\u3082\u3001\u6751\u306f\u305a\u308c\u306e\u5bbf\u306b\u96c6\u3081\u3089\u308c\u308b\u3053\u3068\u306b\u306a\u3063\u305f\u3002<br />");
    private static final Pattern STARTMIRROR_PATTERN = SysEventParser.compile("\u3055\u3042\u3001\u81ea\u3089\u306e\u59ff\u3092\u93e1\u306b\u6620\u3057\u3066\u307f\u3088\u3046\u3002<br />\u305d\u3053\u306b\u6620\u308b\u306e\u306f\u305f\u3060\u306e\u6751\u4eba\u304b\u3001\u305d\u308c\u3068\u3082\u8840\u306b\u98e2\u3048\u305f\u4eba\u72fc\u304b\u3002<br /><br />\u4f8b\u3048\u4eba\u72fc\u3067\u3082\u3001\u591a\u4eba\u6570\u3067\u7acb\u3061\u5411\u304b\u3048\u3070\u6016\u304f\u306f\u306a\u3044\u3002<br />\u554f\u984c\u306f\u3001\u3060\u308c\u304c\u4eba\u72fc\u306a\u306e\u304b\u3068\u3044\u3046\u4e8b\u3060\u3002<br />\u5360\u3044\u5e2b\u306e\u80fd\u529b\u3092\u6301\u3064\u4eba\u9593\u306a\u3089\u3070\u3001\u305d\u308c\u3092\u898b\u7834\u308c\u308b\u3060\u308d\u3046\u3002(?:<br />)?");
    private static final Pattern STARTASSAULT_PATTERN = SysEventParser.compile("\u3064\u3044\u306b\u72a0\u7272\u8005\u304c\u51fa\u305f\u3002\u4eba\u72fc\u306f\u3053\u306e\u6751\u4eba\u9054\u306e\u306a\u304b\u306b\u3044\u308b\u3002<br />\u3057\u304b\u3057\u3001\u305d\u308c\u3092\u898b\u5206\u3051\u308b\u624b\u6bb5\u306f\u306a\u3044\u3002<br /><br />\u6751\u4eba\u9054\u306f\u3001\u7591\u308f\u3057\u3044\u8005\u3092\u6392\u9664\u3059\u308b\u305f\u3081\u3001\u6295\u7968\u3092\u884c\u3046\u4e8b\u306b\u3057\u305f\u3002<br />\u7121\u5b9f\u306e\u72a0\u7272\u8005\u304c\u51fa\u308b\u306e\u3082\u3084\u3080\u3092\u3048\u306a\u3044\u3002\u6751\u304c\u5168\u6ec5\u3059\u308b\u3088\u308a\u306f\u2026\u2026\u3002<br /><br />\u6700\u5f8c\u307e\u3067\u6b8b\u308b\u306e\u306f\u6751\u4eba\u304b\u3001\u305d\u308c\u3068\u3082\u4eba\u72fc\u304b\u3002(?:<br />)?");
    private static final Pattern NOMURDER_PATTERN = SysEventParser.compile("\u4eca\u65e5\u306f\u72a0\u7272\u8005\u304c\u3044\u306a\u3044\u3088\u3046\u3060\u3002\u4eba\u72fc\u306f\u8972\u6483\u306b\u5931\u6557\u3057\u305f\u306e\u3060\u308d\u3046\u304b\u3002");
    private static final Pattern WINVILLAGE_PATTERN = SysEventParser.compile("\u5168\u3066\u306e\u4eba\u72fc\u3092\u9000\u6cbb\u3057\u305f\u2026\u2026\u3002\u4eba\u72fc\u306b\u602f\u3048\u308b\u65e5\u3005\u306f\u53bb\u3063\u305f\u306e\u3060\uff01(?:<br />)?");
    private static final Pattern WINWOLF_PATTERN = SysEventParser.compile("\u3082\u3046\u4eba\u72fc\u306b\u62b5\u6297\u3067\u304d\u308b\u307b\u3069\u6751\u4eba\u306f\u6b8b\u3063\u3066\u3044\u306a\u3044\u2026\u2026\u3002<br />\u4eba\u72fc\u306f\u6b8b\u3063\u305f\u6751\u4eba\u3092\u5168\u3066\u98df\u3089\u3044\u3001\u5225\u306e\u7372\u7269\u3092\u6c42\u3081\u3066\u3053\u306e\u6751\u3092\u53bb\u3063\u3066\u3044\u3063\u305f\u3002(?:<br />)?");
    private static final Pattern WINHAMSTER_PATTERN = SysEventParser.compile("\u5168\u3066\u306f\u7d42\u308f\u3063\u305f\u304b\u306e\u3088\u3046\u306b\u898b\u3048\u305f\u3002<br />\u3060\u304c\u3001\u5974\u304c\u751f\u304d\u6b8b\u3063\u3066\u3044\u305f\u2026\u2026\u3002");
    private static final Pattern PANIC_PATTERN = SysEventParser.compile("\u2026\u2026\u3002");
    private static Object[][] simpleRegexToType = new Object[][]{{STARTENTRY_PATTERN, SysEventType.STARTENTRY}, {STARTMIRROR_PATTERN, SysEventType.STARTMIRROR}, {STARTASSAULT_PATTERN, SysEventType.STARTASSAULT}, {NOMURDER_PATTERN, SysEventType.NOMURDER}, {WINVILLAGE_PATTERN, SysEventType.WINVILLAGE}, {WINWOLF_PATTERN, SysEventType.WINWOLF}, {WINHAMSTER_PATTERN, SysEventType.WINHAMSTER}, {PANIC_PATTERN, SysEventType.PANIC}};
    private static final Pattern OPENROLE_HEAD_PATTERN = SysEventParser.compile("\u3069\u3046\u3084\u3089\u3053\u306e\u4e2d\u306b\u306f\u3001");
    private static final Pattern OPENROLE_NUM_PATTERN = SysEventParser.compile("\u304c([0-9]+)\u540d(?:\u3001)?");
    private static final Pattern OPENROLE_TAIL_PATTERN = SysEventParser.compile("\u3044\u308b\u3088\u3046\u3060\u3002");
    private static final Pattern SURVIVOR_HEAD_PATTERN = SysEventParser.compile("\u73fe\u5728\u306e\u751f\u5b58\u8005\u306f\u3001");
    private static final Pattern SURVIVOR_PATTERN = Pattern.compile("([^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+)(?:(?:\u3001)|(?: \u306e ([0-9]+) \u540d\u3002))");
    private static final Pattern MURDERED_HEAD_PATTERN = SysEventParser.compile("\u6b21\u306e\u65e5\u306e\u671d\u3001");
    private static final Pattern MURDERED_SW_PATTERN = SysEventParser.compile("( \u3068 )|( \u304c\u7121\u6b8b\u306a\u59ff\u3067\u767a\u898b\u3055\u308c\u305f\u3002(?:<br />)?)");
    private static final Pattern ONSTAGE_NO_PATTERN = SysEventParser.compile("([0-9]+)\u4eba\u76ee\u3001");
    private static final Pattern ONSTAGE_DOT_PATTERN = SysEventParser.compile("((?:[^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+)|)\u3002");
    private static final Pattern SUDDENDEATH_PATTERN = SysEventParser.compile("((?:[^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+)|) ?\u306f\u3001\u7a81\u7136\u6b7b\u3057\u305f\u3002");
    private static final Pattern COUNTING_PATTERN = SysEventParser.compile("(?:<br />([^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+) \u306f\u6751\u4eba\u9054\u306e\u624b\u306b\u3088\u308a\u51e6\u5211\u3055\u308c\u305f\u3002)|(?:([^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+) \u306f ([^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+) \u306b\u6295\u7968\u3057\u305f\u3002(?:<br />)?)");
    private static final Pattern PLAYERID_PATTERN = SysEventParser.compile(" \uff08(?:<a href=\"([^\"]*)\">)?([^<]*)(?:</a>)?\uff09\u3001");
    private static final Pattern LIVEORDIE_PATTERN = SysEventParser.compile("(\u751f\u5b58\u3002)|(\u6b7b\u4ea1\u3002)");
    private static final Pattern PLAYER_DELIM_PATTERN = SysEventParser.compile("\u3060\u3063\u305f\u3002(?:<br />)?");
    private static final Pattern ASKENTRY_PATTERN = SysEventParser.compile("\u6f14\u3058\u305f\u3044\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u3092\u9078\u3073\u3001\u767a\u8a00\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br />([0-2][0-9]):([0-5][0-9]) \u306b([0-9]+)\u540d\u4ee5\u4e0a\u304c\u30a8\u30f3\u30c8\u30ea\u30fc\u3057\u3066\u3044\u308c\u3070\u9032\u884c\u3057\u307e\u3059\u3002<br />\u6700\u5927([0-9]+)\u540d\u307e\u3067\u53c2\u52a0\u53ef\u80fd\u3067\u3059\u3002<br /><br />\u203b\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53d6\u308a\u6d88\u305b\u307e\u305b\u3093\u3002\u30eb\u30fc\u30eb\u3092\u3088\u304f\u7406\u89e3\u3057\u305f\u4e0a\u3067\u3054\u53c2\u52a0\u4e0b\u3055\u3044\u3002<br />\u203b\u59cb\u3081\u3066\u306e\u65b9\u306f\u3001\u6751\u4eba\u5e0c\u671b\u3067\u306e\u53c2\u52a0\u3068\u306a\u308a\u307e\u3059\u3002<br />\u203b\u5e0c\u671b\u80fd\u529b\u306b\u3064\u3044\u3066\u306e\u767a\u8a00\u306f\u63a7\u3048\u3066\u304f\u3060\u3055\u3044\u3002<br />");
    private static final Pattern ASKCOMMIT_PATTERN = SysEventParser.compile("(?:([0-2][0-9]):([0-5][0-9]) \u307e\u3067\u306b\u3001\u8ab0\u3092\u51e6\u5211\u3059\u308b\u3079\u304d\u304b\u306e\u6295\u7968\u5148\u3092\u6c7a\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002<br />\u4e00\u756a\u7968\u3092\u96c6\u3081\u305f\u4eba\u7269\u304c\u51e6\u5211\u3055\u308c\u307e\u3059\u3002\u540c\u6570\u3060\u3063\u305f\u5834\u5408\u306f\u30e9\u30f3\u30c0\u30e0\u3067\u6c7a\u5b9a\u3055\u308c\u307e\u3059\u3002<br /><br />)?\u7279\u6b8a\u306a\u80fd\u529b\u3092\u6301\u3064\u4eba\u306f\u3001([0-2][0-9]):([0-5][0-9]) \u307e\u3067\u306b\u884c\u52d5\u3092\u78ba\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002<br />");
    private static final Pattern NOCOMMENT_HEAD_PATTERN = SysEventParser.compile("\u672c\u65e5\u307e\u3060\u767a\u8a00\u3057\u3066\u3044\u306a\u3044\u8005\u306f\u3001");
    private static final Pattern NOCOMMENT_AVATAR_PATTERN = SysEventParser.compile("(?:([^<\u3001 \\t\\n\\r]+ [^<\u3001\u3002 \\t\\n\\r]+)\u3001)|(?:\u4ee5\u4e0a ([0-9]+) \u540d\u3002)");
    private static final Pattern STAYEPILOGUE_PATTERN = SysEventParser.compile("(?:(\u6751\u4eba)|(\u4eba\u72fc)|(\u30cf\u30e0\u30b9\u30bf\u30fc))\u5074\u306e\u52dd\u5229\u3067\u3059\uff01<br />\u5168\u3066\u306e\u30ed\u30b0\u3068\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u516c\u958b\u3057\u307e\u3059\u3002([0-2][0-9]):([0-5][0-9]) \u307e\u3067\u81ea\u7531\u306b\u66f8\u304d\u8fbc\u3081\u307e\u3059\u306e\u3067\u3001\u4eca\u56de\u306e\u611f\u60f3\u306a\u3069\u3092\u3069\u3046\u305e\u3002<br />");
    private static final Pattern GAMEOVER_PATTERN = SysEventParser.compile("\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002<br />");
    private static final Pattern JUDGE_DELIM_PATTERN = SysEventParser.compile(" \u306f\u3001");
    private static final Pattern JUDGE_TAIL_PATTERN = SysEventParser.compile(" \u3092\u5360\u3063\u305f\u3002");
    private static final Pattern GUARD_DELIM_PATTERN = SysEventParser.compile(" \u306f\u3001");
    private static final Pattern GUARD_TAIL_PATTERN = SysEventParser.compile(" \u3092\u5b88\u3063\u3066\u3044\u308b\u3002");
    private static final Pattern CONTENT_PATTERN = SysEventParser.compile("([^<>\\n\\r]+)|(<br />)|(?:<a href=\"([^\"]*)\">([^<>]*)</a>)");

    public SysEventParser(ChainedParser parent) {
        super(parent);
    }

    public void setSysEventHandler(SysEventHandler sysEventHandler) {
        this.sysEventHandler = sysEventHandler;
    }

    public void parseAnnounce() throws HtmlParseException {
        boolean result;
        this.setContextErrorMessage("Unknown Announce message");
        this.sysEventHandler.startSysEvent(EventFamily.ANNOUNCE);
        int regionStart = this.regionStart();
        int regionEnd = this.regionEnd();
        boolean bl = result = this.probeSimpleAnnounce() || this.probeOpenRole() || this.probeSurvivor() || this.probeMurdered() || this.probeOnStage() || this.probeSuddenDeath() || this.probeCounting() || this.probePlayerList();
        if (!result) {
            throw this.buildParseException();
        }
        this.getMatcher().region(regionStart, regionEnd);
        this.parseContent();
        this.lookingAtAffirm(C_DIV_PATTERN);
        this.shrinkRegion();
        this.sysEventHandler.endSysEvent();
    }

    private boolean probeSimpleAnnounce() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        SysEventType matchedType = null;
        for (Object[] pair : simpleRegexToType) {
            Pattern pattern = (Pattern)pair[0];
            if (!this.lookingAtProbe(pattern)) continue;
            this.shrinkRegion();
            matchedType = (SysEventType)((Object)pair[1]);
            break;
        }
        if (matchedType == null) {
            this.popRegion();
            return false;
        }
        this.sysEventHandler.sysEventType(matchedType);
        this.sweepSpace();
        return true;
    }

    private boolean probeOpenRole() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(OPENROLE_HEAD_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.OPENROLE);
        while (true) {
            GameRole role;
            if ((role = this.lookingAtRole()) == null) {
                if (this.lookingAtProbe(OPENROLE_TAIL_PATTERN)) break;
                this.popRegion();
                return false;
            }
            this.shrinkRegion();
            if (!this.lookingAtProbe(OPENROLE_NUM_PATTERN)) {
                this.popRegion();
                return false;
            }
            int num = this.parseGroupedInt(1);
            this.shrinkRegion();
            this.sysEventHandler.sysEventOpenRole(role, num);
        }
        this.shrinkRegion();
        this.sweepSpace();
        return true;
    }

    private boolean probeSurvivor() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(SURVIVOR_HEAD_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.SURVIVOR);
        int avatarNum = 0;
        while (true) {
            if (!this.lookingAtProbe(SURVIVOR_PATTERN)) {
                this.popRegion();
                return false;
            }
            avatarRange.setLastMatchedGroupRange(this.getMatcher(), 1);
            this.sysEventHandler.sysEventSurvivor(this.getContent(), avatarRange);
            ++avatarNum;
            if (this.isGroupMatched(2)) {
                int num = this.parseGroupedInt(2);
                this.shrinkRegion();
                if (num == avatarNum) break;
                throw new HtmlParseException(this.regionStart());
            }
            this.shrinkRegion();
        }
        this.sweepSpace();
        return true;
    }

    private boolean probeMurdered() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        SeqRange avatarRange2 = this.rangepool_2;
        avatarRange.setInvalid();
        avatarRange2.setInvalid();
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(MURDERED_HEAD_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.MURDERED);
        while (true) {
            if (!this.lookingAtProbe(AVATAR_PATTERN)) {
                this.popRegion();
                return false;
            }
            if (!avatarRange.isValid()) {
                avatarRange.setLastMatchedRange(this.getMatcher());
            } else if (!avatarRange2.isValid()) {
                avatarRange2.setLastMatchedRange(this.getMatcher());
            } else {
                assert (false);
                throw this.buildParseException();
            }
            this.shrinkRegion();
            if (!this.lookingAtProbe(MURDERED_SW_PATTERN)) {
                this.popRegion();
                return false;
            }
            if (!this.isGroupMatched(1)) break;
            this.shrinkRegion();
        }
        if (!this.isGroupMatched(2)) {
            assert (false);
            throw this.buildParseException();
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventMurdered(this.getContent(), avatarRange);
        if (avatarRange2.isValid()) {
            this.sysEventHandler.sysEventMurdered(this.getContent(), avatarRange2);
        }
        this.sweepSpace();
        return true;
    }

    private boolean probeOnStage() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(ONSTAGE_NO_PATTERN)) {
            this.popRegion();
            return false;
        }
        int entryNo = this.parseGroupedInt(1);
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.ONSTAGE);
        if (!this.lookingAtProbe(ONSTAGE_DOT_PATTERN)) {
            this.popRegion();
            return false;
        }
        avatarRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        this.sysEventHandler.sysEventOnStage(this.getContent(), entryNo, avatarRange);
        this.sweepSpace();
        return true;
    }

    private boolean probeSuddenDeath() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(SUDDENDEATH_PATTERN)) {
            this.popRegion();
            return false;
        }
        avatarRange.setLastMatchedGroupRange(this.getMatcher(), 1);
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.SUDDENDEATH);
        this.sysEventHandler.sysEventSuddenDeath(this.getContent(), avatarRange);
        this.sweepSpace();
        return true;
    }

    private boolean probeCounting() throws HtmlParseException {
        SeqRange voteByRange = this.rangepool_1;
        SeqRange voteToRange = this.rangepool_2;
        this.pushRegion();
        this.sweepSpace();
        boolean hasVote = false;
        while (this.lookingAtProbe(COUNTING_PATTERN)) {
            if (this.isGroupMatched(1)) {
                voteByRange.setInvalid();
                voteToRange.setLastMatchedGroupRange(this.getMatcher(), 1);
                this.shrinkRegion();
                this.sysEventHandler.sysEventCounting(this.getContent(), voteByRange, voteToRange);
                break;
            }
            if (this.isGroupMatched(2)) {
                if (!hasVote) {
                    hasVote = true;
                    this.sysEventHandler.sysEventType(SysEventType.COUNTING);
                }
                voteByRange.setLastMatchedGroupRange(this.getMatcher(), 2);
                voteToRange.setLastMatchedGroupRange(this.getMatcher(), 3);
                this.shrinkRegion();
                this.sysEventHandler.sysEventCounting(this.getContent(), voteByRange, voteToRange);
                continue;
            }
            assert (false);
            throw this.buildParseException();
        }
        if (!hasVote) {
            this.popRegion();
            return false;
        }
        this.sweepSpace();
        return true;
    }

    private boolean probePlayerList() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        SeqRange anchorRange = this.rangepool_2;
        SeqRange accountRange = this.rangepool_3;
        this.pushRegion();
        this.sweepSpace();
        boolean hasPlayerList = false;
        while (this.lookingAtProbe(AVATAR_PATTERN)) {
            avatarRange.setLastMatchedRange(this.getMatcher());
            this.shrinkRegion();
            if (!this.lookingAtProbe(PLAYERID_PATTERN)) {
                this.popRegion();
                return false;
            }
            if (this.isGroupMatched(1)) {
                anchorRange.setLastMatchedGroupRange(this.getMatcher(), 1);
            } else {
                anchorRange.setInvalid();
            }
            accountRange.setLastMatchedGroupRange(this.getMatcher(), 2);
            this.shrinkRegion();
            boolean isLiving = false;
            if (!this.lookingAtProbe(LIVEORDIE_PATTERN)) {
                this.popRegion();
                return false;
            }
            if (this.isGroupMatched(1)) {
                isLiving = true;
            } else if (this.isGroupMatched(2)) {
                isLiving = false;
            }
            this.shrinkRegion();
            GameRole role = this.lookingAtRole();
            if (role == null) {
                this.popRegion();
                return false;
            }
            this.shrinkRegion();
            if (!this.lookingAtProbe(PLAYER_DELIM_PATTERN)) {
                this.popRegion();
                return false;
            }
            this.shrinkRegion();
            if (!hasPlayerList) {
                hasPlayerList = true;
                this.sysEventHandler.sysEventType(SysEventType.PLAYERLIST);
            }
            this.sysEventHandler.sysEventPlayerList(this.getContent(), avatarRange, anchorRange, accountRange, isLiving, role);
        }
        if (!hasPlayerList) {
            this.popRegion();
            return false;
        }
        this.sweepSpace();
        return true;
    }

    public void parseOrder() throws HtmlParseException {
        boolean result;
        this.setContextErrorMessage("Unknown Order message");
        this.sysEventHandler.startSysEvent(EventFamily.ORDER);
        int regionStart = this.regionStart();
        int regionEnd = this.regionEnd();
        boolean bl = result = this.probeAskEntry() || this.probeAskCommit() || this.probeNoComment() || this.probeStayEpilogue() || this.probeGameOver();
        if (!result) {
            throw this.buildParseException();
        }
        this.getMatcher().region(regionStart, regionEnd);
        this.parseContent();
        this.lookingAtAffirm(C_DIV_PATTERN);
        this.shrinkRegion();
        this.sysEventHandler.endSysEvent();
    }

    private boolean probeAskEntry() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(ASKENTRY_PATTERN)) {
            this.popRegion();
            return false;
        }
        int hour = this.parseGroupedInt(1);
        int minute = this.parseGroupedInt(2);
        int minLimit = this.parseGroupedInt(3);
        int maxLimit = this.parseGroupedInt(4);
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.ASKENTRY);
        this.sysEventHandler.sysEventAskEntry(hour, minute, minLimit, maxLimit);
        this.sweepSpace();
        return true;
    }

    private boolean probeAskCommit() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(ASKCOMMIT_PATTERN)) {
            this.popRegion();
            return false;
        }
        boolean is1stDay = !this.isGroupMatched(1);
        int hh1 = this.parseGroupedInt(1);
        int mm1 = this.parseGroupedInt(2);
        int hh2 = this.parseGroupedInt(3);
        int mm2 = this.parseGroupedInt(4);
        this.shrinkRegion();
        if (!(is1stDay || hh1 == hh2 && mm1 == mm2)) {
            throw new HtmlParseException(this.regionStart());
        }
        this.sysEventHandler.sysEventType(SysEventType.ASKCOMMIT);
        this.sysEventHandler.sysEventAskCommit(hh2, mm2);
        this.sweepSpace();
        return true;
    }

    private boolean probeNoComment() throws HtmlParseException {
        SeqRange avatarRange = this.rangepool_1;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(NOCOMMENT_HEAD_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.NOCOMMENT);
        int avatarNum = 0;
        while (true) {
            if (!this.lookingAtProbe(NOCOMMENT_AVATAR_PATTERN)) {
                this.popRegion();
                return false;
            }
            if (this.isGroupMatched(1)) {
                avatarRange.setLastMatchedGroupRange(this.getMatcher(), 1);
                this.sysEventHandler.sysEventNoComment(this.getContent(), avatarRange);
                this.shrinkRegion();
                ++avatarNum;
                continue;
            }
            if (this.isGroupMatched(2)) break;
        }
        int num = this.parseGroupedInt(2);
        this.shrinkRegion();
        if (num != avatarNum) {
            throw new HtmlParseException(this.regionStart());
        }
        this.sweepSpace();
        return true;
    }

    private boolean probeStayEpilogue() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(STAYEPILOGUE_PATTERN)) {
            this.popRegion();
            return false;
        }
        Team winner = null;
        if (this.isGroupMatched(1)) {
            winner = Team.VILLAGE;
        } else if (this.isGroupMatched(2)) {
            winner = Team.WOLF;
        } else if (this.isGroupMatched(3)) {
            winner = Team.HAMSTER;
        }
        int hour = this.parseGroupedInt(4);
        int minute = this.parseGroupedInt(5);
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.STAYEPILOGUE);
        this.sysEventHandler.sysEventStayEpilogue(winner, hour, minute);
        this.sweepSpace();
        return true;
    }

    private boolean probeGameOver() throws HtmlParseException {
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(GAMEOVER_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.GAMEOVER);
        this.sweepSpace();
        return true;
    }

    public void parseExtra() throws HtmlParseException {
        boolean result;
        this.setContextErrorMessage("Unknown Extra message");
        this.sysEventHandler.startSysEvent(EventFamily.EXTRA);
        int regionStart = this.regionStart();
        int regionEnd = this.regionEnd();
        boolean bl = result = this.probeJudge() || this.probeGuard();
        if (!result) {
            throw this.buildParseException();
        }
        this.getMatcher().region(regionStart, regionEnd);
        this.parseContent();
        this.lookingAtAffirm(C_DIV_PATTERN);
        this.shrinkRegion();
        this.sysEventHandler.endSysEvent();
    }

    private boolean probeJudge() throws HtmlParseException {
        SeqRange judgeByRange = this.rangepool_1;
        SeqRange judgeToRange = this.rangepool_2;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(AVATAR_PATTERN)) {
            this.popRegion();
            return false;
        }
        judgeByRange.setLastMatchedRange(this.getMatcher());
        this.shrinkRegion();
        if (!this.lookingAtProbe(JUDGE_DELIM_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        if (!this.lookingAtProbe(AVATAR_PATTERN)) {
            this.popRegion();
            return false;
        }
        judgeToRange.setLastMatchedRange(this.getMatcher());
        this.shrinkRegion();
        if (!this.lookingAtProbe(JUDGE_TAIL_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.JUDGE);
        this.sysEventHandler.sysEventJudge(this.getContent(), judgeByRange, judgeToRange);
        this.sweepSpace();
        return true;
    }

    private boolean probeGuard() throws HtmlParseException {
        SeqRange guardByRange = this.rangepool_1;
        SeqRange guardToRange = this.rangepool_2;
        this.pushRegion();
        this.sweepSpace();
        if (!this.lookingAtProbe(AVATAR_PATTERN)) {
            this.popRegion();
            return false;
        }
        guardByRange.setLastMatchedRange(this.getMatcher());
        this.shrinkRegion();
        if (!this.lookingAtProbe(GUARD_DELIM_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        if (!this.lookingAtProbe(AVATAR_PATTERN)) {
            this.popRegion();
            return false;
        }
        guardToRange.setLastMatchedRange(this.getMatcher());
        this.shrinkRegion();
        if (!this.lookingAtProbe(GUARD_TAIL_PATTERN)) {
            this.popRegion();
            return false;
        }
        this.shrinkRegion();
        this.sysEventHandler.sysEventType(SysEventType.GUARD);
        this.sysEventHandler.sysEventGuard(this.getContent(), guardByRange, guardToRange);
        this.sweepSpace();
        return true;
    }

    private void parseContent() throws HtmlParseException {
        SeqRange anchorRange = this.rangepool_1;
        SeqRange contentRange = this.rangepool_2;
        this.sweepSpace();
        while (this.lookingAtProbe(CONTENT_PATTERN)) {
            if (this.isGroupMatched(1)) {
                contentRange.setLastMatchedGroupRange(this.getMatcher(), 1);
                this.sysEventHandler.sysEventContent(this.getContent(), contentRange);
            } else if (this.isGroupMatched(2)) {
                this.sysEventHandler.sysEventContentBreak();
            } else if (this.isGroupMatched(3)) {
                anchorRange.setLastMatchedGroupRange(this.getMatcher(), 3);
                contentRange.setLastMatchedGroupRange(this.getMatcher(), 4);
                this.sysEventHandler.sysEventContentAnchor(this.getContent(), anchorRange, contentRange);
            }
            this.shrinkRegion();
        }
        this.sweepSpace();
    }

    private void pushRegion() {
        this.pushedRegionStart = this.regionStart();
        this.pushedRegionEnd = this.regionEnd();
    }

    private void popRegion() throws IllegalStateException {
        if (this.pushedRegionStart < 0 || this.pushedRegionEnd < 0) {
            throw new IllegalStateException();
        }
        if (this.pushedRegionStart != this.regionStart() || this.pushedRegionEnd != this.regionEnd()) {
            this.getMatcher().region(this.pushedRegionStart, this.pushedRegionEnd);
        }
        this.pushedRegionStart = -1;
        this.pushedRegionEnd = -1;
    }
}

