/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CoderResult;
import jp.sourceforge.jindolf.parser.ShiftJis;
import jp.sourceforge.jindolf.parser.StreamDecoder;

public class SjisDecoder
extends StreamDecoder {
    public static final int MIN_INBUFSZ = 5;

    public SjisDecoder() {
        this(4096, 4096);
    }

    public SjisDecoder(int inbuf_sz, int outbuf_sz) throws IllegalArgumentException {
        super(ShiftJis.CHARSET.newDecoder(), inbuf_sz, outbuf_sz);
        if (inbuf_sz < 5) {
            throw new IllegalArgumentException();
        }
    }

    private CoderResult modify1ByteError(CoderResult result) throws IOException {
        byte next;
        ByteBuffer inbuffer = this.getByteBuffer();
        int currPos = inbuffer.position();
        int nextPos = currPos + 1;
        if (nextPos >= inbuffer.limit()) {
            this.readByteBuffer();
            currPos = inbuffer.position();
            nextPos = currPos + 1;
        }
        if (nextPos >= inbuffer.limit()) {
            return result;
        }
        byte curr = inbuffer.get(currPos);
        if (ShiftJis.isShiftJIS(curr, next = inbuffer.get(nextPos))) {
            return CoderResult.unmappableForLength(2);
        }
        return result;
    }

    private CoderResult modify2ByteError(CoderResult result) {
        byte next;
        ByteBuffer inbuffer = this.getByteBuffer();
        int currPos = inbuffer.position();
        int nextPos = currPos + 1;
        byte curr = inbuffer.get(currPos);
        if (!ShiftJis.isShiftJIS(curr, next = inbuffer.get(nextPos))) {
            return CoderResult.malformedForLength(1);
        }
        return result;
    }

    protected int chopErrorSequence(CoderResult result) throws IOException {
        CoderResult newResult;
        int errorLength = result.length();
        if (errorLength == 1) {
            newResult = this.modify1ByteError(result);
        } else if (errorLength == 2) {
            newResult = this.modify2ByteError(result);
        } else {
            assert (false);
            return -1;
        }
        return super.chopErrorSequence(newResult);
    }
}

