/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.IOException;
import java.io.Reader;
import jp.sourceforge.jindolf.json.JsArray;
import jp.sourceforge.jindolf.json.JsBoolean;
import jp.sourceforge.jindolf.json.JsNull;
import jp.sourceforge.jindolf.json.JsNumber;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;
import jp.sourceforge.jindolf.json.JsVisitException;
import jp.sourceforge.jindolf.json.JsonAppender;
import jp.sourceforge.jindolf.json.JsonReader;

public final class Json {
    public static void writeJsonTop(Appendable appout, JsValue value) throws IOException, IllegalArgumentException {
        if (!(value instanceof JsObject) && !(value instanceof JsArray)) {
            throw new IllegalArgumentException();
        }
        JsonAppender appender = new JsonAppender(appout);
        try {
            value.traverse(appender);
        }
        catch (JsVisitException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            assert (false);
            return;
        }
        appender.flush();
    }

    public static boolean isWhitespace(char ch) {
        if (ch == '\t') {
            return true;
        }
        if (ch == '\r') {
            return true;
        }
        if (ch == '\n') {
            return true;
        }
        return ch == ' ';
    }

    static void skipWhiteSpace(JsonReader reader) throws IOException {
        int chData;
        while ((chData = reader.read()) >= 0) {
            if (Json.isWhitespace((char)chData)) continue;
            reader.unread(chData);
            break;
        }
    }

    static boolean parseConst(JsonReader reader, CharSequence text) throws IOException, IllegalArgumentException {
        int textLength = text.length();
        if (textLength <= 0) {
            return false;
        }
        if (textLength >= 10) {
            throw new IllegalArgumentException();
        }
        int[] backData = new int[textLength - 1];
        int readed = 0;
        while (true) {
            int chData;
            if ((chData = reader.read()) != text.charAt(readed)) {
                if (chData >= 0) {
                    reader.unread(chData);
                }
                for (int pos = readed - 1; pos >= 0; --pos) {
                    reader.unread(backData[pos]);
                }
                break;
            }
            if (readed >= backData.length) {
                return true;
            }
            backData[readed++] = chData;
        }
        return false;
    }

    public static JsValue parseValue(Reader reader) throws IOException, JsParseException {
        JsonReader jsreader = reader instanceof JsonReader ? (JsonReader)reader : new JsonReader(reader);
        return Json.parseValue(jsreader);
    }

    static JsValue parseValue(JsonReader reader) throws IOException, JsParseException {
        Json.skipWhiteSpace(reader);
        if (Json.parseConst(reader, JsNull.NULL.toString())) {
            return JsNull.NULL;
        }
        if (Json.parseConst(reader, JsBoolean.TRUE.toString())) {
            return JsBoolean.TRUE;
        }
        if (Json.parseConst(reader, JsBoolean.FALSE.toString())) {
            return JsBoolean.FALSE;
        }
        int head = reader.read();
        if (head < 0) {
            return null;
        }
        if (head == 45 || 48 <= head && head <= 57) {
            reader.unread(head);
            return JsNumber.parseNumber(reader);
        }
        if (head == 123) {
            reader.unread(head);
            return JsObject.parseObject(reader);
        }
        if (head == 91) {
            reader.unread(head);
            return JsArray.parseArray(reader);
        }
        if (head == 34) {
            reader.unread(head);
            return JsString.parseString(reader);
        }
        throw new JsParseException();
    }

    private Json() {
        assert (false);
        throw new AssertionError();
    }
}

