/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.jindolf.corelib.XmlResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreDefAvatar {
    private final String avatarId;
    private final String fullName;
    private final String jobTitle;
    private final String shortName;
    private final int serialNo;

    public static List<PreDefAvatar> buildPreDefAvatarList(DocumentBuilder builder) throws IOException, SAXException {
        Element list = PreDefAvatar.loadAvatarList(builder);
        List<PreDefAvatar> result = PreDefAvatar.elemToAvatarList(list);
        result = Collections.unmodifiableList(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element loadAvatarList(DocumentBuilder builder) throws IOException, SAXException {
        Document document;
        InputStream istream = XmlResource.I_URL_AVATARDEF.openStream();
        try {
            document = builder.parse(istream);
        }
        finally {
            istream.close();
        }
        Element root = document.getDocumentElement();
        String tagName = root.getTagName();
        if (!tagName.equals("preDefinedAvatarList")) {
            throw new SAXException("illegal root " + tagName);
        }
        return root;
    }

    private static List<PreDefAvatar> elemToAvatarList(Element list) throws SAXException {
        NodeList elems = list.getElementsByTagName("preDefinedAvatar");
        int avatarNum = elems.getLength();
        if (avatarNum <= 0) {
            throw new SAXException("there is no <preDefinedAvatar>");
        }
        ArrayList<PreDefAvatar> avatarList = new ArrayList<PreDefAvatar>(avatarNum);
        for (int index = 0; index < avatarNum; ++index) {
            Node node = elems.item(index);
            Element elem = (Element)node;
            PreDefAvatar avatar = PreDefAvatar.buildAvatar(elem);
            avatarList.add(avatar);
        }
        return avatarList;
    }

    private static PreDefAvatar buildAvatar(Element avatarDef) throws SAXException {
        int serialNo;
        String avatarId = avatarDef.getAttribute("avatarId");
        String jobTitle = avatarDef.getAttribute("jobTitle");
        String shortName = avatarDef.getAttribute("shortName");
        String serialNum = avatarDef.getAttribute("serialNum");
        String fullName = jobTitle + " " + shortName;
        try {
            serialNo = Integer.parseInt(serialNum);
        }
        catch (NumberFormatException e) {
            throw new SAXException("illegal number form", e);
        }
        PreDefAvatar avatar = new PreDefAvatar(avatarId, fullName, jobTitle, shortName, serialNo);
        return avatar;
    }

    private PreDefAvatar(String avatarId, String fullName, String jobTitle, String shortName, int serialNo) {
        if (avatarId == null || fullName == null || jobTitle == null || shortName == null) {
            throw new NullPointerException();
        }
        if (avatarId.length() <= 0 || fullName.length() <= 0 || serialNo < 0) {
            throw new IllegalArgumentException();
        }
        this.avatarId = avatarId.intern();
        this.fullName = fullName.intern();
        this.jobTitle = jobTitle.intern();
        this.shortName = shortName.intern();
        this.serialNo = serialNo;
    }

    public String getAvatarId() {
        return this.avatarId;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSerialNo() {
        return this.serialNo;
    }
}

