/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebIPC {
    private static final Class<?> DESKTOP_KLASS = WebIPC.getClass("java.awt.Desktop");
    private static final Method METHOD_ISDESKTOPSUPPORTED;
    private static final Method METHOD_GETDESKTOP;
    private static final Method METHOD_ISSUPPORTED;
    private static final Method METHOD_BROWSE;
    private static final Class<?> DESKTOP_ACTION_KLASS;
    private static final Enum<?> BROWSE_ENUM;
    private final Object desktop;

    private static Class<?> getClass(String klassName) {
        Class<?> result;
        try {
            result = Class.forName(klassName);
        }
        catch (ClassNotFoundException e) {
            result = null;
        }
        return result;
    }

    private static Class<?> getInnerClass(Class<?> parent, String canonical) {
        Class<?>[] innerKlasses;
        if (parent == null) {
            return null;
        }
        Class<?> result = null;
        for (Class<?> klass : innerKlasses = parent.getClasses()) {
            if (!klass.getCanonicalName().equals(canonical)) continue;
            result = klass;
            break;
        }
        return result;
    }

    private static Method getMethod(String methodName, Class<?> ... paramTypes) {
        Method result;
        if (DESKTOP_KLASS == null) {
            return null;
        }
        try {
            result = DESKTOP_KLASS.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            result = null;
        }
        return result;
    }

    private static Enum<?> getEnumMember(Class<?> parent, String memberName) {
        Object value;
        Field field;
        if (parent == null) {
            return null;
        }
        try {
            field = parent.getField(memberName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!(value instanceof Enum)) {
            return null;
        }
        return (Enum)value;
    }

    public static boolean isDesktopSupported() {
        Object invokeResult;
        if (METHOD_ISDESKTOPSUPPORTED == null) {
            return false;
        }
        try {
            invokeResult = METHOD_ISDESKTOPSUPPORTED.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        catch (IllegalAccessException e) {
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        if (!(invokeResult instanceof Boolean)) {
            assert (false);
            return false;
        }
        boolean result = (Boolean)invokeResult;
        return result;
    }

    public static WebIPC getWebIPC() throws HeadlessException, UnsupportedOperationException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!WebIPC.isDesktopSupported()) {
            throw new UnsupportedOperationException();
        }
        WebIPC webIPC = new WebIPC();
        return webIPC;
    }

    private WebIPC() throws HeadlessException, UnsupportedOperationException {
        try {
            this.desktop = METHOD_GETDESKTOP.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        catch (IllegalAccessException e) {
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
    }

    public void browse(URI uri) throws NullPointerException, UnsupportedOperationException, IOException, SecurityException, IllegalArgumentException {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (!this.isSupported(Action.BROWSE)) {
            throw new UnsupportedOperationException();
        }
        try {
            METHOD_BROWSE.invoke(this.desktop, uri);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        catch (IllegalAccessException e) {
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
    }

    public boolean isSupported(Action action) {
        Object invokeResult;
        switch (action) {
            case BROWSE: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            invokeResult = METHOD_ISSUPPORTED.invoke(this.desktop, BROWSE_ENUM);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        catch (IllegalAccessException e) {
            AssertionError thw = new AssertionError();
            ((Throwable)((Object)thw)).initCause(e);
            throw thw;
        }
        if (!(invokeResult instanceof Boolean)) {
            assert (false);
            return false;
        }
        boolean result = (Boolean)invokeResult;
        return result;
    }

    static {
        DESKTOP_ACTION_KLASS = WebIPC.getInnerClass(DESKTOP_KLASS, "java.awt.Desktop.Action");
        METHOD_ISDESKTOPSUPPORTED = WebIPC.getMethod("isDesktopSupported", new Class[0]);
        METHOD_GETDESKTOP = WebIPC.getMethod("getDesktop", new Class[0]);
        METHOD_ISSUPPORTED = WebIPC.getMethod("isSupported", DESKTOP_ACTION_KLASS);
        METHOD_BROWSE = WebIPC.getMethod("browse", URI.class);
        BROWSE_ENUM = WebIPC.getEnumMember(DESKTOP_ACTION_KLASS, "BROWSE");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        BROWSE;

    }
}

