/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class UriExporter
implements Transferable {
    private static final String[] MIMES = new String[]{"text/uri-list", "text/plain"};
    private static final List<DataFlavor> URI_FLAVORS = new ArrayList<DataFlavor>(MIMES.length);
    private final URI uri;

    public UriExporter(URI uri) {
        this.uri = uri;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[URI_FLAVORS.size()];
        int index = 0;
        for (DataFlavor dataFlavor : URI_FLAVORS) {
            try {
                result[index++] = (DataFlavor)dataFlavor.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor dataFlavor : URI_FLAVORS) {
            if (!dataFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        String result = this.uri.toASCIIString();
        return result;
    }

    static {
        String stringClassName = "class=" + String.class.getName();
        for (String mime : MIMES) {
            DataFlavor dataFlavor;
            String newMime = mime + "; " + stringClassName;
            try {
                dataFlavor = new DataFlavor(newMime);
            }
            catch (ClassNotFoundException e) {
                assert (false);
                throw new ExceptionInInitializerError(e);
            }
            URI_FLAVORS.add(dataFlavor);
        }
    }
}

