/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import jp.sourceforge.jindolf.json.JsNumber;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsPair;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;

public class ProxyInfo {
    public static final InetSocketAddress IP4SOCKET_NOBODY = InetSocketAddress.createUnresolved("0.0.0.0", 0);
    public static final ProxyInfo DEFAULT = new ProxyInfo();
    private static final String HASH_TYPE = "type";
    private static final String HASH_HOST = "host";
    private static final String HASH_PORT = "port";
    private final Proxy proxy;
    private final InetSocketAddress inetAddr;

    public static JsObject buildJson(ProxyInfo proxyInfo) {
        JsPair type = new JsPair(HASH_TYPE, proxyInfo.getType().name());
        JsPair host = new JsPair(HASH_HOST, proxyInfo.getHostName());
        JsPair port = new JsPair(HASH_PORT, proxyInfo.getPort());
        JsObject result = new JsObject();
        result.putPair(type);
        result.putPair(host);
        result.putPair(port);
        return result;
    }

    public static ProxyInfo decodeJson(JsObject obj) {
        Proxy.Type type = Proxy.Type.DIRECT;
        JsValue value = obj.getValue(HASH_TYPE);
        if (value instanceof JsString) {
            JsString string = (JsString)value;
            try {
                type = Enum.valueOf(Proxy.Type.class, string.toRawString());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        String host = "0.0.0.0";
        value = obj.getValue(HASH_HOST);
        if (value instanceof JsString) {
            JsString string = (JsString)value;
            host = string.toRawString();
        }
        int port = 0;
        value = obj.getValue(HASH_PORT);
        if (value instanceof JsNumber) {
            JsNumber number = (JsNumber)value;
            port = number.intValue();
        }
        return new ProxyInfo(type, host, port);
    }

    public ProxyInfo() {
        this(Proxy.NO_PROXY);
    }

    public ProxyInfo(Proxy proxy) {
        this.proxy = proxy;
        if (this.proxy.type() == Proxy.Type.DIRECT) {
            this.inetAddr = IP4SOCKET_NOBODY;
        } else {
            SocketAddress addr = this.proxy.address();
            if (!(addr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException();
            }
            this.inetAddr = (InetSocketAddress)addr;
        }
    }

    public ProxyInfo(Proxy.Type type, String hostName, int port) {
        this(type, InetSocketAddress.createUnresolved(hostName, port));
    }

    public ProxyInfo(Proxy.Type type, InetSocketAddress inetAddr) {
        if (type == null || inetAddr == null) {
            throw new NullPointerException();
        }
        this.proxy = type == Proxy.Type.DIRECT ? Proxy.NO_PROXY : new Proxy(type, inetAddr);
        this.inetAddr = inetAddr;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyInfo target = (ProxyInfo)obj;
        boolean result = this.proxy.equals(target.proxy);
        if (result) {
            result = this.inetAddr.equals(target.inetAddr);
        }
        return result;
    }

    public int hashCode() {
        return this.proxy.hashCode() ^ this.inetAddr.hashCode();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Proxy.Type getType() {
        return this.proxy.type();
    }

    public InetSocketAddress address() {
        return this.inetAddr;
    }

    public String getHostName() {
        return this.inetAddr.getHostName();
    }

    public int getPort() {
        return this.inetAddr.getPort();
    }
}

