/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.parser;

import java.nio.charset.CharsetDecoder;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.DecodeHandler;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.ShiftJis;

public class ContentBuilder
implements DecodeHandler {
    private DecodedContent content;
    private boolean hasByte1st;
    private byte byte1st;

    public ContentBuilder() {
        this(128);
    }

    public ContentBuilder(int capacity) throws NegativeArraySizeException {
        this.content = new DecodedContent(capacity);
        this.initImpl();
    }

    public DecodedContent getContent() {
        return this.content;
    }

    private void initImpl() {
        this.content.init();
        this.hasByte1st = false;
        this.byte1st = 0;
    }

    protected void init() {
        this.initImpl();
    }

    protected void flushError() {
        if (this.hasByte1st) {
            this.content.addDecodeError(this.byte1st);
            this.hasByte1st = false;
        }
    }

    public void startDecoding(CharsetDecoder decoder) throws DecodeException {
        this.init();
    }

    public void endDecoding() throws DecodeException {
        this.flushError();
    }

    public void charContent(CharSequence seq) throws DecodeException {
        this.flushError();
        this.content.append(seq);
    }

    public void decodingError(byte[] errorArray, int offset, int length) throws DecodeException {
        int limit = offset + length;
        for (int bpos = offset; bpos < limit; ++bpos) {
            byte bval = errorArray[bpos];
            if (!this.hasByte1st) {
                if (ShiftJis.isShiftJIS1stByte(bval)) {
                    this.byte1st = bval;
                    this.hasByte1st = true;
                    continue;
                }
                this.content.addDecodeError(bval);
                continue;
            }
            if (ShiftJis.isShiftJIS2ndByte(bval)) {
                this.content.addDecodeError(this.byte1st, bval);
                this.hasByte1st = false;
                continue;
            }
            if (ShiftJis.isShiftJIS1stByte(bval)) {
                this.content.addDecodeError(this.byte1st);
                this.byte1st = bval;
                this.hasByte1st = true;
                continue;
            }
            this.content.addDecodeError(this.byte1st);
            this.content.addDecodeError(bval);
            this.hasByte1st = false;
        }
    }
}

