/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.json;

import java.io.Flushable;
import java.io.IOException;
import java.util.Stack;
import jp.sourceforge.jindolf.json.JsArray;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsString;
import jp.sourceforge.jindolf.json.JsValue;
import jp.sourceforge.jindolf.json.JsVisitException;
import jp.sourceforge.jindolf.json.ValueVisitor;

public class JsonAppender
implements ValueVisitor,
Flushable {
    private static final String NEWLINE = "\n";
    private static final String INDENT_UNIT = "  ";
    private static final String HASH_SEPARATOR = " : ";
    private static final String ELEM_DELIMITOR = " ,";
    private final Appendable appout;
    private final Stack<JsValue> valueStack = new Stack();
    private final Stack<Boolean> hasChildStack = new Stack();
    private boolean afterPairName = false;

    public JsonAppender(Appendable appout) {
        this.appout = appout;
    }

    protected void append(char ch) throws IOException {
        this.appout.append(ch);
    }

    protected void append(CharSequence seq) throws IOException {
        this.appout.append(seq);
    }

    public void flush() throws IOException {
        this.putNewLine();
        if (this.appout instanceof Flushable) {
            ((Flushable)((Object)this.appout)).flush();
        }
    }

    protected void putNewLine() throws IOException {
        this.append(NEWLINE);
    }

    protected void indentOut() throws IOException {
        int level = this.stackLength();
        for (int ct = 1; ct <= level; ++ct) {
            this.append(INDENT_UNIT);
        }
    }

    protected void putElemDelimitor() throws IOException {
        this.append(ELEM_DELIMITOR);
    }

    protected void putPairName(String name) throws IOException {
        JsString.writeText(this.appout, name);
    }

    protected void putPairSeparator() throws IOException {
        this.append(HASH_SEPARATOR);
    }

    protected void pushValue(JsValue value) throws IllegalArgumentException {
        if (!(value instanceof JsObject) && !(value instanceof JsArray)) {
            throw new IllegalArgumentException();
        }
        this.valueStack.push(value);
        this.hasChildStack.push(false);
    }

    protected JsValue popValue() {
        this.hasChildStack.pop();
        return this.valueStack.pop();
    }

    protected int stackLength() {
        return this.valueStack.size();
    }

    protected boolean hasChildOut() {
        if (this.stackLength() <= 0) {
            return false;
        }
        return this.hasChildStack.peek();
    }

    protected void setChildOut() {
        if (this.stackLength() <= 0) {
            return;
        }
        this.hasChildStack.pop();
        this.hasChildStack.push(true);
    }

    public void visitValue(JsValue value) throws JsVisitException {
        try {
            if (!this.afterPairName) {
                if (this.hasChildOut()) {
                    this.putElemDelimitor();
                }
                this.putNewLine();
                this.indentOut();
            }
            this.afterPairName = false;
            this.setChildOut();
            if (value instanceof JsObject) {
                this.append('{');
                this.pushValue(value);
            } else if (value instanceof JsArray) {
                this.append('[');
                this.pushValue(value);
            } else {
                this.append(value.toString());
            }
        }
        catch (IOException e) {
            throw new JsVisitException(e);
        }
    }

    public void visitPairName(String name) throws JsVisitException {
        try {
            if (this.hasChildOut()) {
                this.putElemDelimitor();
            }
            this.putNewLine();
            this.indentOut();
            this.putPairName(name);
            this.putPairSeparator();
        }
        catch (IOException e) {
            throw new JsVisitException(e);
        }
        this.setChildOut();
        this.afterPairName = true;
    }

    public void visitCollectionClose(JsValue composite) throws JsVisitException {
        block7: {
            boolean hasChild = this.hasChildOut();
            JsValue value = this.popValue();
            try {
                if (hasChild) {
                    this.putNewLine();
                    this.indentOut();
                } else {
                    this.append(' ');
                }
                if (value instanceof JsObject) {
                    this.append('}');
                    break block7;
                }
                if (value instanceof JsArray) {
                    this.append(']');
                    break block7;
                }
                assert (false);
                throw new JsVisitException();
            }
            catch (IOException e) {
                throw new JsVisitException(e);
            }
        }
    }
}

