/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.corelib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.XmlResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LandDef {
    public static final String IMAGE_RELPATH = "./plugin_wolf/img/";
    public static final String DEF_FACE_URI_TMPL = "./plugin_wolf/img/face{0,number,#00}.jpg";
    public static final String DEF_BODY_URI_TMPL = "./plugin_wolf/img/body{0,number,#00}.jpg";
    public static final URI DEF_TOMBFACE_URI = URI.create("./plugin_wolf/img/face99.jpg").normalize();
    public static final URI DEF_TOMBBODY_URI = URI.create("./plugin_wolf/img/body99.jpg").normalize();
    private static final Map<String, LandState> STATE_MAP = new HashMap<String, LandState>();
    private static final Pattern ISO8601_PATTERN;
    private String landName;
    private String landId;
    private String formalName;
    private String landPrefix;
    private LandState landState;
    private int minMembers;
    private int maxMembers;
    private URI webURI;
    private URI cgiURI;
    private URI tombFaceIconURI;
    private URI tombBodyIconURI;
    private String faceURITemplate;
    private String bodyURITemplate;
    private Locale locale;
    private Charset encoding;
    private TimeZone timeZone;
    private long startDateTime;
    private long endDateTime;
    private String description;
    private String contactInfo;
    private int[] invalidVid;

    public static long parseISO8601(CharSequence date) throws IllegalArgumentException {
        Matcher matcher = ISO8601_PATTERN.matcher(date);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(((Object)date).toString());
        }
        int gid = 1;
        String yearStr = matcher.group(gid++);
        String monthStr = matcher.group(gid++);
        String dayStr = matcher.group(gid++);
        String hourStr = matcher.group(gid++);
        String minuteStr = matcher.group(gid++);
        String secondStr = matcher.group(gid++);
        String tzString = matcher.group(gid++);
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        int day = Integer.parseInt(dayStr);
        int hour = Integer.parseInt(hourStr);
        int minute = Integer.parseInt(minuteStr);
        int second = Integer.parseInt(secondStr);
        String tzID = "GMT";
        tzID = tzString.compareToIgnoreCase("Z") == 0 ? tzID + "+00:00" : tzID + tzString;
        TimeZone timezone = TimeZone.getTimeZone(tzID);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        ((Calendar)calendar).setTimeZone(timezone);
        calendar.set(year, month - 1, day, hour, minute, second);
        long result = calendar.getTimeInMillis();
        return result;
    }

    private static void parseIntPair(Set<Integer> intSet, CharSequence seq) throws IllegalArgumentException {
        int ivalEnd;
        int ivalStart;
        String token = ((Object)seq).toString();
        String[] ivalues = token.split("-");
        assert (ivalues.length >= 1);
        if (ivalues.length >= 3) {
            throw new IllegalArgumentException(token);
        }
        try {
            ivalStart = Integer.parseInt(ivalues[0]);
            ivalEnd = ivalues.length >= 2 ? Integer.parseInt(ivalues[1]) : ivalStart;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(token, e);
        }
        if (ivalStart > ivalEnd) {
            int dummy = ivalStart;
            ivalStart = ivalEnd;
            ivalEnd = dummy;
            assert (ivalStart <= ivalEnd);
        }
        for (int ival = ivalStart; ival <= ivalEnd; ++ival) {
            intSet.add(ival);
        }
    }

    public static SortedSet<Integer> parseIntList(CharSequence seq) throws IllegalArgumentException {
        TreeSet<Integer> result = new TreeSet<Integer>();
        if (seq.length() <= 0) {
            return result;
        }
        String str = ((Object)seq).toString();
        str = str.replaceAll("\\p{Blank}", "");
        String[] tokens = str.split(",");
        assert (tokens.length >= 1);
        for (String token : tokens) {
            if (token.length() <= 0) continue;
            if (token.charAt(0) == '-' || token.endsWith("-")) {
                throw new IllegalArgumentException(token);
            }
            LandDef.parseIntPair(result, token);
        }
        return result;
    }

    public static List<LandDef> buildLandDefList(DocumentBuilder builder) throws IOException, SAXException {
        Element landDefList = LandDef.loadLandDefList(builder);
        List<LandDef> result = LandDef.elemToLandDefList(landDefList);
        result = Collections.unmodifiableList(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element loadLandDefList(DocumentBuilder builder) throws IOException, SAXException {
        Document document;
        InputStream istream = XmlResource.I_URL_LANDDEF.openStream();
        try {
            document = builder.parse(istream);
        }
        finally {
            istream.close();
        }
        Element root = document.getDocumentElement();
        String tagName = root.getTagName();
        if (!tagName.equals("landDefList")) {
            throw new SAXException("illegal root " + tagName);
        }
        return root;
    }

    private static List<LandDef> elemToLandDefList(Element list) throws SAXException {
        NodeList elems = list.getElementsByTagName("landDef");
        int landNum = elems.getLength();
        if (landNum <= 0) {
            throw new SAXException("there is no <landDef>");
        }
        ArrayList<LandDef> landDefList = new ArrayList<LandDef>(landNum);
        for (int index = 0; index < landNum; ++index) {
            Node node = elems.item(index);
            Element elem = (Element)node;
            LandDef landDef = LandDef.buildLandDef(elem);
            landDefList.add(landDef);
        }
        return landDefList;
    }

    private static String attrRequired(Element elem, String attrName) throws SAXException {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr == null) {
            throw new SAXException("no attribute[" + attrName + "]");
        }
        String result = attr.getValue();
        if (result == null) {
            throw new SAXException("no attribute[" + attrName + "]");
        }
        return result;
    }

    public static Locale buildLocale(CharSequence attrVal) {
        String lang = "";
        String country = "";
        String variant = "";
        String[] lcstr = ((Object)attrVal).toString().split("-", 3);
        if (lcstr.length >= 1) {
            lang = lcstr[0];
        }
        if (lcstr.length >= 2) {
            country = lcstr[1];
        }
        if (lcstr.length >= 3) {
            variant = lcstr[2];
        }
        Locale locale = new Locale(lang, country, variant);
        return locale;
    }

    private static void fillIdInfo(LandDef result, Element elem) throws SAXException {
        String landName = LandDef.attrRequired(elem, "landName");
        String landId = LandDef.attrRequired(elem, "landId");
        String formalName = LandDef.attrRequired(elem, "formalName");
        String landPrefix = LandDef.attrRequired(elem, "landPrefix");
        if (landName.length() <= 0 || landId.length() <= 0 || formalName.length() <= 0) {
            throw new SAXException("no identification info");
        }
        result.landName = landName;
        result.landId = landId;
        result.formalName = formalName;
        result.landPrefix = landPrefix;
    }

    private static void fillMemberInfo(LandDef result, Element elem) throws SAXException {
        String minStr = LandDef.attrRequired(elem, "minMembers");
        String maxStr = LandDef.attrRequired(elem, "maxMembers");
        int minMembers = Integer.parseInt(minStr);
        int maxMembers = Integer.parseInt(maxStr);
        if (minMembers <= 0 || minMembers > maxMembers) {
            throw new SAXException("invalid member limitation");
        }
        result.minMembers = minMembers;
        result.maxMembers = maxMembers;
    }

    private static URI attrToUri(Element elem, String attrName) throws SAXException {
        URI uri;
        Attr attr = elem.getAttributeNode(attrName);
        if (attr == null) {
            return null;
        }
        String uriText = attr.getValue();
        if (uriText == null) {
            return null;
        }
        try {
            uri = new URI(uriText).normalize();
        }
        catch (URISyntaxException e) {
            throw new SAXException("illegal URI " + uriText, e);
        }
        return uri;
    }

    private static void fillUriInfo(LandDef result, Element elem) throws SAXException {
        URI webURI = LandDef.attrToUri(elem, "webURI");
        URI cgiURI = LandDef.attrToUri(elem, "cgiURI");
        if (webURI == null || cgiURI == null) {
            throw new SAXException("no URI");
        }
        if (!webURI.isAbsolute() || !cgiURI.isAbsolute()) {
            throw new SAXException("relative URI");
        }
        URI tombFaceIconURI = LandDef.attrToUri(elem, "tombFaceIconURI");
        URI tombBodyIconURI = LandDef.attrToUri(elem, "tombBodyIconURI");
        if (tombFaceIconURI == null) {
            tombFaceIconURI = DEF_TOMBFACE_URI;
        }
        if (tombBodyIconURI == null) {
            tombBodyIconURI = DEF_TOMBBODY_URI;
        }
        result.webURI = webURI;
        result.cgiURI = cgiURI;
        result.tombFaceIconURI = tombFaceIconURI;
        result.tombBodyIconURI = tombBodyIconURI;
    }

    private static void fillTemplateInfo(LandDef result, Element elem) throws SAXException {
        String faceURITemplate = null;
        String bodyURITemplate = null;
        Attr faceAttr = elem.getAttributeNode("faceIconURITemplate");
        Attr bodyAttr = elem.getAttributeNode("bodyIconURITemplate");
        if (faceAttr != null) {
            faceURITemplate = faceAttr.getValue();
        }
        if (bodyAttr != null) {
            bodyURITemplate = bodyAttr.getValue();
        }
        if (faceURITemplate == null) {
            faceURITemplate = DEF_FACE_URI_TMPL;
        }
        if (bodyURITemplate == null) {
            bodyURITemplate = DEF_BODY_URI_TMPL;
        }
        result.faceURITemplate = faceURITemplate;
        result.bodyURITemplate = bodyURITemplate;
    }

    private static void fillI18NInfo(LandDef result, Element elem) throws SAXException {
        String localeText = LandDef.attrRequired(elem, "locale");
        String encodingText = LandDef.attrRequired(elem, "encoding");
        String timeZoneText = LandDef.attrRequired(elem, "timeZone");
        Locale locale = LandDef.buildLocale(localeText);
        Charset encoding = Charset.forName(encodingText);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneText);
        result.locale = locale;
        result.encoding = encoding;
        result.timeZone = timeZone;
    }

    private static void fillDateInfo(LandDef result, Element elem) throws SAXException {
        String startDateText = LandDef.attrRequired(elem, "startDate");
        String endDateText = elem.getAttribute("endDate");
        long startDateTime = LandDef.parseISO8601(startDateText);
        long endDateTime = endDateText.length() > 0 ? LandDef.parseISO8601(endDateText) : -1L;
        if (startDateTime < 0L) {
            throw new SAXException("illegal start date " + startDateText);
        }
        if (endDateTime >= 0L && startDateTime > endDateTime) {
            throw new SAXException("start date is too old " + startDateText);
        }
        result.startDateTime = startDateTime;
        result.endDateTime = endDateTime;
    }

    private static void fillLandInfo(LandDef result, Element elem) throws SAXException {
        String state = LandDef.attrRequired(elem, "landState");
        LandState landState = STATE_MAP.get(state);
        if (landState == null) {
            throw new SAXException("illegal land status " + state);
        }
        String description = LandDef.attrRequired(elem, "description");
        String contactInfo = LandDef.attrRequired(elem, "contactInfo");
        String invalidVid = elem.getAttribute("invalidVid");
        SortedSet<Integer> invalidSet = LandDef.parseIntList(invalidVid);
        int[] invalidArray = new int[invalidSet.size()];
        int pos = 0;
        Iterator i$ = invalidSet.iterator();
        while (i$.hasNext()) {
            int vid = (Integer)i$.next();
            invalidArray[pos++] = vid;
        }
        result.landState = landState;
        result.description = description;
        result.contactInfo = contactInfo;
        result.invalidVid = invalidArray;
    }

    private static LandDef buildLandDef(Element elem) throws SAXException {
        LandDef result = new LandDef();
        LandDef.fillLandInfo(result, elem);
        LandDef.fillIdInfo(result, elem);
        LandDef.fillMemberInfo(result, elem);
        LandDef.fillUriInfo(result, elem);
        LandDef.fillTemplateInfo(result, elem);
        LandDef.fillI18NInfo(result, elem);
        LandDef.fillDateInfo(result, elem);
        return result;
    }

    private LandDef() {
    }

    public String getLandName() {
        return this.landName;
    }

    public String getLandId() {
        return this.landId;
    }

    public String getFormalName() {
        return this.formalName;
    }

    public String getLandPrefix() {
        return this.landPrefix;
    }

    public LandState getLandState() {
        return this.landState;
    }

    public int getMinMembers() {
        return this.minMembers;
    }

    public int getMaxMembers() {
        return this.maxMembers;
    }

    public URI getWebURI() {
        return this.webURI;
    }

    public URI getCgiURI() {
        return this.cgiURI;
    }

    public URI getTombFaceIconURI() {
        return this.tombFaceIconURI;
    }

    public URI getTombBodyIconURI() {
        return this.tombBodyIconURI;
    }

    public String getFaceURITemplate() {
        return this.faceURITemplate;
    }

    public String getBodyURITemplate() {
        return this.bodyURITemplate;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public TimeZone getTimeZone() {
        TimeZone result = (TimeZone)this.timeZone.clone();
        return result;
    }

    public long getStartDateTime() {
        return this.startDateTime;
    }

    public long getEndDateTime() {
        return this.endDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public boolean isValidVillageId(int vid) {
        int pos = Arrays.binarySearch(this.invalidVid, vid);
        return pos < 0;
    }

    static {
        STATE_MAP.put("closed", LandState.CLOSED);
        STATE_MAP.put("historical", LandState.HISTORICAL);
        STATE_MAP.put("active", LandState.ACTIVE);
        String year = "([0-9][0-9][0-9][0-9])";
        String month = "([0-1][0-9])";
        String day = "([0-3][0-9])";
        String hour = "([0-2][0-9])";
        String minute = "([0-5][0-9])";
        String second = "([0-6][0-9])";
        String timezone = "([\\+\\-][0-2][0-9](?::?[0-5][0-9])?|Z)";
        String iso8601Regex = year + "\\-" + month + "\\-" + day + "T" + hour + ":" + minute + ":" + second + timezone;
        ISO8601_PATTERN = Pattern.compile(iso8601Regex);
    }
}

