/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogWrapper {
    private final Logger jre14Logger;

    public LogWrapper(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        this.jre14Logger = logger;
    }

    public Logger getJre14Logger() {
        return this.jre14Logger;
    }

    private void fillStackInfo(LogRecord record) {
        Thread selfThread = Thread.currentThread();
        StackTraceElement[] stacks = selfThread.getStackTrace();
        String thisName = this.getClass().getName();
        boolean foundMySelf = false;
        for (StackTraceElement frame : stacks) {
            String frameClassName = frame.getClassName();
            if (!foundMySelf && frameClassName.equals(thisName)) {
                foundMySelf = true;
                continue;
            }
            if (!foundMySelf || frameClassName.equals(thisName)) continue;
            record.setSourceClassName(frameClassName);
            record.setSourceMethodName(frame.getMethodName());
            break;
        }
    }

    private void logJre14(Level level, CharSequence msg) {
        this.logJre14(level, msg, null);
    }

    private void logJre14(Level level, CharSequence msg, Throwable thrown) {
        String message = msg == null ? null : ((Object)msg).toString();
        LogRecord record = new LogRecord(level, message);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        this.fillStackInfo(record);
        this.jre14Logger.log(record);
    }

    public void info(CharSequence msg) {
        this.logJre14(Level.INFO, msg);
    }

    public void warn(CharSequence msg) {
        this.warn(msg, null);
    }

    public void warn(CharSequence msg, Throwable thrown) {
        this.logJre14(Level.WARNING, msg, thrown);
    }

    public void fatal(CharSequence msg) {
        this.fatal(msg, null);
    }

    public void fatal(CharSequence msg, Throwable thrown) {
        this.logJre14(Level.SEVERE, msg, thrown);
    }
}

