/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import jp.sourceforge.jindolf.HtmlSequence;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.corelib.LandDef;
import jp.sourceforge.jindolf.corelib.LandState;
import jp.sourceforge.jindolf.corelib.VillageState;
import jp.sourceforge.jindolf.parser.DecodedContent;
import jp.sourceforge.jindolf.parser.HtmlAdapter;
import jp.sourceforge.jindolf.parser.HtmlParseException;
import jp.sourceforge.jindolf.parser.HtmlParser;
import jp.sourceforge.jindolf.parser.PageType;
import jp.sourceforge.jindolf.parser.SeqRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Land {
    private static final String ID_VANILLAWOLF = "wolf";
    private final LandDef landDef;
    private final ServerAccess serverAccess;
    private final HtmlParser parser = new HtmlParser();
    private final VillageListHandler handler = new VillageListHandler();
    private final List<Village> villageList = new LinkedList<Village>();

    public static String getValueFromCGIQueries(String key, String allQuery) {
        String[] queries;
        String result = null;
        for (String pair : queries = allQuery.split("\\Q&\\E")) {
            String[] namevalue;
            if (pair == null || (namevalue = pair.split("\\Q=\\E")) == null || namevalue.length != 2) continue;
            String name = namevalue[0];
            String value = namevalue[1];
            if (name != null && name.equals(key) && (result = value) != null && result.length() > 0) break;
        }
        return result;
    }

    public static String getRawQueryFromHREF(CharSequence hrefValue) {
        URI uri;
        if (hrefValue == null) {
            return null;
        }
        String pureHREF = ((Object)hrefValue).toString().replace("&amp;", "&");
        try {
            uri = new URI(pureHREF);
        }
        catch (URISyntaxException e) {
            Jindolf.logger().warn("\u4e0d\u6b63\u306aURI[" + hrefValue + "]\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
            return null;
        }
        String rawQuery = uri.getRawQuery();
        return rawQuery;
    }

    public static String getVillageIDFromHREF(CharSequence hrefValue) {
        String rawQuery = Land.getRawQueryFromHREF(hrefValue);
        if (rawQuery == null) {
            return null;
        }
        String villageID = Land.getValueFromCGIQueries("vid", rawQuery);
        if (villageID == null) {
            return null;
        }
        if (villageID.length() <= 0) {
            return null;
        }
        return villageID;
    }

    public Land(LandDef landDef) throws IllegalArgumentException {
        URL url;
        this.landDef = landDef;
        try {
            url = this.landDef.getCgiURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.serverAccess = new ServerAccess(url);
        this.parser.setBasicHandler(this.handler);
    }

    public LandDef getLandDef() {
        return this.landDef;
    }

    public ServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public Village getVillage(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getVillageCount()) {
            return null;
        }
        Village result = this.villageList.get(index);
        return result;
    }

    public int getVillageCount() {
        int result = this.villageList.size();
        return result;
    }

    public List<Village> getVillageList() {
        return Collections.unmodifiableList(this.villageList);
    }

    public Image downloadImage(String imageURL) {
        Image image;
        ServerAccess server = this.getServerAccess();
        try {
            image = server.downloadImage(imageURL);
        }
        catch (IOException e) {
            Jindolf.logger().warn("\u30a4\u30e1\u30fc\u30b8[" + imageURL + "]" + "\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            return null;
        }
        return image;
    }

    public Image getGraveIconImage() {
        URI uri = this.getLandDef().getTombFaceIconURI();
        Image result = this.downloadImage(uri.toASCIIString());
        return result;
    }

    public void updateVillageList() throws IOException {
        List<Village> list;
        DecodedContent content;
        HtmlSequence html;
        LandDef thisLand = this.getLandDef();
        LandState state = thisLand.getLandState();
        boolean isVanillaWolf = thisLand.getLandId().equals(ID_VANILLAWOLF);
        ServerAccess server = this.getServerAccess();
        TreeSet<Village> vset = new TreeSet<Village>();
        if (state.equals((Object)LandState.ACTIVE) || isVanillaWolf) {
            html = server.getHTMLTopPage();
            content = html.getContent();
            try {
                this.parser.parseAutomatic(content);
            }
            catch (HtmlParseException e) {
                Jindolf.logger().warn("\u30c8\u30c3\u30d7\u30da\u30fc\u30b8\u3092\u8a8d\u8b58\u3067\u304d\u306a\u3044", e);
            }
            list = this.handler.getVillageList();
            if (list != null) {
                vset.addAll(list);
            }
        }
        if (!isVanillaWolf) {
            html = server.getHTMLLandList();
            content = html.getContent();
            try {
                this.parser.parseAutomatic(content);
            }
            catch (HtmlParseException e) {
                Jindolf.logger().warn("\u6751\u4e00\u89a7\u30da\u30fc\u30b8\u3092\u8a8d\u8b58\u3067\u304d\u306a\u3044", e);
            }
            list = this.handler.getVillageList();
            if (list != null) {
                vset.addAll(list);
            }
        }
        this.villageList.clear();
        this.villageList.addAll(vset);
        this.parser.reset();
        this.handler.reset();
    }

    public String toString() {
        return this.getLandDef().getLandName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VillageListHandler
    extends HtmlAdapter {
        private List<Village> villageList = null;

        public List<Village> getVillageList() throws IllegalStateException {
            if (this.villageList == null) {
                throw new IllegalStateException("\u30d1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059\u3002");
            }
            List<Village> result = this.villageList;
            return result;
        }

        public void reset() {
            this.villageList = null;
        }

        @Override
        public void startParse(DecodedContent content) throws HtmlParseException {
            this.reset();
            this.villageList = new LinkedList<Village>();
        }

        @Override
        public void pageType(PageType type) throws HtmlParseException {
            if (type != PageType.VILLAGELIST_PAGE && type != PageType.TOP_PAGE) {
                throw new HtmlParseException("\u30c8\u30c3\u30d7\u30da\u30fc\u30b8\u304b\u6751\u4e00\u89a7\u30da\u30fc\u30b8\u304c\u5fc5\u8981\u3067\u3059\u3002");
            }
        }

        @Override
        public void villageRecord(DecodedContent content, SeqRange anchorRange, SeqRange villageRange, int hour, int minute, VillageState villageState) throws HtmlParseException {
            LandDef landdef = Land.this.getLandDef();
            LandState landState = landdef.getLandState();
            CharSequence href = anchorRange.sliceSequence(content);
            String villageID = Land.getVillageIDFromHREF(href);
            if (villageID == null || villageID.length() <= 0) {
                Jindolf.logger().warn("\u8a8d\u8b58\u3067\u304d\u306a\u3044URL[" + href + "]\u306b\u906d\u9047\u3057\u307e\u3057\u305f\u3002");
                return;
            }
            CharSequence fullVillageName = villageRange.sliceSequence(content);
            Village village = new Village(Land.this, villageID, ((Object)fullVillageName).toString());
            if (landState == LandState.HISTORICAL) {
                village.setState(VillageState.GAMEOVER);
            } else {
                village.setState(villageState);
            }
            this.villageList.add(village);
        }
    }
}

