/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.TextPopup;
import jp.sourceforge.jindolf.json.JsArray;
import jp.sourceforge.jindolf.json.JsObject;
import jp.sourceforge.jindolf.json.JsParseException;
import jp.sourceforge.jindolf.json.JsValue;
import jp.sourceforge.jindolf.json.Json;

public class FindPanel
extends JDialog
implements ActionListener,
ItemListener,
ChangeListener,
PropertyChangeListener {
    private static final String HIST_FILE = "searchHistory.json";
    private static final String FRAMETITLE = "\u767a\u8a00\u691c\u7d22 - " + Jindolf.TITLE;
    private static final String LABEL_REENTER = "\u518d\u5165\u529b";
    private static final String LABEL_IGNORE = "\u7121\u8996\u3057\u3066\u691c\u7d22\u3092\u30ad\u30e3\u30f3\u30bb\u30eb";
    private final JComboBox findBox = new JComboBox();
    private final JButton searchButton = new JButton("\u691c\u7d22");
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JCheckBox capitalSwitch = new JCheckBox("\u5927\u6587\u5b57/\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3059\u308b");
    private final JCheckBox regexSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe");
    private final JCheckBox dotallSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \".\" \u3092\u884c\u672b\u8a18\u53f7\u306b\u3082\u30de\u30c3\u30c1\u3055\u305b\u308b");
    private final JCheckBox multilineSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \"^\" \u3084 \"$\" \u3092\u884c\u672b\u8a18\u53f7\u306e\u524d\u5f8c\u306b\u53cd\u5fdc\u3055\u305b\u308b");
    private final JCheckBox bulkSearchSwitch = new JCheckBox("\u5168\u65e5\u7a0b\u3092\u4e00\u62ec\u691c\u7d22");
    private final JButton closeButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private final CustomModel model = new CustomModel();
    private JsObject loadedHistory = null;
    private boolean canceled = false;
    private RegexPattern regexPattern = null;

    public FindPanel(Frame owner) {
        super(owner, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                FindPanel.this.actionCancel();
            }
        });
        this.design();
        this.findBox.setModel(this.model);
        this.findBox.setToolTipText("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        this.findBox.setEditable(true);
        this.findBox.setRenderer(new CustomRenderer());
        this.findBox.setMaximumRowCount(15);
        ComboBoxEditor editor = this.findBox.getEditor();
        this.modifyComboBoxEditor(editor);
        this.findBox.addPropertyChangeListener("UI", this);
        this.searchButton.setToolTipText("\u767a\u8a00\u5185\u5bb9\u3092\u691c\u7d22\u3059\u308b");
        this.clearButton.setToolTipText("\u5165\u529b\u3092\u30af\u30ea\u30a2\u3059\u308b");
        this.findBox.addItemListener(this);
        this.searchButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.regexSwitch.addChangeListener(this);
        this.closeButton.addActionListener(this);
        this.setRegexPattern(null);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.gridwidth = 2;
        TitledBorder border = BorderFactory.createTitledBorder("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.findBox, "Center");
        panel.setBorder(border);
        content.add((Component)panel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 15;
        content.add((Component)this.searchButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.clearButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.capitalSwitch, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.regexSwitch, constraints);
        JPanel regexPanel = new JPanel();
        regexPanel.setBorder(BorderFactory.createTitledBorder(""));
        regexPanel.setLayout(new GridLayout(2, 1));
        regexPanel.add(this.dotallSwitch);
        regexPanel.add(this.multilineSwitch);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)regexPanel, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        content.add((Component)this.bulkSearchSwitch, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        content.add((Component)this.closeButton, constraints);
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        this.getRootPane().setDefaultButton(this.searchButton);
        this.findBox.requestFocusInWindow();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isBulkSearch() {
        return this.bulkSearchSwitch.isSelected();
    }

    private void actionCancel() {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void actionSubmit() {
        Object selected = this.findBox.getSelectedItem();
        if (selected == null) {
            this.regexPattern = null;
            return;
        }
        String edit = selected.toString();
        boolean isRegex = this.regexSwitch.isSelected();
        int flag = 0;
        if (!this.capitalSwitch.isSelected()) {
            flag |= 0x42;
        }
        if (this.dotallSwitch.isSelected()) {
            flag |= 0x20;
        }
        if (this.multilineSwitch.isSelected()) {
            flag |= 8;
        }
        try {
            this.regexPattern = new RegexPattern(edit, isRegex, flag);
        }
        catch (PatternSyntaxException e) {
            this.regexPattern = null;
            if (this.showRegexError(e)) {
                return;
            }
            this.actionCancel();
            return;
        }
        this.model.addHistory(this.regexPattern);
        this.canceled = false;
        this.setVisible(false);
        this.dispose();
    }

    private boolean showRegexError(PatternSyntaxException e) {
        Object[] buttons;
        Icon icon;
        String message;
        int optionNo;
        String pattern = e.getPattern();
        String position = "";
        int index = e.getIndex();
        if (0 <= index && index <= pattern.length() - 1) {
            char errChar = pattern.charAt(index);
            position = "\u30a8\u30e9\u30fc\u306e\u767a\u751f\u7b87\u6240\u306f\u3001\u304a\u304a\u3088\u305d" + (index + 1) + "\u6587\u5b57\u76ee [ " + errChar + " ] " + "\u304b\u305d\u306e\u524d\u5f8c\u3068\u63a8\u6e2c\u3055\u308c\u307e\u3059\u3002\n";
        }
        if ((optionNo = JOptionPane.showOptionDialog(this, message = "\u5165\u529b\u3055\u308c\u305f\u691c\u7d22\u6587\u5b57\u5217 [ " + pattern + " ] \u306f" + "\u6b63\u3057\u3044\u6b63\u898f\u8868\u73fe\u3068\u3057\u3066\u8a8d\u8b58\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + position + "\u6b63\u898f\u8868\u73fe\u306e\u66f8\u304d\u65b9\u306f" + " [ http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/" + "java/util/regex/Pattern.html#sum ] " + "\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n" + "\u305f\u3060\u306e\u6587\u5b57\u5217\u3092\u691c\u7d22\u3057\u305f\u3044\u5834\u5408\u306f" + "\u300c\u6b63\u898f\u8868\u73fe\u300d\u306e\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u3092\u5916\u3057\u307e\u3057\u3087\u3046\u3002\n", "\u4e0d\u6b63\u306a\u6b63\u898f\u8868\u73fe", 0, 0, icon = null, buttons = new Object[]{LABEL_REENTER, LABEL_IGNORE}, LABEL_REENTER)) == -1) {
            return false;
        }
        if (buttons[optionNo].equals(LABEL_REENTER)) {
            return true;
        }
        return !buttons[optionNo].equals(LABEL_IGNORE);
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(RegexPattern pattern) {
        this.regexPattern = pattern == null ? CustomModel.INITITEM : pattern;
        String edit = this.regexPattern.getEditSource();
        this.findBox.getEditor().setItem(edit);
        this.regexSwitch.setSelected(this.regexPattern.isRegex());
        int initflag = this.regexPattern.getRegexFlag();
        this.capitalSwitch.setSelected((initflag & 0x42) == 0);
        this.dotallSwitch.setSelected((initflag & 0x20) != 0);
        this.multilineSwitch.setSelected((initflag & 8) != 0);
        this.maskRegexUI();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.actionCancel();
        } else if (source == this.searchButton) {
            this.actionSubmit();
        } else if (source == this.clearButton) {
            this.findBox.getEditor().setItem("");
            this.findBox.requestFocusInWindow();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        int stateChange = event.getStateChange();
        if (stateChange != 1) {
            return;
        }
        Object item = event.getItem();
        if (!(item instanceof RegexPattern)) {
            return;
        }
        RegexPattern regex = (RegexPattern)item;
        this.setRegexPattern(regex);
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() != this.regexSwitch) {
            return;
        }
        this.maskRegexUI();
    }

    private void maskRegexUI() {
        boolean isRegex = this.regexSwitch.isSelected();
        this.dotallSwitch.setEnabled(isRegex);
        this.multilineSwitch.setEnabled(isRegex);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getPropertyName().equals("UI")) {
            return;
        }
        if (event.getSource() != this.findBox) {
            return;
        }
        ComboBoxEditor editor = this.findBox.getEditor();
        this.modifyComboBoxEditor(editor);
    }

    private void modifyComboBoxEditor(ComboBoxEditor editor) {
        if (editor == null) {
            return;
        }
        Component editComp = editor.getEditorComponent();
        if (editComp == null) {
            return;
        }
        if (editComp instanceof JTextComponent) {
            JTextComponent textEditor = (JTextComponent)editComp;
            textEditor.setComponentPopupMenu(new TextPopup());
            GUIUtils.forceMonoPitchFont(textEditor);
        }
        if (editComp instanceof JComponent) {
            JComponent component = (JComponent)editComp;
            GUIUtils.addMargin(component, 1, 4, 1, 4);
        }
    }

    public void loadHistory() {
        JsValue value;
        if (!AppSetting.needConfig()) {
            return;
        }
        File configPath = AppSetting.getConfigDirectory();
        if (configPath == null) {
            return;
        }
        File hisFile = new File(configPath, HIST_FILE);
        if (!hisFile.exists()) {
            return;
        }
        try {
            InputStream istream = new FileInputStream(hisFile);
            istream = new BufferedInputStream(istream);
            InputStreamReader reader = new InputStreamReader(istream, "UTF-8");
            value = Json.parseValue(reader);
        }
        catch (IOException e) {
            Jindolf.logger().fatal("\u691c\u7d22\u30d2\u30b9\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            return;
        }
        catch (JsParseException e) {
            Jindolf.logger().fatal("\u691c\u7d22\u30d2\u30b9\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u306b\u4e0d\u6b63\u304c\u3042\u308a\u307e\u3059\u3002", e);
            return;
        }
        if (!(value instanceof JsObject)) {
            return;
        }
        JsObject root = (JsObject)value;
        if (!((value = root.getValue("history")) instanceof JsArray)) {
            return;
        }
        JsArray array = (JsArray)value;
        for (JsValue elem : array) {
            JsObject regObj;
            RegexPattern regex;
            if (!(elem instanceof JsObject) || (regex = RegexPattern.decodeJson(regObj = (JsObject)elem)) == null) continue;
            this.model.addHistory(regex);
        }
        this.loadedHistory = root;
    }

    public void saveHistory() {
        if (!AppSetting.needConfig()) {
            return;
        }
        File configPath = AppSetting.getConfigDirectory();
        if (configPath == null) {
            return;
        }
        JsObject root = new JsObject();
        JsArray array = new JsArray();
        root.putValue("history", array);
        List<RegexPattern> history = this.model.getOriginalHistoryList();
        history = new ArrayList<RegexPattern>(history);
        Collections.reverse(history);
        for (RegexPattern regex : history) {
            JsObject obj = RegexPattern.encodeJson(regex);
            array.add(obj);
        }
        if (this.loadedHistory != null && this.loadedHistory.equals(root)) {
            return;
        }
        try {
            File hisFile = new File(configPath, HIST_FILE);
            hisFile.delete();
            if (!hisFile.createNewFile()) {
                return;
            }
            OutputStream ostream = new FileOutputStream(hisFile);
            ostream = new BufferedOutputStream(ostream);
            OutputStreamWriter writer = new OutputStreamWriter(ostream, "UTF-8");
            Json.writeJsonTop(writer, root);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            Jindolf.logger().fatal("\u691c\u7d22\u30d2\u30b9\u30c8\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u652f\u969c\u304c\u3042\u308a\u307e\u3057\u305f\u3002", e);
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomModel
    implements ComboBoxModel {
        private static final int HISTORY_MAX = 7;
        private static final RegexPattern INITITEM = new RegexPattern("", false, 98);
        private static final List<RegexPattern> PREDEF_PATTERN_LIST = new LinkedList<RegexPattern>();
        private final List<RegexPattern> history = new LinkedList<RegexPattern>();
        private final JSeparator separator1st = new JSeparator();
        private final JSeparator separator2nd = new JSeparator();
        private Object selected;
        private final EventListenerList listenerList = new EventListenerList();

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item instanceof JSeparator) {
                return;
            }
            this.selected = item;
        }

        @Override
        public Object getElementAt(int index) {
            int historySize = this.history.size();
            if (index == 0) {
                return INITITEM;
            }
            if (index == 1) {
                return this.separator1st;
            }
            if (2 <= index && index <= 1 + historySize) {
                return this.history.get(index - 2);
            }
            if (index == historySize + 2) {
                return this.separator2nd;
            }
            if (historySize + 3 <= index) {
                return PREDEF_PATTERN_LIST.get(index - 1 - 1 - historySize - 1);
            }
            return null;
        }

        @Override
        public int getSize() {
            int size = 1;
            ++size;
            size += this.history.size();
            ++size;
            return size += PREDEF_PATTERN_LIST.size();
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this.listenerList.add(ListDataListener.class, listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this.listenerList.remove(ListDataListener.class, listener);
        }

        public void addHistory(RegexPattern regexPattern) {
            if (regexPattern == null) {
                return;
            }
            if (regexPattern.equals(INITITEM)) {
                return;
            }
            if (PREDEF_PATTERN_LIST.contains(regexPattern)) {
                return;
            }
            if (this.history.contains(regexPattern)) {
                this.history.remove(regexPattern);
            }
            this.history.add(0, regexPattern);
            while (this.history.size() > 7) {
                this.history.remove(7);
            }
            this.fire();
        }

        public List<RegexPattern> getOriginalHistoryList() {
            return Collections.unmodifiableList(this.history);
        }

        private void fire() {
            ListDataListener[] listeners;
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            for (ListDataListener listener : listeners = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
                listener.contentsChanged(event);
            }
        }

        static {
            PREDEF_PATTERN_LIST.add(new RegexPattern("\u3010[^\u3011]*\u3011", true, 32, "     \u203b \u91cd\u8981\u4e8b\u9805"));
            PREDEF_PATTERN_LIST.add(new RegexPattern("[\u25a0\u25cf\u25bc\u2605\u25a1\u25cb\u25bd\u2606\u3007\u25ef\u2207]", true, 32, "     \u203b \u8b70\u984c"));
            PREDEF_PATTERN_LIST.add(new RegexPattern("Jindolf", false, 66, "     \u203b \u5ba3\u4f1d"));
        }
    }

    private static class CustomRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JSeparator) {
                return (JSeparator)value;
            }
            JLabel superLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof RegexPattern) {
                RegexPattern regexPattern = (RegexPattern)value;
                String text = regexPattern.isRegex() ? "[R]\u3000" + regexPattern.getEditSource() : regexPattern.getEditSource();
                text = text + regexPattern.getComment();
                superLabel.setText(text);
            }
            GUIUtils.addMargin(superLabel, 1, 4, 1, 4);
            return superLabel;
        }
    }
}

