/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.FileUtils;
import jp.sourceforge.jindolf.InterVMLock;
import jp.sourceforge.jindolf.Jindolf;

public final class ConfigFile {
    private static final String TITLE_BUILDCONF = Jindolf.TITLE + "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u8a2d\u5b9a";
    private static final String JINCONF = "Jindolf";
    private static final String JINCONF_DOT = ".jindolf";
    private static final String FILE_README = "README.txt";
    private static final Charset CHARSET_README = Charset.forName("UTF-8");
    private static final String MSG_POST = "<ul><li><code>" + AppSetting.CmdOption.OPT_CONFDIR.toHyphened() + "</code>" + "&nbsp;\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a\u306b\u3088\u308a\u3001<br>" + "\u4efb\u610f\u306e\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br>" + "<li><code>" + AppSetting.CmdOption.OPT_NOCONF.toHyphened() + "</code>" + "&nbsp;\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a\u306b\u3088\u308a\u3001<br>" + "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002<br>" + "</ul>";

    public static File setupConfigDirectory() {
        File configPath;
        if (!AppSetting.needConfig()) {
            configPath = null;
        } else {
            String optName;
            if (AppSetting.getConfigDirectory() != null) {
                configPath = AppSetting.getConfigDirectory();
                optName = AppSetting.CmdOption.OPT_CONFDIR.toHyphened();
            } else {
                configPath = ConfigFile.getImplicitConfigDirectory();
                optName = null;
            }
            if (!configPath.exists()) {
                configPath = ConfigFile.buildConfigDirectory(configPath, optName);
            }
            ConfigFile.checkAccessibility(configPath);
        }
        AppSetting.setConfigDirectory(configPath);
        return configPath;
    }

    public static InterVMLock setupLockFile() {
        File configPath = AppSetting.getConfigDirectory();
        if (configPath == null) {
            return null;
        }
        File lockFile = new File(configPath, "lock");
        InterVMLock lock = new InterVMLock(lockFile);
        lock.tryLock();
        if (!lock.isFileOwner()) {
            ConfigFile.confirmLockError(lock);
            if (!lock.isFileOwner()) {
                AppSetting.setConfigDirectory(null);
                AppSetting.setNeedConfig(false);
            }
        }
        return lock;
    }

    public static File getImplicitConfigDirectory() {
        File result;
        File jarParent = FileUtils.getJarDirectory(Jindolf.class);
        if (jarParent != null && FileUtils.isAccessibleDirectory(jarParent) && FileUtils.isAccessibleDirectory(result = new File(jarParent, JINCONF))) {
            return result;
        }
        File appset = FileUtils.getAppSetDir();
        if (appset == null) {
            return null;
        }
        result = FileUtils.isMacOSXFs() || FileUtils.isWindowsOSFs() ? new File(appset, JINCONF) : new File(appset, JINCONF_DOT);
        return result;
    }

    public static File buildConfigDirectory(File confPath, String optName) throws IllegalArgumentException {
        boolean success;
        File existsAncestor;
        if (confPath.exists()) {
            throw new IllegalArgumentException();
        }
        File absPath = FileUtils.supplyFullPath(confPath);
        String preErrMessage = "\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br>" + ConfigFile.getCenteredFileName(absPath) + "\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
        if (optName != null) {
            preErrMessage = "<code>" + optName + "</code>&nbsp;\u30aa\u30d7\u30b7\u30e7\u30f3" + "\u3067\u6307\u5b9a\u3055\u308c\u305f\u3001<br>" + preErrMessage;
        }
        if ((existsAncestor = FileUtils.findExistsAncestor(absPath)) == null) {
            ConfigFile.abortNoRoot(absPath, preErrMessage);
        } else if (!existsAncestor.canWrite()) {
            ConfigFile.abortCantWriteAncestor(existsAncestor, preErrMessage);
        }
        String prompt = "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br>" + ConfigFile.getCenteredFileName(absPath) + "\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002";
        boolean confirmed = ConfigFile.confirmBuildConfigDir(existsAncestor, prompt);
        if (!confirmed) {
            ConfigFile.abortQuitBuildConfigDir();
        }
        try {
            success = absPath.mkdirs();
        }
        catch (SecurityException e) {
            success = false;
        }
        if (!success || !absPath.exists()) {
            ConfigFile.abortCantBuildConfigDir(absPath);
        }
        FileUtils.setOwnerOnlyAccess(absPath);
        ConfigFile.checkAccessibility(absPath);
        ConfigFile.touchReadme(absPath);
        return absPath;
    }

    private static void showErrorMessage(CharSequence seq) {
        JOptionPane pane = new JOptionPane(((Object)seq).toString(), 0);
        ConfigFile.showDialog(pane);
    }

    private static void showInfoMessage(CharSequence seq) {
        JOptionPane pane = new JOptionPane(((Object)seq).toString(), 1);
        ConfigFile.showDialog(pane);
    }

    private static void showDialog(JOptionPane pane) {
        JDialog dialog = pane.createDialog(null, TITLE_BUILDCONF);
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private static void abortNoRoot(File path, String preMessage) {
        File root = FileUtils.findRootFile(path);
        ConfigFile.showErrorMessage("<html>" + preMessage + "<br>" + ConfigFile.getCenteredFileName(root) + "\u3092\u7528\u610f\u3059\u308b\u65b9\u6cd5\u304c\u4e0d\u660e\u3067\u3059\u3002<br>" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + MSG_POST + "</html>");
        Jindolf.exit(1);
    }

    private static void abortCantWriteAncestor(File existsAncestor, String preMessage) {
        ConfigFile.showErrorMessage("<html>" + preMessage + "<br>" + ConfigFile.getCenteredFileName(existsAncestor) + "\u3078\u306e\u66f8\u304d\u8fbc\u307f\u304c\u3067\u304d\u306a\u3044\u305f\u3081\u3001" + "\u51e6\u7406\u306e\u7d9a\u884c\u306f\u4e0d\u53ef\u80fd\u3067\u3059\u3002<br>" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + MSG_POST + "</html>");
        Jindolf.exit(1);
    }

    private static boolean confirmBuildConfigDir(File existsAncestor, String preMessage) {
        String message = "<html>" + preMessage + "<br>" + "\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4eca\u304b\u3089<br>" + ConfigFile.getCenteredFileName(existsAncestor) + "\u306b\u4f5c\u6210\u3057\u3066\u69cb\u3044\u307e\u305b\u3093\u304b\uff1f<br>" + "\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306f\u3001\u5f8c\u304b\u3089\u3044\u3064\u3067\u3082\u30d8\u30eb\u30d7\u30a6\u30a3\u30f3\u30c9\u30a6\u3067<br>" + "\u78ba\u8a8d\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002" + "</html>";
        JOptionPane pane = new JOptionPane(message, 3, 0);
        ConfigFile.showDialog(pane);
        Object result = pane.getValue();
        if (result == null) {
            return false;
        }
        if (!(result instanceof Integer)) {
            return false;
        }
        int ival = (Integer)result;
        return ival == 0;
    }

    private static void abortQuitBuildConfigDir() {
        String message = "<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u3092\u305b\u305a\u306b\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + MSG_POST + "</html>";
        JOptionPane pane = new JOptionPane(message, 2);
        ConfigFile.showDialog(pane);
        Jindolf.exit(1);
    }

    private static void abortCantBuildConfigDir(File path) {
        ConfigFile.showErrorMessage("<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br>" + ConfigFile.getCenteredFileName(path) + "\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + MSG_POST + "</html>");
        Jindolf.exit(1);
    }

    private static void abortCantAccessConfigDir(File path) {
        ConfigFile.showErrorMessage("<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea<br>" + ConfigFile.getCenteredFileName(path) + "\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u3067\u304d\u307e\u305b\u3093\u3002" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + "\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3078\u306e\u30a2\u30af\u30bb\u30b9\u6a29\u3092\u8abf\u6574\u3057" + "\u8aad\u307f\u66f8\u304d\u3067\u304d\u308b\u3088\u3046\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>" + MSG_POST + "</html>");
        Jindolf.exit(1);
    }

    private static void abortCantWrite(File file) {
        ConfigFile.showErrorMessage("<html>\u30d5\u30a1\u30a4\u30eb<br>" + ConfigFile.getCenteredFileName(file) + "\u3078\u306e\u66f8\u304d\u8fbc\u307f\u304c\u3067\u304d\u307e\u305b\u3093\u3002" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002<br>" + "</html>");
        Jindolf.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void touchReadme(File path) {
        File file = new File(path, FILE_README);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            ConfigFile.abortCantAccessConfigDir(path);
        }
        PrintWriter writer = null;
        try {
            FileOutputStream ostream = new FileOutputStream(file);
            OutputStreamWriter owriter = new OutputStreamWriter((OutputStream)ostream, CHARSET_README);
            writer = new PrintWriter(owriter);
            writer.println(CHARSET_README.name() + " Japanese");
            writer.println("\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u3001Jindolf\u306e\u5404\u7a2e\u8a2d\u5b9a\u304c\u683c\u7d0d\u3055\u308c\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3059\u3002");
            writer.println("Jindolf\u306e\u8a73\u7d30\u306f http://jindolf.sourceforge.jp/ \u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            writer.println("\u3053\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u300cJindolf\u300d\u306e\u540d\u524d\u3067\u8d77\u52d5\u5143JAR\u30d5\u30a1\u30a4\u30eb\u3068\u540c\u3058\u4f4d\u7f6e\u306b");
            writer.println("\u30b3\u30d4\u30fc\u3059\u308c\u3070\u3001\u305d\u3061\u3089\u306e\u8a2d\u5b9a\u304c\u512a\u5148\u3057\u3066\u4f7f\u308f\u308c\u307e\u3059\u3002");
            writer.println("\u300clock\u300d\u306e\u540d\u524d\u3092\u6301\u3064\u30d5\u30a1\u30a4\u30eb\u306f\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
        }
        catch (IOException e) {
            ConfigFile.abortCantWrite(file);
        }
        catch (SecurityException e) {
            ConfigFile.abortCantWrite(file);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void checkAccessibility(File confDir) {
        if (!FileUtils.isAccessibleDirectory(confDir)) {
            ConfigFile.abortCantAccessConfigDir(confDir);
        }
    }

    public static String getCenteredFileName(File path) {
        return "<center>[&nbsp;" + FileUtils.getHtmledFileName(path) + "&nbsp;]</center>" + "<br>";
    }

    private ConfigFile() {
    }

    public static void confirmLockError(InterVMLock lock) {
        block4: {
            block5: {
                LockErrorPane pane = new LockErrorPane(lock);
                JDialog dialog = pane.createDialog(null, TITLE_BUILDCONF);
                dialog.setResizable(true);
                dialog.pack();
                while (true) {
                    dialog.setVisible(true);
                    dialog.dispose();
                    if (pane.isAborted()) {
                        Jindolf.exit(1);
                        break block4;
                    }
                    if (pane.isRadioRetry()) {
                        lock.tryLock();
                        if (!lock.isFileOwner()) continue;
                        break block4;
                    }
                    if (pane.isRadioContinue()) {
                        ConfigFile.showInfoMessage("<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3092\u7d9a\u884c\u3057\u307e\u3059\u3002<br>\u4eca\u56de\u3001\u5404\u7a2e\u8a2d\u5b9a\u306e\u8aad\u307f\u8fbc\u307f\u30fb\u4fdd\u5b58\u306f\u3067\u304d\u307e\u305b\u3093\u3002<br><code>" + AppSetting.CmdOption.OPT_NOCONF.toHyphened() + "</code> \u30aa\u30d7\u30b7\u30e7\u30f3" + "\u3092\u4f7f\u3046\u3068\u3053\u306e\u8b66\u544a\u306f\u51fa\u306a\u304f\u306a\u308a\u307e\u3059\u3002" + "</html>");
                        break block4;
                    }
                    if (pane.isRadioForce()) break;
                }
                lock.forceRemove();
                if (!lock.isExistsFile()) break block5;
                ConfigFile.showErrorMessage("<html>\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb\u306e\u5f37\u5236\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>\u4ed6\u306b\u52d5\u3044\u3066\u3044\u308bJindolf\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u306e\u3067\u3042\u308c\u3070\u3001<br>\u306a\u3093\u3068\u304b\u3057\u3066\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br>" + ConfigFile.getCenteredFileName(lock.getLockFile()) + "\u3092\u524a\u9664\u3057\u3066\u304f\u3060\u3055\u3044\u3002<br>" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002" + "</html>");
                Jindolf.exit(1);
                break block4;
            }
            lock.tryLock();
            if (lock.isFileOwner()) break block4;
            ConfigFile.showErrorMessage("<html>\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br>" + ConfigFile.getCenteredFileName(lock.getLockFile()) + "\u3092\u78ba\u4fdd\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002<br>" + "\u8d77\u52d5\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002" + "</html>");
            Jindolf.exit(1);
        }
    }

    private static class LockErrorPane
    extends JOptionPane
    implements ActionListener {
        private final InterVMLock lock;
        private final JRadioButton continueButton = new JRadioButton("\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f7f\u308f\u305a\u306b\u8d77\u52d5\u3092\u7d9a\u884c");
        private final JRadioButton retryButton = new JRadioButton("\u518d\u5ea6\u30ed\u30c3\u30af\u53d6\u5f97\u3092\u8a66\u3059");
        private final JRadioButton forceButton = new JRadioButton("<html>\u30ed\u30c3\u30af\u3092\u5f37\u5236\u89e3\u9664<br> (\u203b\u4ed6\u306eJindolf\u3068\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u304c\u885d\u7a81\u3059\u308b\u304b\u3082\u2026)</html>");
        private final JButton okButton = new JButton("OK");
        private final JButton abortButton = new JButton("\u8d77\u52d5\u4e2d\u6b62");
        private boolean aborted = false;

        public LockErrorPane(InterVMLock lock) {
            this.lock = lock;
            String htmlMessage = "<html>\u8a2d\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30ed\u30c3\u30af\u30d5\u30a1\u30a4\u30eb<br>" + ConfigFile.getCenteredFileName(this.lock.getLockFile()) + "\u306e\u30ed\u30c3\u30af\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br>" + "\u8003\u3048\u3089\u308c\u308b\u539f\u56e0\u3068\u3057\u3066\u306f\u3001<br>" + "<ul>" + "<li>\u524d\u56de\u8d77\u52d5\u3057\u305fJindolf\u306e\u7d42\u4e86\u304c\u6b63\u3057\u304f\u884c\u308f\u308c\u306a\u304b\u3063\u305f" + "<li>\u4eca\u3069\u3053\u304b\u3067\u4ed6\u306eJindolf\u304c\u52d5\u3044\u3066\u3044\u308b" + "</ul>" + "\u306a\u3069\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002<br>" + "<hr>" + "</html>";
            ButtonGroup bgrp = new ButtonGroup();
            bgrp.add(this.continueButton);
            bgrp.add(this.retryButton);
            bgrp.add(this.forceButton);
            this.continueButton.setSelected(true);
            Object[] msg = new Object[]{htmlMessage, this.continueButton, this.retryButton, this.forceButton};
            this.setMessage(msg);
            Object[] opts = new Object[]{this.okButton, this.abortButton};
            this.setOptions(opts);
            this.setMessageType(0);
            this.okButton.addActionListener(this);
            this.abortButton.addActionListener(this);
        }

        public boolean isRadioContinue() {
            return this.continueButton.isSelected();
        }

        public boolean isRadioRetry() {
            return this.retryButton.isSelected();
        }

        public boolean isRadioForce() {
            return this.forceButton.isSelected();
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public JDialog createDialog(Component parentComponent, String title) throws HeadlessException {
            final JDialog dialog = super.createDialog(parentComponent, title);
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    dialog.setVisible(false);
                }
            };
            this.okButton.addActionListener(listener);
            this.abortButton.addActionListener(listener);
            return dialog;
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            this.aborted = source != this.okButton;
        }
    }
}

