/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import jp.sourceforge.jindolf.XmlUtils;
import jp.sourceforge.jindolf.corelib.PreDefAvatar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avatar
implements Comparable<Avatar> {
    private static final List<PreDefAvatar> PREDEFAVATAR_LIST;
    private static final SortedSet<Avatar> AVATAR_SET;
    private static final List<Avatar> AVATAR_LIST;
    private static final Map<String, Avatar> AVATAR_MAP;
    private static final Pattern AVATAR_PATTERN;
    public static final Avatar AVATAR_GERD;
    private final String name;
    private final String jobTitle;
    private final String fullName;
    private final int idNum;
    private final String identifier;

    private static SortedSet<Avatar> loadPredefSet() {
        TreeSet<Avatar> result = new TreeSet();
        for (PreDefAvatar preDefAvatar : PREDEFAVATAR_LIST) {
            String shortName = preDefAvatar.getShortName();
            String jobTitle = preDefAvatar.getJobTitle();
            int serialNo = preDefAvatar.getSerialNo();
            String avatarId = preDefAvatar.getAvatarId();
            Avatar avatar = new Avatar(shortName, jobTitle, serialNo, avatarId);
            result.add(avatar);
        }
        result = Collections.unmodifiableSortedSet(result);
        return result;
    }

    public static SortedSet<Avatar> getPredefinedAvatarSet() {
        return AVATAR_SET;
    }

    public static Avatar getPredefinedAvatar(String fullName) {
        return AVATAR_MAP.get(fullName);
    }

    public static Avatar lookingAtAvatar(Matcher matcher) {
        matcher.usePattern(AVATAR_PATTERN);
        if (!matcher.lookingAt()) {
            return null;
        }
        int groupCt = matcher.groupCount();
        for (int group = 1; group <= groupCt; ++group) {
            if (matcher.start(group) < 0) continue;
            Avatar avatar = AVATAR_LIST.get(group - 1);
            return avatar;
        }
        return null;
    }

    private Avatar(String name, String jobTitle, int idNum, String identifier) {
        this.name = name.intern();
        this.jobTitle = jobTitle.intern();
        this.idNum = idNum;
        this.identifier = identifier.intern();
        this.fullName = (this.jobTitle + " " + this.name).intern();
    }

    public Avatar(String fullName) {
        this.fullName = fullName.intern();
        this.idNum = -1;
        String[] tokens = this.fullName.split("\\p{Blank}+", 2);
        if (tokens.length == 1) {
            this.jobTitle = null;
            this.name = this.fullName;
        } else if (tokens.length == 2) {
            this.jobTitle = tokens[0].intern();
            this.name = tokens[1].intern();
        } else {
            this.jobTitle = null;
            this.name = null;
            assert (false);
        }
        this.identifier = "???".intern();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object obj) {
        boolean idMatch;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Avatar)) {
            return false;
        }
        Avatar other = (Avatar)obj;
        boolean nameMatch = this.fullName.equals(other.fullName);
        boolean bl = idMatch = this.idNum == other.idNum;
        return nameMatch && idMatch;
    }

    public int hashCode() {
        return this.fullName.hashCode() ^ this.idNum;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public int compareTo(Avatar avatar) {
        if (avatar == null) {
            return 1;
        }
        return this.idNum - avatar.idNum;
    }

    static {
        try {
            DocumentBuilder builder = XmlUtils.createDocumentBuilder();
            PREDEFAVATAR_LIST = PreDefAvatar.buildPreDefAvatarList(builder);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        AVATAR_SET = Avatar.loadPredefSet();
        AVATAR_LIST = new ArrayList<Avatar>(AVATAR_SET.size());
        AVATAR_MAP = new TreeMap<String, Avatar>();
        StringBuilder avatarGroup = new StringBuilder();
        for (Avatar avatar : AVATAR_SET) {
            AVATAR_LIST.add(avatar);
            String fullName = avatar.getFullName();
            AVATAR_MAP.put(fullName, avatar);
            if (avatarGroup.length() > 0) {
                avatarGroup.append('|');
            }
            avatarGroup.append('(').append(Pattern.quote(fullName)).append(')');
        }
        AVATAR_PATTERN = Pattern.compile(avatarGroup.toString());
        AVATAR_GERD = Avatar.getPredefinedAvatar("\u697d\u5929\u5bb6 \u30b2\u30eb\u30c8");
    }
}

