/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.FileUtils;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppSetting {
    private static final Map<String, String> propertyMap = new TreeMap<String, String>();
    private static final String osName;
    private static final String osVersion;
    private static final String osArch;
    private static final String javaVendor;
    private static final String javaVersion;
    private static final String classpath;
    private static final String[] classpaths;
    private static final Map<String, String> environmentMap;
    private static final String envLANG;
    private static final String envDISPLAY;
    private static final String proxyHost;
    private static final String proxyPort;
    private static final String nonProxyHosts;
    private static boolean needHelp;
    private static boolean needVersion;
    private static boolean needVMInfo;
    private static boolean boldMetal;
    private static boolean noSplash;
    private static boolean consolelog;
    private static int frameWidth;
    private static int frameHeight;
    private static int frameXpos;
    private static int frameYpos;
    private static String initfont;
    private static Boolean antialias;
    private static Boolean fractional;
    private static File configPath;
    private static boolean needConfig;
    private static final List<String> invokeArgs;
    private static final Pattern geomPattern;

    public static String getOsName() {
        return osName;
    }

    public static String getOsArch() {
        return osArch;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static String getJavaVendor() {
        return javaVendor;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static String getClasspath() {
        return classpath;
    }

    public static String[] getClasspaths() {
        return classpaths;
    }

    public static String getEnvLANG() {
        return envLANG;
    }

    public static String getEnvDISPLAY() {
        return envDISPLAY;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static String getProxyPort() {
        return proxyPort;
    }

    public static String getNonProxyHosts() {
        return nonProxyHosts;
    }

    public static boolean needHelp() {
        return needHelp;
    }

    public static boolean needVersion() {
        return needVersion;
    }

    public static boolean needVMInfo() {
        return needVMInfo;
    }

    public static boolean useBoldMetal() {
        return boldMetal;
    }

    public static boolean noSplash() {
        return noSplash;
    }

    public static boolean useConsolelog() {
        return consolelog;
    }

    public static int initialFrameWidth() {
        return frameWidth;
    }

    public static int initialFrameHeight() {
        return frameHeight;
    }

    public static int initialFrameXpos() {
        return frameXpos;
    }

    public static int initialFrameYpos() {
        return frameYpos;
    }

    public static String getInitfont() {
        return initfont;
    }

    public static Boolean useAntialias() {
        return antialias;
    }

    public static Boolean useFractional() {
        return fractional;
    }

    public static File getConfigDirectory() {
        return configPath;
    }

    public static void setConfigDirectory(File path) {
        configPath = path;
    }

    public static boolean needConfig() {
        return needConfig;
    }

    public static void setNeedConfig(boolean need) {
        needConfig = need;
    }

    private static String getSecureProperty(String key) {
        String result;
        try {
            result = System.getProperty(key);
            if (result != null) {
                propertyMap.put(key, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    private static String getSecureEnvironment(String name) {
        String result;
        try {
            result = System.getenv(name);
            if (result != null) {
                environmentMap.put(name, result);
            }
        }
        catch (SecurityException e) {
            result = null;
        }
        return result;
    }

    public static String getVMInfo() {
        StringBuilder result = new StringBuilder();
        result.append("\u6700\u5927\u30d2\u30fc\u30d7\u30e1\u30e2\u30ea\u91cf: " + Jindolf.RUNTIME.maxMemory() + " bytes\n");
        result.append("\n");
        result.append("\u8d77\u52d5\u6642\u5f15\u6570:\n");
        for (String arg : invokeArgs) {
            result.append("  ").append(arg).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3:\n");
        Set<String> propKeys = propertyMap.keySet();
        for (String propKey : propKeys) {
            if (propKey.equals("java.class.path")) continue;
            String value = propertyMap.get(propKey);
            result.append("  ");
            result.append(propKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u4e3b\u8981\u74b0\u5883\u5909\u6570:\n");
        Set<String> envKeys = environmentMap.keySet();
        for (String envKey : envKeys) {
            String value = environmentMap.get(envKey);
            result.append("  ");
            result.append(envKey).append("=").append(value).append("\n");
        }
        result.append("\n");
        result.append("\u30af\u30e9\u30b9\u30d1\u30b9:\n");
        for (String path : classpaths) {
            result.append("  ");
            result.append(path).append("\n");
        }
        result.append("\n");
        result.append("\u8a2d\u5b9a\u683c\u7d0d\u30c7\u30a3\u30ec\u30af\u30c8\u30ea:\n");
        if (configPath != null) {
            result.append("  ");
            result.append(configPath.getPath()).append('\n');
        } else {
            result.append("  ");
            result.append("\u4f7f\u308f\u306a\u3044");
        }
        result.append("\n");
        return result.toString();
    }

    public static void parseOptions(String[] args) {
        invokeArgs.clear();
        for (String arg : args) {
            if (arg == null || arg.length() <= 0) continue;
            invokeArgs.add(arg);
        }
        ListIterator<String> iterator = invokeArgs.listIterator();
        block17: while (iterator.hasNext()) {
            String arg = iterator.next();
            CmdOption option = CmdOption.parseCmdOption(arg);
            if (option == null) {
                AppSetting.optionError("\u672a\u5b9a\u7fa9\u306e\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002");
                return;
            }
            switch (option) {
                case OPT_HELP: {
                    needHelp = true;
                    needVersion = false;
                    break;
                }
                case OPT_VERSION: {
                    needVersion = true;
                    needHelp = false;
                    break;
                }
                case OPT_BOLDMETAL: {
                    boldMetal = true;
                    break;
                }
                case OPT_NOSPLASH: {
                    noSplash = true;
                    break;
                }
                case OPT_VMINFO: {
                    needVMInfo = true;
                    break;
                }
                case OPT_CONSOLELOG: {
                    consolelog = true;
                    break;
                }
                case OPT_INITFONT: {
                    AppSetting.checkNextArg(arg, iterator);
                    initfont = iterator.next();
                    break;
                }
                case OPT_ANTIALIAS: {
                    antialias = AppSetting.parseBooleanSwitch(arg, iterator);
                    break;
                }
                case OPT_FRACTIONAL: {
                    fractional = AppSetting.parseBooleanSwitch(arg, iterator);
                    break;
                }
                case OPT_CONFDIR: {
                    AppSetting.checkNextArg(arg, iterator);
                    File path = new File(iterator.next());
                    configPath = FileUtils.supplyFullPath(path);
                    needConfig = true;
                    break;
                }
                case OPT_NOCONF: {
                    configPath = null;
                    needConfig = false;
                    break;
                }
                case OPT_GEOMETRY: {
                    if (!iterator.hasNext()) {
                        AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return;
                    }
                    String geometry = iterator.next();
                    Matcher matcher = geomPattern.matcher(geometry);
                    if (!matcher.matches()) {
                        AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + geometry + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                        return;
                    }
                    String width = matcher.group(1);
                    String height = matcher.group(2);
                    String xSign = matcher.group(3);
                    String xPos = matcher.group(4);
                    String ySign = matcher.group(5);
                    String yPos = matcher.group(6);
                    try {
                        frameWidth = Integer.parseInt(width);
                        frameHeight = Integer.parseInt(height);
                        if (xPos != null && xPos.length() > 0) {
                            frameXpos = Integer.parseInt(xPos);
                            if (xSign.equals("-")) {
                                frameXpos = -frameXpos;
                            }
                        }
                        if (yPos == null || yPos.length() <= 0) continue block17;
                        frameYpos = Integer.parseInt(yPos);
                        if (!ySign.equals("-")) continue block17;
                        frameYpos = -frameYpos;
                        break;
                    }
                    catch (NumberFormatException e) {
                        AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + arg + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + geometry + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                        return;
                    }
                }
                default: {
                    assert (false);
                    continue block17;
                }
            }
        }
    }

    private static Boolean parseBooleanSwitch(String option, ListIterator<String> iterator) {
        Boolean result = null;
        AppSetting.checkNextArg(option, iterator);
        String onoff = iterator.next();
        if (onoff.compareToIgnoreCase("on") == 0 || onoff.compareToIgnoreCase("yes") == 0 || onoff.compareToIgnoreCase("true") == 0) {
            result = Boolean.TRUE;
        } else if (onoff.compareToIgnoreCase("off") == 0 || onoff.compareToIgnoreCase("no") == 0 || onoff.compareToIgnoreCase("false") == 0) {
            result = Boolean.FALSE;
        } else {
            AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + option + "]\u306e\u5f15\u6570\u5f62\u5f0f[" + onoff + "]\u304c\u4e0d\u6b63\u3067\u3059\u3002" + "on, off, yes, no, true, false" + "\u306e\u3044\u305a\u308c\u304b\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            assert (false);
        }
        return result;
    }

    private static void checkNextArg(CharSequence option, ListIterator<String> iterator) {
        if (!iterator.hasNext()) {
            AppSetting.optionError("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3[" + option + "]\u306b\u5f15\u6570\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            assert (false);
            throw new Error();
        }
    }

    private static void optionError(CharSequence message) {
        System.err.println(message);
        System.err.println("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u4e00\u89a7\u306f\u3001\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u300c" + CmdOption.OPT_HELP.toHyphened() + "\u300d\u3092\u6307\u5b9a\u3059\u308b\u3068\u78ba\u8a8d\u3067\u304d\u307e\u3059\u3002");
        Jindolf.RUNTIME.exit(1);
        assert (false);
        throw new AssertionError();
    }

    private AppSetting() {
    }

    static {
        environmentMap = new TreeMap<String, String>();
        needHelp = false;
        needVersion = false;
        needVMInfo = false;
        boldMetal = false;
        noSplash = false;
        consolelog = false;
        frameWidth = 800;
        frameHeight = 600;
        frameXpos = Integer.MIN_VALUE;
        frameYpos = Integer.MIN_VALUE;
        initfont = null;
        antialias = null;
        fractional = null;
        configPath = null;
        needConfig = true;
        invokeArgs = new LinkedList<String>();
        geomPattern = Pattern.compile("([1-9][0-9]*)x([1-9][0-9]*)(?:(\\+|\\-)([1-9][0-9]*)(\\+|\\-)([1-9][0-9]*))?");
        osName = AppSetting.getSecureProperty("os.name");
        osVersion = AppSetting.getSecureProperty("os.version");
        osArch = AppSetting.getSecureProperty("os.arch");
        javaVendor = AppSetting.getSecureProperty("java.vendor");
        javaVersion = AppSetting.getSecureProperty("java.version");
        classpath = AppSetting.getSecureProperty("java.class.path");
        proxyHost = AppSetting.getSecureProperty("http.proxyHost");
        proxyPort = AppSetting.getSecureProperty("http.proxyPort");
        nonProxyHosts = AppSetting.getSecureProperty("http.nonProxyHosts");
        envLANG = AppSetting.getSecureEnvironment("LANG");
        envDISPLAY = AppSetting.getSecureEnvironment("DISPLAY");
        classpaths = classpath != null ? classpath.split(File.pathSeparator) : new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmdOption {
        OPT_HELP("help", "h", "-help", "?"),
        OPT_VERSION("version"),
        OPT_BOLDMETAL("boldMetal"),
        OPT_NOSPLASH("nosplash"),
        OPT_GEOMETRY("geometry"),
        OPT_VMINFO("vminfo"),
        OPT_CONSOLELOG("consolelog"),
        OPT_INITFONT("initfont"),
        OPT_ANTIALIAS("antialias"),
        OPT_FRACTIONAL("fractional"),
        OPT_CONFDIR("confdir"),
        OPT_NOCONF("noconfdir");

        private final List<String> nameList = new LinkedList<String>();

        public static CmdOption parseCmdOption(CharSequence seq) {
            for (CmdOption option : CmdOption.values()) {
                if (!option.matchHyphened(((Object)seq).toString())) continue;
                return option;
            }
            return null;
        }

        private CmdOption(CharSequence ... names) {
            if (names == null) {
                throw new NullPointerException();
            }
            if (names.length <= 0) {
                throw new IllegalArgumentException();
            }
            for (CharSequence name : names) {
                if (name == null) {
                    throw new NullPointerException();
                }
                this.nameList.add(((Object)name).toString().intern());
            }
        }

        public String toString() {
            return this.nameList.get(0);
        }

        public String toHyphened() {
            return "-" + this.toString();
        }

        public boolean matchHyphened(CharSequence option) {
            if (option == null) {
                return false;
            }
            for (String name : this.nameList) {
                String hyphened = "-" + name;
                if (!hyphened.equals(((Object)option).toString())) continue;
                return true;
            }
            return false;
        }
    }
}

