/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;

public class ActionManager {
    public static final String CMD_ACCOUNT = "ACCOUNT";
    public static final String CMD_EXIT = "EXIT";
    public static final String CMD_COPY = "COPY";
    public static final String CMD_SHOWFIND = "SHOWFIND";
    public static final String CMD_SEARCHNEXT = "SEARCHNEXT";
    public static final String CMD_SEARCHPREV = "SEARCHPREV";
    public static final String CMD_ALLPERIOD = "ALLPERIOD";
    public static final String CMD_SHOWDIGEST = "DIGEST";
    public static final String CMD_WEBVILL = "WEBVILL";
    public static final String CMD_WEBCAST = "WEBCAST";
    public static final String CMD_WEBWIKI = "WEBWIKI";
    public static final String CMD_RELOAD = "RELOAD";
    public static final String CMD_DAYSUMMARY = "DAYSUMMARY";
    public static final String CMD_DAYEXPCSV = "DAYEXPCSV";
    public static final String CMD_WEBDAY = "WEBDAY";
    public static final String CMD_FONTSEL = "FONTSELECT";
    public static final String CMD_LANDF = "LANDF";
    public static final String CMD_SHOWFILT = "SHOWFILT";
    public static final String CMD_SHOWEDIT = "SHOWEDIT";
    public static final String CMD_SHOWLOG = "SHOWLOG";
    public static final String CMD_HELPDOC = "HELPDOC";
    public static final String CMD_SHOWPORTAL = "SHOWPORTAL";
    public static final String CMD_ABOUT = "ABOUT";
    public static final String CMD_COPYTALK = "COPYTALK";
    public static final String CMD_JUMPANCHOR = "JUMPANCHOR";
    public static final String CMD_WEBTALK = "WEBTALK";
    public static final String CMD_SWITCHORDER = "SWITCHORDER";
    public static final String CMD_VILLAGELIST = "VILLAGELIST";
    public static final String CMD_FONTSIZESEL = "FONTSIZESEL";
    public static final String CMD_FONTAPPLY = "FONTAPPLY";
    public static final String CMD_FONTCANCEL = "FONTCANCEL";
    private static final KeyStroke KEY_F1 = KeyStroke.getKeyStroke("F1");
    private static final KeyStroke KEY_F3 = KeyStroke.getKeyStroke("F3");
    private static final KeyStroke KEY_SHIFT_F3 = KeyStroke.getKeyStroke("shift F3");
    private static final KeyStroke KEY_F5 = KeyStroke.getKeyStroke("F5");
    private static final KeyStroke KEY_CTRL_F = KeyStroke.getKeyStroke("ctrl F");
    public static final Icon ICON_WWW = GUIUtils.getWWWIcon();
    public static final Icon ICON_FIND;
    public static final Icon ICON_SEARCH_PREV;
    public static final Icon ICON_SEARCH_NEXT;
    public static final Icon ICON_RELOAD;
    public static final Icon ICON_FILTER;
    public static final Icon ICON_EDITOR;
    private final Set<AbstractButton> actionItems = new HashSet<AbstractButton>();
    private final Map<String, JMenuItem> namedMenuItems = new HashMap<String, JMenuItem>();
    private final Map<String, JButton> namedToolButtons = new HashMap<String, JButton>();
    private final JMenuBar menuBar;
    private final JMenu menuFile;
    private final JMenu menuEdit;
    private final JMenu menuVillage;
    private final JMenu menuDay;
    private final JMenu menuPreference;
    private final JMenu menuTool;
    private final JMenu menuHelp;
    private final JMenu menuLook;
    private final ButtonGroup landfGroup = new ButtonGroup();
    private final Map<ButtonModel, String> landfMap = new HashMap<ButtonModel, String>();
    private final JToolBar browseToolBar;

    public ActionManager() {
        this.menuFile = this.buildMenu("\u30d5\u30a1\u30a4\u30eb", 70);
        this.menuEdit = this.buildMenu("\u7de8\u96c6", 69);
        this.menuVillage = this.buildMenu("\u6751", 86);
        this.menuDay = this.buildMenu("\u65e5", 68);
        this.menuPreference = this.buildMenu("\u8a2d\u5b9a", 80);
        this.menuTool = this.buildMenu("\u30c4\u30fc\u30eb", 84);
        this.menuHelp = this.buildMenu("\u30d8\u30eb\u30d7", 72);
        this.menuLook = this.buildLookAndFeelMenu("\u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb", 76);
        this.buildMenuItem(CMD_ACCOUNT, "\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406", 77);
        this.buildMenuItem(CMD_EXIT, "\u7d42\u4e86", 88);
        this.buildMenuItem(CMD_COPY, "\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc", 67);
        this.buildMenuItem(CMD_SHOWFIND, "\u691c\u7d22...", 70);
        this.buildMenuItem(CMD_SEARCHNEXT, "\u6b21\u5019\u88dc", 78);
        this.buildMenuItem(CMD_SEARCHPREV, "\u524d\u5019\u88dc", 80);
        this.buildMenuItem(CMD_ALLPERIOD, "\u5168\u65e5\u7a0b\u306e\u4e00\u62ec\u8aad\u307f\u8fbc\u307f", 82);
        this.buildMenuItem(CMD_SHOWDIGEST, "\u6751\u306e\u30c0\u30a4\u30b8\u30a7\u30b9\u30c8\u3092\u8868\u793a...", 68);
        this.buildMenuItem(CMD_WEBVILL, "\u3053\u306e\u6751\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...", 78);
        this.buildMenuItem(CMD_WEBWIKI, "\u307e\u3068\u3081\u30b5\u30a4\u30c8\u306e\u6751\u30da\u30fc\u30b8\u3092\u8868\u793a...", 77);
        this.buildMenuItem(CMD_WEBCAST, "\u30ad\u30e3\u30b9\u30c8\u7d39\u4ecb\u8868\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf...", 72);
        this.buildMenuItem(CMD_RELOAD, "\u3053\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9", 82);
        this.buildMenuItem(CMD_DAYSUMMARY, "\u3053\u306e\u65e5\u306e\u767a\u8a00\u3092\u96c6\u8a08...", 68);
        this.buildMenuItem(CMD_DAYEXPCSV, "CSV\u3078\u30a8\u30af\u30b9\u30dd\u30fc\u30c8...", 67);
        this.buildMenuItem(CMD_WEBDAY, "\u3053\u306e\u65e5\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a...", 66);
        this.buildMenuItem(CMD_FONTSEL, "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u9078\u629e...", 70);
        this.buildMenuItem(CMD_SHOWFILT, "\u767a\u8a00\u30d5\u30a3\u30eb\u30bf", 70);
        this.buildMenuItem(CMD_SHOWEDIT, "\u767a\u8a00\u30a8\u30c7\u30a3\u30bf", 69);
        this.buildMenuItem(CMD_SHOWLOG, "\u30ed\u30b0\u8868\u793a", 83);
        this.buildMenuItem(CMD_HELPDOC, "\u30d8\u30eb\u30d7\u8868\u793a", 72);
        this.buildMenuItem(CMD_SHOWPORTAL, "\u30dd\u30fc\u30bf\u30eb\u30b5\u30a4\u30c8...", 80);
        this.buildMenuItem(CMD_ABOUT, Jindolf.TITLE + "\u306b\u3064\u3044\u3066...", 65);
        this.buildToolButton(CMD_RELOAD, "\u9078\u629e\u4e2d\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9", ICON_RELOAD);
        this.buildToolButton(CMD_SHOWFIND, "\u691c\u7d22", ICON_FIND);
        this.buildToolButton(CMD_SEARCHPREV, "\u2191\u524d\u5019\u88dc", ICON_SEARCH_PREV);
        this.buildToolButton(CMD_SEARCHNEXT, "\u2193\u6b21\u5019\u88dc", ICON_SEARCH_NEXT);
        this.buildToolButton(CMD_SHOWFILT, "\u767a\u8a00\u30d5\u30a3\u30eb\u30bf", ICON_FILTER);
        this.buildToolButton(CMD_SHOWEDIT, "\u767a\u8a00\u30a8\u30c7\u30a3\u30bf", ICON_EDITOR);
        this.getMenuItem(CMD_SHOWPORTAL).setIcon(ICON_WWW);
        this.getMenuItem(CMD_WEBVILL).setIcon(ICON_WWW);
        this.getMenuItem(CMD_WEBWIKI).setIcon(ICON_WWW);
        this.getMenuItem(CMD_WEBCAST).setIcon(ICON_WWW);
        this.getMenuItem(CMD_WEBDAY).setIcon(ICON_WWW);
        this.getMenuItem(CMD_SHOWFIND).setIcon(ICON_FIND);
        this.getMenuItem(CMD_SEARCHPREV).setIcon(ICON_SEARCH_PREV);
        this.getMenuItem(CMD_SEARCHNEXT).setIcon(ICON_SEARCH_NEXT);
        this.getMenuItem(CMD_SHOWFILT).setIcon(ICON_FILTER);
        this.getMenuItem(CMD_SHOWEDIT).setIcon(ICON_EDITOR);
        this.registKeyAccelerator();
        this.menuBar = this.buildMenuBar();
        this.browseToolBar = this.buildBrowseToolBar();
        this.appearVillageImpl(false);
        this.appearPeriodImpl(false);
    }

    private JMenu buildMenu(String label, int nemonic) {
        JMenu result = new JMenu();
        String keyText = label + "(" + KeyEvent.getKeyText(nemonic) + ")";
        result.setText(keyText);
        result.setMnemonic(nemonic);
        return result;
    }

    private JMenuItem buildMenuItem(String command, String label, int nemonic) {
        JMenuItem result = new JMenuItem();
        String keyText = label + "(" + KeyEvent.getKeyText(nemonic) + ")";
        result.setActionCommand(command);
        result.setText(keyText);
        result.setMnemonic(nemonic);
        this.actionItems.add(result);
        this.namedMenuItems.put(command, result);
        return result;
    }

    private JButton buildToolButton(String command, String tooltip, Icon icon) {
        JButton result = new JButton();
        result.setIcon(icon);
        result.setToolTipText(tooltip);
        result.setMargin(new Insets(1, 1, 1, 1));
        result.setActionCommand(command);
        this.actionItems.add(result);
        this.namedToolButtons.put(command, result);
        return result;
    }

    private JMenu buildLookAndFeelMenu(String label, int nemonic) {
        UIManager.LookAndFeelInfo[] landfs;
        JMenu result = this.buildMenu(label, nemonic);
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;
        for (UIManager.LookAndFeelInfo lafInfo : landfs = UIManager.getInstalledLookAndFeels()) {
            String name = lafInfo.getName();
            String className = lafInfo.getClassName();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(CMD_LANDF);
            if (className.equals(currentName)) {
                matchedButton = button;
            }
            this.actionItems.add(button);
            this.landfGroup.add(button);
            this.landfMap.put(button.getModel(), className);
            result.add(button);
        }
        if (matchedButton != null) {
            matchedButton.setSelected(true);
        }
        return result;
    }

    private void registKeyAccelerator() {
        this.getMenuItem(CMD_HELPDOC).setAccelerator(KEY_F1);
        this.getMenuItem(CMD_SHOWFIND).setAccelerator(KEY_CTRL_F);
        this.getMenuItem(CMD_SEARCHNEXT).setAccelerator(KEY_F3);
        this.getMenuItem(CMD_SEARCHPREV).setAccelerator(KEY_SHIFT_F3);
        this.getMenuItem(CMD_RELOAD).setAccelerator(KEY_F5);
    }

    private JMenuItem getMenuItem(String command) {
        JMenuItem result = this.namedMenuItems.get(command);
        return result;
    }

    private JButton getToolButton(String command) {
        JButton result = this.namedToolButtons.get(command);
        return result;
    }

    public String getSelectedLookAndFeel() {
        ButtonModel selected = this.landfGroup.getSelection();
        if (selected == null) {
            return null;
        }
        String className = this.landfMap.get(selected);
        return className;
    }

    public void addActionListener(ActionListener listener) {
        for (AbstractButton button : this.actionItems) {
            button.addActionListener(listener);
        }
    }

    private JMenuBar buildMenuBar() {
        this.menuFile.add(this.getMenuItem(CMD_ACCOUNT));
        this.menuFile.addSeparator();
        this.menuFile.add(this.getMenuItem(CMD_EXIT));
        this.menuEdit.add(this.getMenuItem(CMD_COPY));
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.getMenuItem(CMD_SHOWFIND));
        this.menuEdit.add(this.getMenuItem(CMD_SEARCHPREV));
        this.menuEdit.add(this.getMenuItem(CMD_SEARCHNEXT));
        this.menuVillage.add(this.getMenuItem(CMD_ALLPERIOD));
        this.menuVillage.add(this.getMenuItem(CMD_SHOWDIGEST));
        this.menuVillage.addSeparator();
        this.menuVillage.add(this.getMenuItem(CMD_WEBVILL));
        this.menuVillage.add(this.getMenuItem(CMD_WEBWIKI));
        this.menuVillage.add(this.getMenuItem(CMD_WEBCAST));
        this.menuDay.add(this.getMenuItem(CMD_RELOAD));
        this.menuDay.add(this.getMenuItem(CMD_DAYSUMMARY));
        this.menuDay.add(this.getMenuItem(CMD_DAYEXPCSV));
        this.menuDay.addSeparator();
        this.menuDay.add(this.getMenuItem(CMD_WEBDAY));
        this.menuPreference.add(this.getMenuItem(CMD_FONTSEL));
        this.menuPreference.addSeparator();
        this.menuPreference.add(this.menuLook);
        this.menuTool.add(this.getMenuItem(CMD_SHOWFILT));
        this.menuTool.add(this.getMenuItem(CMD_SHOWEDIT));
        this.menuTool.add(this.getMenuItem(CMD_SHOWLOG));
        this.menuHelp.add(this.getMenuItem(CMD_HELPDOC));
        this.menuHelp.addSeparator();
        this.menuHelp.add(this.getMenuItem(CMD_SHOWPORTAL));
        this.menuHelp.add(this.getMenuItem(CMD_ABOUT));
        JMenuBar bar = new JMenuBar();
        bar.add(this.menuFile);
        bar.add(this.menuEdit);
        bar.add(this.menuVillage);
        bar.add(this.menuDay);
        bar.add(this.menuPreference);
        bar.add(this.menuTool);
        bar.add(this.menuHelp);
        return bar;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private JToolBar buildBrowseToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.getToolButton(CMD_RELOAD));
        toolBar.addSeparator();
        toolBar.add(this.getToolButton(CMD_SHOWFIND));
        toolBar.add(this.getToolButton(CMD_SEARCHNEXT));
        toolBar.add(this.getToolButton(CMD_SEARCHPREV));
        toolBar.addSeparator();
        toolBar.add(this.getToolButton(CMD_SHOWFILT));
        toolBar.add(this.getToolButton(CMD_SHOWEDIT));
        return toolBar;
    }

    public JToolBar getBrowseToolBar() {
        return this.browseToolBar;
    }

    private void appearPeriodImpl(boolean appear) {
        if (appear) {
            this.appearVillageImpl(appear);
        }
        this.menuEdit.setEnabled(appear);
        this.menuDay.setEnabled(appear);
        this.getToolButton(CMD_RELOAD).setEnabled(appear);
        this.getToolButton(CMD_SHOWFIND).setEnabled(appear);
        this.getToolButton(CMD_SEARCHNEXT).setEnabled(appear);
        this.getToolButton(CMD_SEARCHPREV).setEnabled(appear);
    }

    public void appearPeriod(boolean appear) {
        this.appearPeriodImpl(appear);
    }

    private void appearVillageImpl(boolean appear) {
        if (!appear) {
            this.appearPeriodImpl(appear);
        }
        this.menuVillage.setEnabled(appear);
    }

    public void appearVillage(boolean appear) {
        this.appearVillageImpl(appear);
    }

    static {
        URL iconurl = Jindolf.getResource("resources/image/find.png");
        ICON_FIND = new ImageIcon(iconurl);
        iconurl = Jindolf.getResource("resources/image/findprev.png");
        ICON_SEARCH_PREV = new ImageIcon(iconurl);
        iconurl = Jindolf.getResource("resources/image/findnext.png");
        ICON_SEARCH_NEXT = new ImageIcon(iconurl);
        iconurl = Jindolf.getResource("resources/image/reload.png");
        ICON_RELOAD = new ImageIcon(iconurl);
        iconurl = Jindolf.getResource("resources/image/filter.png");
        ICON_FILTER = new ImageIcon(iconurl);
        iconurl = Jindolf.getResource("resources/image/editor.png");
        ICON_EDITOR = new ImageIcon(iconurl);
    }
}

