/*
 * CodeX0208 Test
 *
 * $Id: CodeX0208Test.java 393 2009-02-13 09:54:29Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 */
public class CodeX0208Test {

    public CodeX0208Test() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception{
    }

    @AfterClass
    public static void tearDownClass() throws Exception{
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of isValid method, of class CodeX0208.
     */
    @Test
    public void testIsValid(){
        System.out.println("isValid");

        assertTrue (CodeX0208.isValid('A'));
        assertTrue (CodeX0208.isValid('狼'));
        assertFalse(CodeX0208.isValid('㍻'));

        return;
    }

    /**
     * Test of isShiftJIS1stByte method, of class CodeX0208.
     */
    @Test
    public void testIsShiftJIS1stByte(){
        System.out.println("isShiftJIS1stByte");

        assertFalse(CodeX0208.isShiftJIS1stByte( (byte) 0x80 ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0x81 ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0x82 ));

        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0x9e ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0x9f ));
        assertFalse(CodeX0208.isShiftJIS1stByte( (byte) 0xa0 ));

        assertFalse(CodeX0208.isShiftJIS1stByte( (byte) 0xdf ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0xe0 ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0xe1 ));

        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0xfb ));
        assertTrue (CodeX0208.isShiftJIS1stByte( (byte) 0xfc ));
        assertFalse(CodeX0208.isShiftJIS1stByte( (byte) 0xfd ));

        return;
    }

    /**
     * Test of isShiftJIS2ndByte method, of class CodeX0208.
     */
    @Test
    public void testIsShiftJIS2ndByte(){
        System.out.println("isShiftJIS2ndByte");

        assertFalse(CodeX0208.isShiftJIS2ndByte( (byte) 0x3f ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x40 ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x41 ));

        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x7d ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x7e ));
        assertFalse(CodeX0208.isShiftJIS2ndByte( (byte) 0x7f ));

        assertFalse(CodeX0208.isShiftJIS2ndByte( (byte) 0x7f ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x80 ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0x81 ));

        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0xfb ));
        assertTrue (CodeX0208.isShiftJIS2ndByte( (byte) 0xfc ));
        assertFalse(CodeX0208.isShiftJIS2ndByte( (byte) 0xfd ));

        return;
    }

    /**
     * Test of txSjisToKuten method, of class CodeX0208.
     */
    @Test
    public void testTxSjisToKuten(){
        System.out.println("txSjisToKuten");
        int[] chs = new int[2];

        // 狼
        chs[0] = 0x98;
        chs[1] = 0x54;
        CodeX0208.txSjisToKuten(chs);
        assertEquals(47, chs[0]);
        assertEquals(21, chs[1]);

        // 、
        chs[0] = 0x81;
        chs[1] = 0x41;
        CodeX0208.txSjisToKuten(chs);
        assertEquals(1, chs[0]);
        assertEquals(2, chs[1]);

        // 熙
        chs[0] = 0xea;
        chs[1] = 0xa4;
        CodeX0208.txSjisToKuten(chs);
        assertEquals(84, chs[0]);
        assertEquals( 6, chs[1]);

        return;
    }

}
