/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;

public class TallyInputStream
extends InputStream {
    private static final int BUFSIZE = 512;
    private final HttpURLConnection conn;
    private final InputStream in;
    private long counter;
    private long nanoLap;

    public static InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        return new TallyInputStream(httpURLConnection);
    }

    protected TallyInputStream(HttpURLConnection httpURLConnection) throws IOException {
        this.conn = httpURLConnection;
        this.counter = 0L;
        this.nanoLap = 0L;
        InputStream inputStream = this.conn.getInputStream();
        this.in = inputStream = new BufferedInputStream(inputStream, 512);
    }

    protected long getCount() {
        return this.counter;
    }

    public int available() throws IOException {
        int n = this.in.available();
        return n;
    }

    public void close() throws IOException {
        this.in.close();
        long l = this.getCount();
        long l2 = System.nanoTime() - this.nanoLap;
        String string = HttpUtils.formatHttpStat(this.conn, l, l2);
        Jindolf.logger.info(string);
    }

    public int read() throws IOException {
        int n;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((n = this.in.read()) >= 0) {
            ++this.counter;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((n = this.in.read(byArray)) >= 0) {
            this.counter += (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        if ((n3 = this.in.read(byArray, n, n2)) >= 0) {
            this.counter += (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.counter <= 0L) {
            this.nanoLap = System.nanoTime();
        }
        long l2 = this.in.skip(l);
        this.counter += l2;
        return l2;
    }
}

