/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.SortedMap;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Talk
implements Topic {
    private final Period homePeriod;
    private final Type talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private final CharSequence dialog;
    private final int charNum;
    private final SortedMap<Long, byte[]> encodeError;
    private int count = -1;

    public static Type decodeType(CharSequence charSequence) {
        Type type;
        if ("say".contentEquals(charSequence)) {
            type = Type.PUBLIC;
        } else if ("think".contentEquals(charSequence)) {
            type = Type.PRIVATE;
        } else if ("whisper".contentEquals(charSequence)) {
            type = Type.WOLFONLY;
        } else if ("groan".contentEquals(charSequence)) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static String encodeColorName(Type type) {
        String string;
        switch (type) {
            case PUBLIC: {
                string = "\u767d";
                break;
            }
            case PRIVATE: {
                string = "\u7070";
                break;
            }
            case WOLFONLY: {
                string = "\u8d64";
                break;
            }
            case GRAVE: {
                string = "\u9752";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return string;
    }

    public Talk(Period period, Type type, Avatar avatar, String string, int n, int n2, CharSequence charSequence, SortedMap<Long, byte[]> sortedMap) {
        if (period == null || type == null || avatar == null || string == null || charSequence == null) {
            throw new NullPointerException();
        }
        if (n < 0 || 23 < n) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || 59 < n2) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = period;
        this.talkType = type;
        this.avatar = avatar;
        this.messageID = string;
        this.hour = n;
        this.minute = n2;
        this.dialog = charSequence;
        this.charNum = this.dialog.length();
        this.encodeError = sortedMap;
    }

    public Period getPeriod() {
        return this.homePeriod;
    }

    public Type getTalkType() {
        return this.talkType;
    }

    public int getTalkCount() {
        return this.count;
    }

    public int getTotalChars() {
        return this.charNum;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public long getTimeFromID() {
        String string = this.messageID.replace("mes", "");
        long l = Long.parseLong(string) * 1000L;
        return l;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public CharSequence getDialog() {
        return this.dialog;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public String getAnchorNotation() {
        int n = this.homePeriod.getDay();
        String string = "0" + this.hour;
        string = string.substring(string.length() - 2);
        String string2 = "0" + this.minute;
        string2 = string2.substring(string2.length() - 2);
        return String.valueOf(n) + "d" + string + ":" + string2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.avatar.getFullName());
        if (this.talkType == Type.PUBLIC) {
            stringBuilder.append(" says ");
        } else if (this.talkType == Type.PRIVATE) {
            stringBuilder.append(" think ");
        } else if (this.talkType == Type.WOLFONLY) {
            stringBuilder.append(" howl ");
        } else if (this.talkType == Type.GRAVE) {
            stringBuilder.append(" groan ");
        }
        stringBuilder.append(this.dialog);
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUBLIC,
        WOLFONLY,
        PRIVATE,
        GRAVE;

    }
}

