/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.VillageIconRenderer;

public class LandsTree
extends JPanel
implements ActionListener,
TreeSelectionListener {
    private static final String ascendingTip = "\u62bc\u3059\u3068\u964d\u9806\u306b";
    private static final String descendingTip = "\u62bc\u3059\u3068\u6607\u9806\u306b";
    private static final String orderTip = "\u9078\u629e\u4e2d\u306e\u56fd\u306e\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u76f4\u3059";
    private static final ImageIcon ascendIcon;
    private static final ImageIcon descendIcon;
    private final JButton orderButton = new JButton();
    private final JButton reloadButton = new JButton();
    private final JTree treeView = new JTree();
    private boolean ascending = false;

    public LandsTree() {
        this.design();
        this.orderButton.setIcon(descendIcon);
        this.orderButton.setToolTipText(descendingTip);
        this.orderButton.setMargin(new Insets(1, 1, 1, 1));
        this.orderButton.setActionCommand("SWITCHORDER");
        this.orderButton.addActionListener(this);
        URL uRL = Jindolf.getResource("resources/image/reload.png");
        this.reloadButton.setIcon(new ImageIcon(uRL));
        this.reloadButton.setToolTipText(orderTip);
        this.reloadButton.setMargin(new Insets(1, 1, 1, 1));
        this.reloadButton.setActionCommand("VILLAGELIST");
        TreeSelectionModel treeSelectionModel = this.treeView.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.treeView.addTreeSelectionListener(this);
    }

    private void design() {
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.orderButton);
        jToolBar.add(this.reloadButton);
        JComponent jComponent = this.createLandSelector();
        this.add((Component)jToolBar, "North");
        this.add((Component)jComponent, "Center");
    }

    private JComponent createLandSelector() {
        this.treeView.setRootVisible(false);
        this.treeView.setCellRenderer(new VillageIconRenderer());
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.treeView.setBorder(border);
        JScrollPane jScrollPane = new JScrollPane(this.treeView);
        return jScrollPane;
    }

    public JButton getReloadVillageListButton() {
        return this.reloadButton;
    }

    public JTree getTreeView() {
        return this.treeView;
    }

    public void expandLand(Land land) {
        TreeModel treeModel = this.treeView.getModel();
        Object object = treeModel.getRoot();
        Object[] objectArray = new Object[]{object, land};
        TreePath treePath = new TreePath(objectArray);
        this.treeView.expandPath(treePath);
    }

    private LandsModel getLandsModel() {
        TreeModel treeModel = this.treeView.getModel();
        if (treeModel instanceof LandsModel) {
            return (LandsModel)treeModel;
        }
        return null;
    }

    private boolean toggleTreeOrder() {
        boolean bl = this.ascending = !this.ascending;
        if (this.ascending) {
            this.orderButton.setToolTipText(ascendingTip);
            this.orderButton.setIcon(ascendIcon);
        } else {
            this.orderButton.setToolTipText(descendingTip);
            this.orderButton.setIcon(descendIcon);
        }
        final TreePath treePath = this.treeView.getSelectionPath();
        LandsModel landsModel = this.getLandsModel();
        if (landsModel != null) {
            landsModel.setAscending(this.ascending);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (treePath != null) {
                    LandsTree.this.treeView.setSelectionPath(treePath);
                    LandsTree.this.treeView.scrollPathToVisible(treePath);
                }
            }
        });
        return this.ascending;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("SWITCHORDER".equals(string)) {
            this.toggleTreeOrder();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            this.reloadButton.setEnabled(false);
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof Land) {
            this.reloadButton.setEnabled(true);
        } else {
            this.reloadButton.setEnabled(false);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.treeView != null) {
            this.treeView.setCellRenderer(new VillageIconRenderer());
        }
    }

    static {
        URL uRL = Jindolf.getResource("resources/image/ascend.png");
        ascendIcon = new ImageIcon(uRL);
        uRL = Jindolf.getResource("resources/image/descend.png");
        descendIcon = new ImageIcon(uRL);
    }
}

