/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TextPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontChooser
extends JDialog
implements ListSelectionListener,
ActionListener,
ItemListener,
WindowListener {
    public static final Font defaultFont;
    public static final FontRenderContext defaultRenderContext;
    private static final String FRAMETITLE;
    private static final String[] initFamilyNames;
    private static final Integer[] pointSizes;
    private static final int defaultFontStyle = 0;
    private static final int defaultFontSize = 16;
    private static final SortedSet<String> familySet;
    private static final CharSequence previewContent;
    private static final String CHECK_CODE = "9A\u3042\u3091\u30a2\uff71\u30f4\u30f0\u253c\u0416\u03a9\u5ce0\u51dc\u7199";
    private Font selectedFont = defaultFont;
    private FontRenderContext renderContext = defaultRenderContext;
    private Font lastFont = this.selectedFont;
    private FontRenderContext lastContext = this.renderContext;
    private final JList familySelector;
    private final JComboBox sizeSelector;
    private final JCheckBox isBoldCheck;
    private final JCheckBox isItalicCheck;
    private final JCheckBox useTextAntiAliaseCheck;
    private final JCheckBox useFractionalCheck;
    private final JLabel maxBounds;
    private final JTextField invokeOption;
    private final FontPreview preview;
    private final JButton applyButton;
    private final JButton cancelButton;
    private boolean maskListener = false;
    private boolean isCanceled = false;

    private static SortedSet<String> createFontSet() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Font font : fontArray) {
            if (font.canDisplayUpTo(CHECK_CODE) >= 0) continue;
            String string = font.getFamily();
            treeSet.add(string.intern());
        }
        return treeSet;
    }

    private static Font createDefaultFont() {
        String string = "Dialog";
        for (String string2 : initFamilyNames) {
            Font font = new Font(string2, 0, 1);
            String string3 = font.getFamily();
            if (!string3.equals(string2)) continue;
            string = string3;
            break;
        }
        Font font = new Font(string, 0, 16);
        return font;
    }

    private static FontRenderContext createDefaultFontRenderContext() {
        boolean bl = true;
        boolean bl2 = true;
        if (FontChooser.guessBitmapFont(defaultFont)) {
            bl = false;
            bl2 = false;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(GUIUtils.AFFINETX_IDENTITY, bl, bl2);
        return fontRenderContext;
    }

    public static boolean guessBitmapFont(Font font) {
        String string = font.getFamily();
        return font.getSize() < 24 && string.startsWith("\uff2d\uff33") && (string.contains("\u30b4\u30b7\u30c3\u30af") || string.contains("\u660e\u671d"));
    }

    public FontChooser(Frame frame) {
        super(frame, FRAMETITLE, true);
        Jindolf.logger.info("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306b" + this.selectedFont + "\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger.info("\u767a\u8a00\u8868\u793a\u306e\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9\u6307\u5b9a\u306b" + this.renderContext.isAntiAliased() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger.info("\u767a\u8a00\u8868\u793a\u306eFractional\u6307\u5b9a\u306b" + this.renderContext.usesFractionalMetrics() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Vector<String> vector = new Vector<String>(familySet);
        this.familySelector = new JList<String>(vector);
        this.familySelector.setVisibleRowCount(-1);
        this.familySelector.setSelectionMode(0);
        this.sizeSelector = new JComboBox();
        this.sizeSelector.setEditable(true);
        this.sizeSelector.setActionCommand("FONTSIZESEL");
        for (Integer n : pointSizes) {
            this.sizeSelector.addItem(n);
        }
        this.isBoldCheck = new JCheckBox("\u30dc\u30fc\u30eb\u30c9");
        this.isItalicCheck = new JCheckBox("\u30a4\u30bf\u30ea\u30c3\u30af");
        this.useTextAntiAliaseCheck = new JCheckBox("\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9");
        this.useFractionalCheck = new JCheckBox("\u30b5\u30d6\u30d4\u30af\u30bb\u30eb\u7cbe\u5ea6");
        this.maxBounds = new JLabel();
        this.invokeOption = new JTextField();
        this.invokeOption.setEditable(false);
        this.invokeOption.setMargin(new Insets(1, 4, 1, 4));
        this.invokeOption.setComponentPopupMenu(new TextPopup());
        GUIUtils.forceMonoPitchFont(this.invokeOption);
        this.preview = new FontPreview(previewContent, this.selectedFont, this.renderContext);
        this.applyButton = new JButton("\u9069\u7528\u3059\u308b");
        this.cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.applyButton.setActionCommand("FONTAPPLY");
        this.cancelButton.setActionCommand("FONTCANCEL");
        this.getRootPane().setDefaultButton(this.applyButton);
        this.design();
        this.updateControlls();
        this.updatePreview();
        this.familySelector.addListSelectionListener(this);
        this.sizeSelector.addActionListener(this);
        this.isBoldCheck.addItemListener(this);
        this.isItalicCheck.addItemListener(this);
        this.useTextAntiAliaseCheck.addItemListener(this);
        this.useFractionalCheck.addItemListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void design() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        JComponent jComponent = this.createFontPrefPanel();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        container.add((Component)jComponent, gridBagConstraints);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.invokeOption, "Center");
        jPanel.setBorder(titledBorder);
        container.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        titledBorder = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        jPanel = new JPanel();
        jPanel.add(this.preview);
        jPanel.setBorder(titledBorder);
        container.add((Component)this.createPreviewPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        container.add((Component)this.maxBounds, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        container.add((Component)this.applyButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        container.add((Component)this.cancelButton, gridBagConstraints);
    }

    private JComponent createFontPrefPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.familySelector.setBorder(border);
        JScrollPane jScrollPane = new JScrollPane(this.familySelector);
        border = BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8\u30d5\u30a1\u30df\u30ea\u9078\u629e");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(border);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        border = BorderFactory.createTitledBorder("\u30dd\u30a4\u30f3\u30c8\u30b5\u30a4\u30ba\u6307\u5b9a");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.sizeSelector);
        jPanel3.setBorder(border);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.isBoldCheck, gridBagConstraints);
        jPanel.add((Component)this.isItalicCheck, gridBagConstraints);
        jPanel.add((Component)this.useTextAntiAliaseCheck, gridBagConstraints);
        jPanel.add((Component)this.useFractionalCheck, gridBagConstraints);
        return jPanel;
    }

    private JComponent createPreviewPanel() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.preview);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.updateControlls();
        this.updatePreview();
    }

    public FontRenderContext getFontRenderContext() {
        return this.renderContext;
    }

    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        this.renderContext = fontRenderContext;
        this.updateControlls();
        this.updatePreview();
    }

    private void updatePreview() {
        this.preview.setFontInfo(this.selectedFont, this.renderContext);
    }

    private void updateControlls() {
        Object object;
        this.maskListener = true;
        String string = this.selectedFont.getFamily().intern();
        this.familySelector.setSelectedValue(string, true);
        Integer n = new Integer(this.selectedFont.getSize());
        this.sizeSelector.setSelectedItem(n);
        int n2 = this.sizeSelector.getItemCount();
        for (int i = 0; i <= n2 - 1; ++i) {
            object = this.sizeSelector.getItemAt(i);
            if (!object.equals(n)) continue;
            this.sizeSelector.setSelectedIndex(i);
            break;
        }
        this.isBoldCheck.setSelected(this.selectedFont.isBold());
        this.isItalicCheck.setSelected(this.selectedFont.isItalic());
        this.useTextAntiAliaseCheck.setSelected(this.renderContext.isAntiAliased());
        this.useFractionalCheck.setSelected(this.renderContext.usesFractionalMetrics());
        StringBuilder stringBuilder = new StringBuilder();
        object = new StringBuilder();
        if (this.selectedFont.isBold()) {
            ((StringBuilder)object).append("BOLD");
        }
        if (this.selectedFont.isItalic()) {
            ((StringBuilder)object).append("ITALIC");
        }
        if (((StringBuilder)object).length() <= 0) {
            ((StringBuilder)object).append("PLAIN");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(this.selectedFont.getFamily());
        stringBuilder2.append('-').append((CharSequence)object);
        stringBuilder2.append('-').append(this.selectedFont.getSize());
        if (stringBuilder2.indexOf(" ") >= 0) {
            stringBuilder2.insert(0, '\"').append('\"');
        }
        stringBuilder.append("-initfont ").append((CharSequence)stringBuilder2);
        stringBuilder.append(" -antialias ");
        if (this.renderContext.isAntiAliased()) {
            stringBuilder.append("on");
        } else {
            stringBuilder.append("off");
        }
        stringBuilder.append(" -fractional ");
        if (this.renderContext.usesFractionalMetrics()) {
            stringBuilder.append("on");
        } else {
            stringBuilder.append("off");
        }
        this.invokeOption.setText(stringBuilder.toString());
        this.invokeOption.setCaretPosition(0);
        Rectangle2D rectangle2D = this.selectedFont.getMaxCharBounds(this.renderContext);
        Rectangle rectangle = rectangle2D.getBounds();
        String string2 = "\u6700\u5927\u6587\u5b57\u5bf8\u6cd5 : " + rectangle.width + " pixel\u5e45 \u00d7 " + rectangle.height + " pixel\u9ad8";
        this.maxBounds.setText(string2);
        this.maskListener = false;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.updateControlls();
            this.updatePreview();
        }
        this.lastFont = this.selectedFont;
        this.lastContext = this.renderContext;
        super.setVisible(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.maskListener) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object != this.isBoldCheck && object != this.isItalicCheck && object != this.useTextAntiAliaseCheck && object != this.useFractionalCheck) {
            return;
        }
        int n = 0;
        if (this.isBoldCheck.isSelected()) {
            n |= 1;
        }
        if (this.isItalicCheck.isSelected()) {
            n |= 2;
        }
        if (this.selectedFont.getStyle() != n) {
            this.selectedFont = this.selectedFont.deriveFont(n);
        }
        boolean bl = this.useTextAntiAliaseCheck.isSelected();
        boolean bl2 = this.useFractionalCheck.isSelected();
        AffineTransform affineTransform = this.renderContext.getTransform();
        this.renderContext = new FontRenderContext(affineTransform, bl, bl2);
        this.updateControlls();
        this.updatePreview();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void actionApply() {
        this.isCanceled = false;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.selectedFont = this.lastFont;
        this.renderContext = this.lastContext;
        this.setVisible(false);
    }

    private void actionFontSizeSelected() {
        Integer n;
        Object object = this.sizeSelector.getSelectedItem();
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        } else {
            try {
                n = new Integer(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                n = new Integer(this.lastFont.getSize());
            }
        }
        if (n <= 0) {
            n = new Integer(this.lastFont.getSize());
        }
        float f = n.floatValue();
        this.selectedFont = this.selectedFont.deriveFont(f);
        int n2 = this.sizeSelector.getItemCount();
        for (int i = 0; i <= n2 - 1; ++i) {
            Object e = this.sizeSelector.getItemAt(i);
            if (!e.equals(n)) continue;
            this.sizeSelector.setSelectedIndex(i);
            break;
        }
        this.updateControlls();
        this.updatePreview();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.maskListener) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("FONTAPPLY")) {
            this.actionApply();
        } else if (string.equals("FONTCANCEL")) {
            this.actionCancel();
        } else if (string.equals("FONTSIZESEL")) {
            this.actionFontSizeSelected();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.maskListener) {
            return;
        }
        if (listSelectionEvent.getSource() != this.familySelector) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object e = this.familySelector.getSelectedValue();
        if (e == null) {
            return;
        }
        String string = e.toString();
        int n = this.selectedFont.getStyle();
        int n2 = this.selectedFont.getSize();
        this.selectedFont = new Font(string, n, n2);
        this.updateControlls();
        this.updatePreview();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.actionCancel();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    static {
        CharSequence charSequence;
        FRAMETITLE = "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306e\u9078\u629e - " + Jindolf.TITLE;
        initFamilyNames = new String[]{"Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Osaka", "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af"};
        pointSizes = new Integer[]{8, 10, 12, 16, 18, 24, 32, 36, 48, 72};
        familySet = FontChooser.createFontSet();
        defaultFont = FontChooser.createDefaultFont();
        defaultRenderContext = FontChooser.createDefaultFontRenderContext();
        try {
            charSequence = Jindolf.loadResourceText("resources/preview.txt");
        }
        catch (IOException iOException) {
            charSequence = "ABC";
        }
        previewContent = charSequence;
    }

    private static class FontPreview
    extends JComponent {
        private static int MARGIN = 5;
        private final GlyphDraw draw;
        private Font font;
        private FontRenderContext renderContext;

        public FontPreview(CharSequence charSequence, Font font, FontRenderContext fontRenderContext) {
            this.font = font;
            this.renderContext = fontRenderContext;
            this.draw = new GlyphDraw(charSequence);
            this.draw.setFontInfo(this.font, this.renderContext);
            this.draw.setPos(MARGIN, MARGIN);
            this.draw.setColor(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.updateBounds();
        }

        private void updateBounds() {
            Rectangle rectangle = this.draw.setWidth(Integer.MAX_VALUE);
            Dimension dimension = new Dimension(rectangle.width + MARGIN * 2, rectangle.height + MARGIN * 2);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }

        public void setFontInfo(Font font, FontRenderContext fontRenderContext) {
            this.font = font;
            this.renderContext = fontRenderContext;
            this.draw.setFontInfo(this.font, this.renderContext);
            this.updateBounds();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.draw.paint(graphics2D);
        }
    }
}

