/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.HTMLUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.TextPopup;
import jp.sourceforge.jindolf.Village;

public class TopView
extends JPanel {
    private static final String INITCARD = "INITCARD";
    private static final String LANDCARD = "LANDINFO";
    private static final String BROWSECARD = "BROWSER";
    private static final DateFormat dform = DateFormat.getDateTimeInstance(0, 0);
    private final JComponent cards;
    private final CardLayout cardLayout = new CardLayout();
    private final LandsTree landsTreeView = new LandsTree();
    private final JPanel landInfo = new JPanel();
    private final JTextField sysMessage = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();
    private final TabBrowser tabBrowser = new TabBrowser();
    private JComponent browsePanel;

    public TopView() {
        this.cards = this.createCards();
        JComponent split = this.createSplitPane(this.landsTreeView, this.cards);
        JComponent statusBar = this.createStatusBar();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.add((Component)split, "Center");
        this.add((Component)statusBar, "South");
    }

    private JComponent createCards() {
        this.browsePanel = this.createBrowsePanel();
        JPanel panel = new JPanel();
        panel.setLayout(this.cardLayout);
        panel.add(INITCARD, this.createInitPanel());
        panel.add(LANDCARD, this.createLandInfo());
        panel.add(BROWSECARD, this.browsePanel);
        return panel;
    }

    private JComponent createInitPanel() {
        JLabel initMessage = new JLabel("\u6751\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044");
        StringBuilder warn = new StringBuilder();
        warn.append("\u203b \u305f\u307e\u306b\u306fWeb\u30d6\u30e9\u30a6\u30b6\u3067\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3001");
        warn.append("<br></br>");
        warn.append("\u904b\u55b6\u306e\u52d5\u5411\u3092\u78ba\u304b\u3081\u3088\u3046\u306d\uff01");
        warn = HTMLUtils.elemented("center", warn);
        warn = HTMLUtils.elemented("body", warn);
        warn = HTMLUtils.elemented("html", warn);
        JLabel warnMessage = new JLabel(warn.toString());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 10;
        constraints.gridx = 0;
        panel.add((Component)initMessage, constraints);
        panel.add((Component)warnMessage, constraints);
        JScrollPane scrollPane = new JScrollPane(panel);
        return scrollPane;
    }

    private JComponent createLandInfo() {
        this.landInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane scrollPane = new JScrollPane(this.landInfo);
        return scrollPane;
    }

    private JComponent createBrowsePanel() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        panel.setLayout(layout);
        panel.add((Component)this.tabBrowser, "Center");
        return panel;
    }

    public void setBrowseToolBar(JToolBar toolbar) {
        this.browsePanel.add((Component)toolbar, "North");
    }

    private JComponent createSplitPane(JComponent left, JComponent right) {
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(left);
        split.setRightComponent(right);
        split.setOrientation(1);
        split.setContinuousLayout(false);
        split.setOneTouchExpandable(true);
        split.setDividerLocation(200);
        return split;
    }

    private JComponent createStatusBar() {
        this.sysMessage.setText(Jindolf.TITLE + " " + "2.15.2" + " \u3092\u4f7f\u3063\u3066\u304f\u308c\u3066\u3042\u308a\u304c\u3068\u3046\uff01");
        this.sysMessage.setEditable(false);
        AbstractBorder border = new BevelBorder(1);
        border = new CompoundBorder(border, new EmptyBorder(2, 5, 2, 2));
        this.sysMessage.setBorder(border);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setOrientation(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(99);
        this.progressBar.setValue(0);
        JPanel statusBar = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        statusBar.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        statusBar.add((Component)this.sysMessage, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        statusBar.add((Component)this.progressBar, constraints);
        return statusBar;
    }

    public JTree getTreeView() {
        return this.landsTreeView.getTreeView();
    }

    public TabBrowser getTabBrowser() {
        return this.tabBrowser;
    }

    public LandsTree getLandsTree() {
        return this.landsTreeView;
    }

    public void setBusy(boolean busy) {
        this.progressBar.setIndeterminate(busy);
    }

    public void updateSysMessage(String message) {
        if (message == null) {
            return;
        }
        if (message.length() <= 0) {
            message = " ";
        }
        this.sysMessage.setText(message);
        GUIUtils.dispatchEmptyAWTEvent();
    }

    public void showInitPanel() {
        this.cardLayout.show(this.cards, INITCARD);
    }

    public void showVillageInfo(Village village) {
        this.tabBrowser.setVillage(village);
        this.cardLayout.show(this.cards, BROWSECARD);
        this.tabBrowser.repaint();
        this.tabBrowser.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLandInfo(Land land) {
        String status;
        String endStr;
        String startStr;
        this.landInfo.removeAll();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.landInfo.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u56fd\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLandName()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u8b58\u5225\u540d : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLandIdentifier()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u30d9\u30fc\u30b9URL : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        JTextField baseURL = new JTextField(land.getServerAccess().getBaseURL().toString());
        baseURL.setEditable(false);
        baseURL.setBorder(new EmptyBorder(0, 0, 0, 0));
        baseURL.setMargin(new Insets(0, 3, 0, 3));
        baseURL.setComponentPopupMenu(new TextPopup());
        this.landInfo.add((Component)baseURL, constraints);
        Date start = land.getStartDate();
        Date end = land.getEndDate();
        DateFormat dateFormat = dform;
        synchronized (dateFormat) {
            startStr = start.equals(Land.DATE_UNKNOWN) ? "(\u4e0d\u660e)" : dform.format(start);
            endStr = end.equals(Land.DATE_UNKNOWN) ? "\u307e\u3060\u307e\u3060" : dform.format(end);
        }
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u5efa\u56fd : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(startStr), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u4ea1\u56fd : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(endStr), constraints);
        switch (land.getType()) {
            case CLOSED: {
                status = "\u30b5\u30fc\u30d3\u30b9\u7d42\u4e86";
                break;
            }
            case HISTORICAL: {
                status = "\u904e\u53bb\u30ed\u30b0\u63d0\u4f9b\u306e\u307f";
                break;
            }
            case ACTIVE: {
                status = "\u7a3c\u52d5\u4e2d";
                break;
            }
            default: {
                assert (false);
                status = "";
            }
        }
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u72b6\u614b : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(status), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u30ed\u30b1\u30fc\u30eb : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getLocale().toString()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u6642\u9593\u5e2f : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getTimeZone().getDisplayName()), constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u9023\u7d61\u5148 : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        JTextField contact = new JTextField(land.getContactInfo());
        contact.setEditable(false);
        contact.setBorder(new EmptyBorder(0, 0, 0, 0));
        contact.setMargin(new Insets(0, 3, 0, 3));
        contact.setComponentPopupMenu(new TextPopup());
        this.landInfo.add((Component)contact, constraints);
        constraints.anchor = 13;
        constraints.gridwidth = 1;
        this.landInfo.add((Component)new JLabel("\u8aac\u660e : "), constraints);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        this.landInfo.add((Component)new JLabel(land.getDescription()), constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        this.landInfo.add((Component)new JPanel(), constraints);
        this.cardLayout.show(this.cards, LANDCARD);
        this.landInfo.repaint();
        this.landInfo.revalidate();
    }
}

