/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.FontChooser;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PeriodView;
import jp.sourceforge.jindolf.Village;
import jp.sourceforge.jindolf.VillageInfoPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabBrowser
extends JTabbedPane {
    private Village village;
    private final VillageInfoPanel villageInfo = new VillageInfoPanel();
    private Font discussionFont = FontChooser.defaultFont;
    private FontRenderContext discussionRenderContext = FontChooser.defaultRenderContext;
    private final EventListenerList thisListenerList = new EventListenerList();

    public TabBrowser() {
        this.setTabPlacement(1);
        this.setTabLayoutPolicy(0);
        this.villageInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.addTab("\u6751\u60c5\u5831", new JScrollPane(this.villageInfo));
        this.setVillage(null);
    }

    private void updateVillageInfo() {
        Village target = this.getVillage();
        this.villageInfo.updateVillage(target);
    }

    public void selectVillageInfoTab() {
        this.setSelectedIndex(0);
    }

    public Village getVillage() {
        return this.village;
    }

    public void setVillage(Village village) {
        if (village == null) {
            this.village = null;
            this.selectVillageInfoTab();
            this.modifyTabCount(0);
            this.updateVillageInfo();
            return;
        }
        if (village != this.village) {
            this.selectVillageInfoTab();
        }
        this.village = village;
        this.updateVillageInfo();
        int periodNum = this.village.getPeriodSize();
        this.modifyTabCount(periodNum);
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            Period period = this.village.getPeriod(periodDays);
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            PeriodView periodView = this.getPeriodView(tabIndex);
            if (periodView == null) {
                periodView = new PeriodView(period);
                periodView.setFontInfo(this.discussionFont, this.discussionRenderContext);
                this.setComponentAt(tabIndex, periodView);
                Discussion discussion = periodView.getDiscussion();
                for (ActionListener actionListener : this.getActionListeners()) {
                    discussion.addActionListener(actionListener);
                }
                for (EventListener eventListener : this.getAnchorHitListeners()) {
                    discussion.addAnchorHitListener((AnchorHitListener)eventListener);
                }
            }
            String caption = period.getCaption();
            this.setTitleAt(tabIndex, caption);
            if (period == periodView.getPeriod()) continue;
            periodView.setPeriod(period);
        }
    }

    private void modifyTabCount(int periods) {
        int maxTabIndex;
        int maxPeriodDays = periods - 1;
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) < maxPeriodDays) {
            String title = "";
            JPanel component = new JPanel();
            this.addTab(title, component);
        }
        while (this.tabIndexToPeriodDays(maxTabIndex = this.getTabCount() - 1) > maxPeriodDays) {
            this.remove(maxTabIndex);
        }
    }

    public int periodDaysToTabIndex(int days) {
        int tabIndex = days + 1;
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        return tabIndex;
    }

    private int tabIndexToPeriodDays(int tabIndex) {
        if (tabIndex >= this.getTabCount()) {
            return -1;
        }
        int days = tabIndex - 1;
        return days;
    }

    public List<PeriodView> getPeriodViewList() {
        LinkedList<PeriodView> result = new LinkedList<PeriodView>();
        int tabCount = this.getTabCount();
        for (int tabIndex = 0; tabIndex <= tabCount - 1; ++tabIndex) {
            Component component = this.getComponent(tabIndex);
            if (component == null || !(component instanceof PeriodView)) continue;
            PeriodView periodView = (PeriodView)component;
            result.add(periodView);
        }
        return result;
    }

    public Discussion currentDiscussion() {
        int tabIndex = this.getSelectedIndex();
        Discussion result = this.getDiscussion(tabIndex);
        return result;
    }

    public PeriodView currentPeriodView() {
        int tabIndex = this.getSelectedIndex();
        PeriodView result = this.getPeriodView(tabIndex);
        return result;
    }

    public PeriodView getPeriodView(int tabIndex) {
        if (this.tabIndexToPeriodDays(tabIndex) < 0) {
            return null;
        }
        if (tabIndex >= this.getTabCount()) {
            return null;
        }
        Component component = this.getComponentAt(tabIndex);
        if (component == null) {
            return null;
        }
        if (!(component instanceof PeriodView)) {
            return null;
        }
        PeriodView periodView = (PeriodView)component;
        return periodView;
    }

    private Discussion getDiscussion(int tabIndex) {
        PeriodView periodView = this.getPeriodView(tabIndex);
        if (periodView == null) {
            return null;
        }
        Discussion result = periodView.getDiscussion();
        return result;
    }

    public void setFontInfo(Font font, FontRenderContext context) {
        this.discussionFont = font;
        this.discussionRenderContext = context;
        for (int tabIndex = 0; tabIndex <= this.getTabCount() - 1; ++tabIndex) {
            PeriodView periodView = this.getPeriodView(tabIndex);
            if (periodView == null) continue;
            periodView.setFontInfo(this.discussionFont, this.discussionRenderContext);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.thisListenerList.add(ActionListener.class, listener);
        if (this.village == null) {
            return;
        }
        int periodNum = this.village.getPeriodSize();
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            Discussion discussion = this.getDiscussion(tabIndex);
            if (discussion == null) continue;
            discussion.addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.thisListenerList.remove(ActionListener.class, listener);
        if (this.village == null) {
            return;
        }
        int periodNum = this.village.getPeriodSize();
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            Discussion discussion = this.getDiscussion(tabIndex);
            if (discussion == null) continue;
            discussion.removeActionListener(listener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.thisListenerList.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.add(AnchorHitListener.class, listener);
        if (this.village == null) {
            return;
        }
        int periodNum = this.village.getPeriodSize();
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            Discussion discussion = this.getDiscussion(tabIndex);
            if (discussion == null) continue;
            discussion.addAnchorHitListener(listener);
        }
    }

    public void removeAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.remove(AnchorHitListener.class, listener);
        if (this.village == null) {
            return;
        }
        int periodNum = this.village.getPeriodSize();
        for (int periodDays = 0; periodDays < periodNum; ++periodDays) {
            int tabIndex = this.periodDaysToTabIndex(periodDays);
            Discussion discussion = this.getDiscussion(tabIndex);
            if (discussion == null) continue;
            discussion.removeAnchorHitListener(listener);
        }
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.thisListenerList.getListeners(AnchorHitListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.thisListenerList.getListeners(listenerType);
        if (result.length <= 0) {
            result = super.getListeners(listenerType);
        }
        return result;
    }
}

