/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;

public class CountInputStream
extends InputStream {
    private final InputStream in;
    private long counter;

    public CountInputStream(InputStream in) {
        this.in = in;
        this.counter = 0L;
    }

    public long getCount() {
        return this.counter;
    }

    public int available() throws IOException {
        int bytes = this.in.available();
        return bytes;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        int byteData = this.in.read();
        ++this.counter;
        return byteData;
    }

    public int read(byte[] buf) throws IOException {
        int count = this.in.read(buf);
        this.counter += (long)count;
        return count;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int count = this.in.read(buf, off, len);
        this.counter += (long)count;
        return count;
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.counter += skipped;
        return skipped;
    }
}

