/*
 *	player.js - MP3Player.swf 用 簡易操作スクリプト
 *
 *		著作者:
 *			HIROTAKA.YAMASHITA. 2008. - sousyu.yama@gmail.com 
 *
 *		ライセンス:
 *			The MIT License¶
 *
 *			Copyright (c) 2008 HIROTAKA YAMASHITA.
 *
 *			以下に定める条件に従い、本ソフトウェアおよび関連文書のファイル（以下「ソフトウェア」）の
 *			複製を取得するすべての人に対し、ソフトウェアを無制限に扱うことを無償で許可します。これには、
 *			ソフトウェアの複製を使用、複写、変更、結合、掲載、頒布、サブライセンス、および/または
 *			販売する権利、およびソフトウェアを提供する相手に同じことを許可する権利も無制限に含まれます。
 *
 *			上記の著作権表示および本許諾表示を、ソフトウェアのすべての複製または重要な部分に記載する
 *			ものとします。
 *
 *			ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、何らの保証もなく提供されます。
 *			ここでいう保証とは、商品性、特定の目的への適合性、および権利非侵害についての保証も含みますが、
 *			それに限定されるものではありません。作者または著作権者は、契約行為、不法行為、
 *			またはそれ以外であろうと、ソフトウェアに起因または関連し、あるいはソフトウェアの使用または
 *			その他の扱いによって生じる一切の請求、損害、その他の義務について何らの責任も負わないものとします。 
 *
 *			Permission is hereby granted, free of charge, to any person obtaining a copy
 *			of this software and associated documentation files (the "Software"), to deal
 *			in the Software without restriction, including without limitation the rights
 *			to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *			copies of the Software, and to permit persons to whom the Software is
 *			furnished to do so, subject to the following conditions:
 *
 *			The above copyright notice and this permission notice shall be included in
 *			all copies or substantial portions of the Software.
 *
 *			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *			IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *			FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *			AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *			LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *			OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *			THE SOFTWARE.
 *
 *		Flash バージョンは 9 以上が必要
 *
 *		以下のブラウザを推奨するスクリプト
 *			Windows:	Internet Explorer 7 以上
 *			Windows:	Firefox 2 以上
 *			Windows:	Safari 3 以上
 *			Windows:	Opera 9 以上
 *			Mac:		Firefox 2 以上
 *			Mac:		Safari 2 以上
 *			Mac:		Opera 9 以上
 *
 *  本スクリプトは、MP3Player.swf の使用を前提としたスクリプトです。
 *
 */
if(typeof shadeflash=="undefined"){
	var shadeflash=new Object();
}
////////////////////////////////////////////////////////////////////////////////////////////
shadeflash.Flash = function() {
	this.autostart = undefined;
	this.volume = undefined;
	this.loop = undefined;
	this.title = undefined;
	this.bgcolor = undefined;
	this.color = undefined;
	this.textbgcolor = undefined;
	this.textcolor = undefined;
	this.loadbarcolor = undefined;
	this.playbarcolor = undefined;
//	this.selectedcolor = undefined;
	this.rollovercolor = undefined;
};
////////////////////////////////////////////////////////////////////////////////////////////
shadeflash.Flash.prototype = {
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flashプレイヤー flashvarsパラメータ設定
//
//		引数:	file	:再生ファイルのURL
//				width	:プレイヤー横幅
//				height	:プレイヤー高さ
//				var		:その他の任意項目
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setFlashPlayer: function (file, width, height) {

		var str = 'width=' + width + '&height=' + height;
		str += '&file=' + file;

		str += '&backcolor=' + this.backcolor;
		str += '&frontcolor=' + this.frontcolor;
		str += '&lightcolor=' + this.lightcolor;
		str += '&screencolor=' + this.screencolor;

		str += '&autostart=' + this.autostart;
		str += '&repeat=' + this.repeat;
		str += '&showeq=' + this.showeq;
		str += '&volume=' + this.volume;

		str += '&shownavigation=' + this.shownavigation;
		str += '&showstop=' + this.showstop;
		str += '&showdigits=' + this.showdigits;
		str += '&usefullscreen=' + this.usefullscreen;

		if (this.playList) {
			str += '&autoscroll=' + this.autoscroll;
			if (this.displayheight != 0) {
				str += '&displayheight=' + this.displayheight;
			}
			if (this.displaywidth != 0) {
				str += '&displaywidth=' + this.displaywidth;
			}
		}

		return str;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	autostartプロパティ設定 (flashvars用)
//
//		引数:	true	:autostartする
//				false	:autostartしない
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setAutoStart: function (flag) {
		if (flag) {
			this.autostart = "true";
		} else {
			this.autostart = "false";
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	volumeプロパティ設定 (flashvars用)
//
//		引数:	音量		:0 - 100
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setVolume: function (vol) {
		if (vol < 0 || vol > 100) {
			return;
		}
		this.volume = vol;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	loopプロパティ設定 (flashvars用)
//
//		引数:	true	:loopする
//				false	:loopしない
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setLoop: function (flag) {
		if (flag) {
			this.loop = "true";
		} else {
			this.loop = "false";
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	titleプロパティ設定 (flashvars用)
//
//		引数:	str		:パネル表示文字列
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setTitle: function (str) {
		this.title = str;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	bgcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:背景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setBgColor: function (cl) {
		this.bgcolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	colorプロパティ設定 (flashvars用)
//
//		引数:	cl		:前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setColor: function (cl) {
		this.color = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	textbgcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:パネル背景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setTextBgColor: function (cl) {
		this.textbgcolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	textcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:パネル前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setTextColor: function (cl) {
		this.textcolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	loadbarcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:ロードバー色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setLoadBarColor: function (cl) {
		this.loadbarcolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	playbarcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:プレイプログレスバー色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setPlayBarColor: function (cl) {
		this.playbarcolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	selectedcolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:選択時前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
/*
	setSelectedColor: function (cl) {
		this.selectedcolor = cl;
	},
*/
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	rollovercolorプロパティ設定 (flashvars用)
//
//		引数:	cl		:選択前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setRollOverColor: function (cl) {
		this.rollovercolor = cl;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	操作系プロパティ設定 (flashvars用)
//
//		引数:	as		:true;autostartする, false;autostartしない
//				vol		:音量;0 - 100
//				lp		:true;loopする, false;loopしない
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setOperation: function (as, vol, lp) {
		if (typeof as != "undefined") {
			this.setAutoStart(as);
		}

		if (typeof vol != "undefined") {
			this.setVolume(vol);
		}

		if (typeof lp != "undefined") {
			this.setLoop(lp);
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	操作系カラー設定 (flashvars用)
//
//		引数:	削除-----------------------------------------------cl1:選択時前景色(0xrrggbb)
//				cl2		:選択前景色(0xrrggbb)
//				cl3		:ロードバー色(0xrrggbb)
//				cl4		:プレイプログレスバー色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setOperationColor: function (cl2, cl3, cl4) {
//	setOperationColor: function (cl1, cl2, cl3, cl4) {
/*
		if (typeof cl1 != "undefined") {
			this.setSelectedColor(cl1);
		}
*/
		if (typeof cl2 != "undefined") {
			this.setRollOverColor(cl2);
		}

		if (typeof cl3 != "undefined") {
			this.setLoadBarColor(cl3);
		}

		if (typeof cl4 != "undefined") {
			this.setPlayBarColor(cl4);
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	パネル系プロパティ設定 (flashvars用)
//
//		引数:	str		:パネル表示文字列
//				bc		:パネル背景色(0xrrggbb)
//				fc		:パネル前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setPanel: function (str, bc, fc) {
		if (typeof str != "undefined") {
			this.setTitle (str);
		}

		if (typeof bc != "undefined") {
			this.setTextBgColor (bc);
		}

		if (typeof fc != "undefined") {
			this.setTextColor (fc);
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	プレイヤー色設定 (flashvars用)
//
//		引数:	bc		:背景色(0xrrggbb)
//				fc		:前景色(0xrrggbb)
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setPlayerColor: function (bc, fc) {
		if (typeof bc != "undefined") {
			this.setBgColor(bc);
		}

		if (typeof fc != "undefined") {
			this.setColor(fc);
		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	flashvars設定
//
//		引数:	file	:MP3ファイル名
//		戻り値:	flashvars文字列
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	setFlashvars: function (file) {
		var str = '"file=' + file;

		if (typeof this.autostart != "undefined") {
			str += '&autostart=' + this.autostart;
		}
		if (typeof this.volume != "undefined") {
			str += '&volume=' + this.volume;
		}
		if (typeof this.loop != "undefined") {
			str += '&loop=' + this.loop;
		}
		if (typeof this.title != "undefined") {
			str += '&title=' + this.title;
		}
		if (typeof this.bgcolor != "undefined") {
			str += '&bgcolor=' + this.bgcolor;
		}
		if (typeof this.color != "undefined") {
			str += '&color=' + this.color;
		}
		if (typeof this.textbgcolor != "undefined") {
			str += '&textbgcolor=' + this.textbgcolor;
		}
		if (typeof this.textcolor != "undefined") {
			str += '&textcolor=' + this.textcolor;
		}
		if (typeof this.loadbarcolor != "undefined") {
			str += '&loadbarcolor=' + this.loadbarcolor;
		}
		if (typeof this.playbarcolor != "undefined") {
			str += '&playbarcolor=' + this.playbarcolor;
		}
/*
		if (typeof this.selectedcolor != "undefined") {
			str += '&selectedcolor=' + this.selectedcolor;
		}
*/
		if (typeof this.rollovercolor != "undefined") {
			str += '&rollovercolor=' + this.rollovercolor;
		}
		str += '"';

		return str;
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flashプレイヤー (MP3Player.swf用)
//
//		Flash プラグインが未インストールの場合は、何もしない
//
//		引数:	file	:再生ファイルのURL
//				width	:プレイヤー横幅
//				height	:プレイヤー高さ
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MP3Player: function (playerPath, mp3File, width, height) {
		if (!Browser.isFlashPlugin(0)) {
			return;
		}

		if (typeof width == "undefined") {
			width = "320";
		} else if (width < 320) {
			width = "320";
		}

		if (typeof height == "undefined") {
			height = "80";
		} else if (height < 60 || height > 80) {
			height = "80";
		}

		var flashvars = this.setFlashvars(mp3File);
		var embedString = '<embed src="' + playerPath + 'MP3Player_L.swf"';
		embedString += ' type="application/x-shockwave-flash"';
		embedString += ' height="' + height + '" width="' + width + '"';
		embedString += ' flashvars=';
		embedString += flashvars;
		embedString += ' />';

		if (Browser.isOther()) {
			document.write (embedString);
		} else if (Browser.isIE()) {
			// IE用出力
			document.write ('<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="movie" value="' + playerPath + 'MP3Player_L.swf" />');
			document.write ('<param name="flashvars" value=' + flashvars + ' />');
			document.write (embedString);
			document.write ('</object>');
		} else {
			// IE以外のブラウザ用出力
			document.write ('<object data="' + playerPath + 'MP3Player_L.swf"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="flashvars" value=' + flashvars + ' />');
			document.write (embedString);
			document.write ('</object>');

		}
	},

//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
//	Flashプレイヤー (FLVPlayer.swf用)
//
//		Flash プラグインが未インストールの場合は、何もしない
//
//		引数:	file	:再生ファイルのURL
//				width	:プレイヤー横幅
//				height	:プレイヤー高さ
//		戻り値:	なし
//;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	FLVPlayer: function (playerPath, mp3File, width, height) {
		if (!Browser.isFlashPlugin(0)) {
			return;
		}

		if (typeof width == "undefined") {
			width = "320";
		} else if (width < 320) {
			width = "320";
		}
		if (typeof height == "undefined") {
			height = "320";
		} else if (height < 240) {
			height = "240";
		}

		var flashvars = this.setFlashvars(mp3File);
		var embedString = '<embed src="' + playerPath + 'FLVPlayer.swf"';
		embedString += ' type="application/x-shockwave-flash"';
		embedString += ' height="' + height + '" width="' + width + '"';
		embedString += ' flashvars=';
		embedString += flashvars;
		embedString += ' />';

		if (Browser.isOther()) {
			document.write (embedString);
		} else if (Browser.isIE()) {
			// IE用出力
			document.write ('<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="movie" value="' + playerPath + 'FLVPlayer.swf" />');
			document.write ('<param name="flashvars" value=' + flashvars + ' />');
			document.write (embedString);
			document.write ('</object>');
		} else {
			// IE以外のブラウザ用出力
			document.write ('<object data="' + playerPath + 'FLVPlayer.swf"');
			document.write (' type="application/x-shockwave-flash"');
			document.write (' height="' + height + '" width="' + width + '">');
			document.write ('<param name="flashvars" value=' + flashvars + ' />');
			document.write (embedString);
			document.write ('</object>');

		}
	}
};
////////////////////////////////////////////////////////////////////////////////////////////
if(typeof Flash=="undefined"){
	var Flash = new shadeflash.Flash();
}
Browser.checkBrowser(0);
