package nl.eid.jetspeed.portal.controls;

import org.apache.ecs.html.*;
import org.apache.ecs.*;

//jetspeed support
import org.apache.jetspeed.util.*;
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.capability.*;

//turbine
import org.apache.turbine.util.*;

//java imports
import java.util.*;

/**
 * Insert the type's description here.
 *
 * This portlet controller generates CSS entries based on a style name.
 * The style name is supplied as an init parameter through the portlet
 * config. You can add the following style entries to your CSS:
 *
 * TABLE.<YourPortletStyle>
 * TD.<YourPortletStyle>+Title
 * TD.<YourPortletStyle>+Option
 * TD.<YourPortletStyle>+Content
 *
 * Creation date: (07-Mar-01 23:58:45)
 * @author: Administrator
 */
public class CssPortletControl extends PortletControl{
	public final static String STYLE = "style";
/**
 * CssPortletControl constructor comment.
 */
public CssPortletControl() {
	super();
}
public ConcreteElement getContent(RunData rundata) {
	String aStyle = this.getConfig().getInitParameter( "style", "Default" );
	ElementContainer base = new ElementContainer();
	if (CapabilityMapFactory.getCapabilityMap(rundata).getPreferredType().equals(MimeType.HTML)) {
		Table aHolder = new Table().setCellPadding(0).setCellSpacing(0).setWidth(getWidth()).setAlign("center");
		aHolder.setClass(aStyle);
		ConcreteElement[] options = this.getPortletOptions(rundata);
		TR finalTitle = new TR();
		TD actualTitle = new TD().setNoWrap(true).setWidth("100%").setVAlign("middle").addElement(getPortlet().getTitle());
		actualTitle.setClass(aStyle + "Title");
		finalTitle.addElement(actualTitle);
		if (options.length > 0) {
			ElementContainer alloptions = new ElementContainer();
			for (int i = 0; i < options.length; ++i) {
				alloptions.addElement(options[i]);
			}
			TD optionHolder = new TD().setNoWrap(true).setAlign("right").setVAlign("middle").addElement(alloptions);
			optionHolder.setClass(aStyle + "Option");
			finalTitle.addElement(optionHolder);
		}
		aHolder.addElement(finalTitle);
		TR background = new TR();
		TD content = new TD().setWidth("100%").setVAlign("top").setColSpan(options.length + 1).addElement(this.getPortlet().getContent(rundata));
		content.setClass(aStyle + "Content");
		background.addElement(content);
		background.addElement(new TD().addElement(new BR()));
		aHolder.addElement(background);
		base.addElement(aHolder);
	} else {
		base.addElement(getPortlet().getContent(rundata));
	}
	rundata.getSession().setAttribute(STYLE, aStyle);
	return base;
}
/**
Get the options for this portlet.
*/
private ConcreteElement[] getPortletOptions(RunData rundata) {

	Vector v = new Vector();

	if (this.getPortlet().getAllowEdit(rundata)) {

		try {
			A info =
				new A(
					URILookup.getURI(
						URILookup.TYPE_INFO,
						URILookup.SUBTYPE_MARK,
						this.getPortlet(),
						rundata)).addElement(
					new IMG(Util.getContentURI(rundata, JetspeedResources.INFO_IMAGE)).setBorder(
						0));
			v.addElement(info);
		} catch (JetspeedException e) {
			Log.note(e.getMessage());
		}

	}

	if (this.getPortlet().getAllowMaximize(rundata)) {

		try {
			A max =
				new A(
					URILookup.getURI(
						URILookup.TYPE_HOME,
						URILookup.SUBTYPE_MAXIMIZE,
						this.getPortlet(),
						rundata)).addElement(
					new IMG(Util.getContentURI(rundata, JetspeedResources.MAX_IMAGE)).setBorder(0));
			v.addElement(max);
		} catch (JetspeedException e) {
			Log.note(e.getMessage());
		}

	}

	ConcreteElement[] elements = new ConcreteElement[v.size()];
	v.copyInto(elements);
	return elements;

}
}
