/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.security;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.security.JetspeedUser;

/**
 * Unit test for PortalAuthentication interface
 * 
 * @author <a href="mailto:david@bluesunrise.com">David Sean Taylor</a>
 * @version $Id: TestPortalAuthentication.java,v 1.1 2004/04/07 22:02:43 jford Exp $
 */

public class TestPortalAuthentication extends JetspeedTestCase {    

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestPortalAuthentication( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) 
    {
        junit.awtui.TestRunner.main( new String[] { TestPortalAuthentication.class.getName() } );
    }
 
    public void setup() 
    {
        System.out.println("Setup: Testing Turbine Authentication");
    }

    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() 
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestPortalAuthentication.class );
    }


    /**
     * Tests PortalAuthentication.login()
     *
     * @throws Exception
     */

    public void testLogin() throws Exception 
    {
        setup();

        PortalAuthentication service = getService();
        JetspeedUser user = null;

        try
        {
            user = service.login("baduser", "badpassword");
        }
        catch (Exception e)
        {
            System.out.println("exception = " + e.toString());
            assertTrue(e instanceof FailedLoginException);
        }
        try
        {
            user = service.login("turbine", "badpassword");
        }
        catch (Exception e)
        {
            System.out.println("e = " + e);
            assertTrue(e instanceof FailedLoginException);
        }
        try
        {
            user = service.login("turbine", "turbine");
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }

        assertTrue(user.hasLoggedIn() == true);

        System.out.println("Completed Login Test OK ");

    }

    /**
     * Tests PortalAuthentication.login()
     *
     * @throws Exception
     */

    public void testGetAnonymousUser()
    {
        setup();

        PortalAuthentication service = getService();
        JetspeedUser user = null;

        try
        {
            user = service.getAnonymousUser();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }

        assertTrue(user.hasLoggedIn() == false);

        System.out.println("Completed Anonymous Test OK");

    }


  /*
    Configuration object to run Turbine outside a servlet container
    ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /**
    Sets up TurbineConfig using the system property:
    <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
            config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
            config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

    private static PortalAuthentication getService()
    {
        return (PortalAuthentication)TurbineServices
                .getInstance()
                .getService(PortalAuthentication.SERVICE_NAME);
    }

}



