/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.capability;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.ClientRegistry;
import org.apache.jetspeed.om.registry.ClientEntry;
import org.apache.jetspeed.util.MimeType;

/**
 * Unit test for capbility package
 *
 * @author <a href="raphael@apache.org">Raphal Luta</a>
 * @version $Id: TestCapabilityMap.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestCapabilityMap extends JetspeedTestCase
{
    
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestCapabilityMap( String name )
    {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main( new String[] { TestCapabilityMap.class.getName() } );
    }

    public void setup()
    {
        System.out.println("Setup: Testing CapabilityMap functionality");
    }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestCapabilityMap.class );
    }

    public void testRegistry() throws Exception
    {
        try
        {
            // Make sure the Registry works
            ClientRegistry cr = (ClientRegistry)Registry.get(Registry.CLIENT);
            ClientEntry ce = (ClientEntry)cr.getEntry("ie5");
            assertNotNull(ce);
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testDefaultMap() throws Exception
    {
        try
        {
            // first test default capailitymap
            CapabilityMap cm = CapabilityMapFactory.getDefaultCapabilityMap();
            assertNotNull(cm);
            assertTrue(cm.toString().startsWith("ns4"));
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testStandardMap() throws Exception
    {
        try
        {
            // then test different standard browsers
            getUserAgent("ie5","Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
            getUserAgent("ns4","Mozilla/4.78 (Windows 2000; U) Opera 6.01  [fr]");
            getUserAgent("mozilla","Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.0rc1) Gecko/20020417");
            getUserAgent("nokia_generic","Nokia3330/1.0 (03.05)");
            getUserAgent("lynx","Lynx/2.8.4rel.1 libwww-FM/2.14 SSL-MM/1.4.1 OpenSSL/0.9.6b");
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    public void testCapabilityCheck() throws Exception
    {
        try
        {
            // test simple capabilities
            CapabilityMap cm = CapabilityMapFactory.getCapabilityMap("Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.0rc1) Gecko/20020417");
            assertTrue(cm.hasCapability("HTML_DOM_1"));
            assertTrue(cm.hasCapability("HTML_IFRAME"));
            assertTrue(cm.supportsMimeType(MimeType.XML));
            assertTrue(cm.supportsMediaType("html"));
        }
        catch (Exception e)
        {
            String errmsg = "Error in test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    private void getUserAgent(String name, String ua)
    {
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(ua);
        assertNotNull(cm);
        assertNotNull(name);
        assertTrue(cm.toString().startsWith(name));
    }

    /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;

    /*
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }
}
