package org.apache.jetspeed.modules.actions.portlets;

// Turbine stuff
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.factory.PortletFactory;
import org.apache.jetspeed.services.registrymanager.RegistryManager;
import org.apache.jetspeed.om.registry.peer.PortletEntry;


/**
Remove a portlet from user configuration

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public class ClosePortlet extends Action
{
    public void doPerform( RunData rundata ) throws Exception
    {

        if( rundata.getUser() == null || !rundata.getUser().hasLoggedIn() )
        {
            return;
        }

        String name = rundata.getParameters().getString ( "portletName", null );
        if ( name == null )
        {
            return;
        }

        PortletEntry entry = (PortletEntry)RegistryManager.getEntry(RegistryManager.PORTLET_REGISTRY, name );
        if ( entry == null )
        {
            return;
        }

        Portlet portlet = PortletFactory.getPortlet( entry );
        if ( portlet == null )
        {
            return;
        }

        // ToDo: remove the portlet 
    }

}
