/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

/**
 ** The <CODE>PortletLog</CODE> provides the portlet with the ability
 ** to log information, warning, or error texts. The log is
 ** maintained by the portlet container. The type and location of
 ** of the log is a matter of implementation. Also, whether logging
 ** is enabled or not is at the discretion of the portlet container.
 **
 ** <PRE>
 ** ...
 **
 ** PortletLog log = iContext.getLog ();
 **
 ** if (log.isWarnEnabled())
 **     log.warn ("Can access the content source");
 **
 ** ...
 ** </PRE>
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public interface PortletLog
{

    /**
     ** Returns whether the debug level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isDebugEnabled ();

    /**
     ** Logs the given informational text in the portlet log.
     **
     ** @param   aText
     **          the informational text to log
     **/

    public void debug (String text);

    /**
     ** Returns whether the info level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isInfoEnabled ();

    /**
     ** Logs the given informational text in the portlet log.
     **
     ** @param   aText
     **          the informational text to log
     **/

    public void info (String text);

    /**
     ** Returns whether the warn level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isWarnEnabled ();

    /**
     ** Logs the given warning text in the portlet log.
     **
     ** @param   text
     **          the warning text to log
     **/

    public void warn (String text);

    /**
     ** Returns whether the error level of the portlet log is enabled.
     **
     ** @return   <CODE>true</CODE> if the log is enabled, <BR>
     **           <CODE>false</CODE>
     **/

    public boolean isErrorEnabled ();

    /**
     ** Logs the given error text in the portlet log.
     **
     ** @param   text
     **          the error text to log
     **
     ** @see   #error(String,Throwable)
     **/

    public void error (String text);

    /**
     ** Logs the given error text, cause, and a stack trace in
     ** the portlet log.
     **
     ** @param   text
     **          the error text to log
     ** @param   cause
     **          the cause for logging
     **
     ** @see   #error(String)
     **/

    public void error (String text, Throwable cause);
}
