package org.apache.jetspeed.portal.portlets;

// Turbine stuff
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.modules.ActionLoader;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.portal.PortletException;

// Ecs stuff
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

// Velocity Stuff
import org.apache.velocity.context.Context;

import org.apache.turbine.util.Log;


/**
An implementation of AbstractVTLPortlet. 

you need lines like this in jetspeed-config.jcfg:

    <portlet-registry>

        <portlet-entry type="abstract" name="VTLPortlet">
            <classname>org.apache.jetspeed.portal.portlets.VTLPortlet</classname>
         </portlet-entry>

        <portlet-entry type="ref" name="Hello" parent="VTLPortlet">
            <parameter name="vtlTemplate" value="HelloPortlet"/>
            <meta-info>
                <title>Hello</title>
                <description>Hello portlet</description>
            </meta-info>
        </portlet-entry>

    </portlet-registry>

Basically a VTLPortlet is this file, an action, and a template

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public class VTLPortlet extends AbstractVTLPortlet 
{
    public ConcreteElement getContent( RunData rundata )
    {
        // get the template name from the URL ( or from jetspeed-config.jcfg (
        String  template = rundata.getParameters().getString ( "vtlTemplate", null );
        if( template == null )
        {
            template = this.getPortletConfig().getInitParameter( "vtlTemplate" );
        }

        // make a blank context and put some data
        Context context = TurbineVelocity.getContext();
        context.put( "portlet", this );
        context.put( "vtlTemplate", template );
        rundata.getTemplateInfo().setTemplateContext( "VTLPortletContext", context );

        // if there is an action with the same name in modules/actions/portlets exec it
        // The action processes max/min/conf/restore/close buttons
        try
        {
            ActionLoader.getInstance().exec( rundata, "portlets." + template.replace(',', '.') );
        }
        catch( Exception e)
        {
           //Log.error( e.toString() );
        }
 
        // don't make content if portlet is minimized
        String s = "";
        if( isButtonMaximize( rundata ) || isButtonConfigure( rundata ) || !isMinimized( rundata ) )
        {
            // may be the action changed the template
            template = ( (String)context.get( "vtlTemplate" ) ).replace(',', '/');

            // generate the content
            try
            {
                s = TurbineVelocity.handleRequest(context, "portlets/" + template + ".vm");
            }
            catch( Exception e)
            {
                s= e.toString();
            }
        }

        return new StringElement( s );
    }


}

