/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.transformer;

//standard java stuff
import java.io.Reader;

// turbine stuff
import org.apache.turbine.services.Service;

/**
 * This service is responsible for locate and transform HTML content
 * 
 * @author <a href="mailto:mmari@ce.unipr.it">Marco Mari</a>
 * @version $Id: TransformerService.java,v 1.1 2003/09/05 16:41:17 morciuch Exp $ 
 */
public interface TransformerService extends Service
{

	/** The name of this service */
	public String SERVICE_NAME = "Transformer";

	/**
	 * Finds an element in a web page
	 * 
	 * @param htmlReader Reader for the html rewriter
	 * @param url        page address
	 * @param element    the element to search
	 */
	public String findElement(Reader htmlReader, String url, String element);

	/**
	 * Clips the part of a web page between startElement and stopElement
	 * 
	 * @param htmlReader    Reader for the html rewriter
	 * @param url           page address
	 * @param startElement  the first element to clip
	 * @param stopElement   the last element to clip
	 */
	public String clipElements(
		Reader htmlReader,
		String url,
		String startElement,
		String stopElement);

	/**
	 * Finds in an HTML page the "tagNumber" tag of type "element"
	 * Example: element = "p", tagNumber = "3"
	 * Page content:
	 * <p>..</p>
	 * <p>..</p>
	 * <p>..   <---Finds this    
	 * 
	 * @param htmlReader Reader for the html rewriter
	 * @param url        page address
	 * @param element    the element to search
	 * @param tagNumber  the number of the element to search
	 */
	public String findElementNumber(
		Reader htmlReader,
		String url,
		String element,
		int tagNumber);

	/**
	 * Clips a part of a web page, starting from the "tagNumber" "startElement"
	 * Example: startElement = "p", tagNumber = "3", stopElement = "img"
	 * Page content:
	 * <p>..</p>
	 * <p>..</p>
	 * <p>..   <---Starts here
	 * ........<img>  <---Stops here
	 * 
	 * @param htmlReader    Reader for the html rewriter
	 * @param url           page address
	 * @param startElement  the first element to clip
	 * @param stopElement   the last element to clip
	 * @param tagNumber     the number of the first element to clip
	 */
	public String clipElementsNumber(
		Reader htmlReader,
		String url,
		String startElement,
		String stopElement,
		int tagNumber);
}
