/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.search.handlers;

// Java APIs
import java.util.HashMap;
import java.util.Iterator;

// Jetspeed APIs
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.search.ParsedObject;
import org.apache.jetspeed.om.registry.Category;

/**
 * This object handler deals with portlet registry entries
 * 
 * @author <a href="mailto:caius1440@hotmail.com">Jeremy Ford</a>
 * @version $Id: PortletEntryToDocHandler.java,v 1.3 2003/08/05 19:08:35 jford Exp $
 */
public class PortletEntryToDocHandler extends RegistryEntryToDocHandler
{
    /**
     * Static initialization of the logger for this class
     */    
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletEntryToDocHandler.class.getName());
    
    /**
     * Parses portlet entry object
     * 
     * @param o
     * @return 
     */
    public ParsedObject parseObject(Object o)
    {
        ParsedObject result = super.parseObject(o);
        
        if ((o instanceof PortletEntry) == false)
        {
            logger.error("PortletEntryToDocHandler: invalid object type: " + o);
            return null;
        }

        PortletEntry portletEntry = (PortletEntry) o;
        
        HashMap fields = new HashMap();
        fields.put("parent", portletEntry.getParent());
        fields.put("type", portletEntry.getType());
        
        result.setFields(fields);

        StringBuffer content = new StringBuffer();
        String title = portletEntry.getTitle();
        content.append(title == null ? portletEntry.getName() : title);
        content.append(" ");
        content.append(portletEntry.getDescription());
        content.append(" ");
        Iterator it = portletEntry.listCategories();
        while (it.hasNext())
        {
            Category cat = (Category) it.next();
            content.append(cat.getName());
            content.append(" ");
        }

        result.setContent(content.toString());

        result.setType(ParsedObject.OBJECT_TYPE_PORTLET);

        // TODO: index the url for portlets defining one. A good candidate would be HTML, Webpage
        // and IFrame portlets.
        
        return result;
    }
}
