/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.psmlmanager;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;


import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.BaseProfile;

import org.apache.torque.util.Criteria;

/**
 * TestDbCriteria
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestDbCriteria.java,v 1.3 2003/08/08 18:28:03 morciuch Exp $
 */

public class TestDbCriteria extends JetspeedTestCase {    


    /** the column name for the PSML_ID field */
    public static final String PSML_ID;
    /** the column name for the USER_NAME field */
    public static final String USER_NAME;
    /** the column name for the MEDIA_TYPE field */
    public static final String MEDIA_TYPE;
    /** the column name for the LANGUAGE field */
    public static final String LANGUAGE;
    /** the column name for the COUNTRY field */
    public static final String COUNTRY;
    /** the column name for the PAGE field */
    public static final String PAGE;
    /** the column name for the PROFILE field */
    public static final String PROFILE;

    static
    {
    PSML_ID = "JETSPEED_USER_PROFILE.PSML_ID";
    USER_NAME = "JETSPEED_USER_PROFILE.USER_NAME";
    MEDIA_TYPE = "JETSPEED_USER_PROFILE.MEDIA_TYPE";
    LANGUAGE = "JETSPEED_USER_PROFILE.LANGUAGE";
    COUNTRY = "JETSPEED_USER_PROFILE.COUNTRY";
    PAGE = "JETSPEED_USER_PROFILE.PAGE";
    PROFILE = "JETSPEED_USER_PROFILE.PROFILE";
    }

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestDbCriteria( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestDbCriteria.class.getName() } );
    }
 
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestDbCriteria.class );
    }


    /**
     * Tests generating an SQL string from a profile locator
     * @throws Exception
     */

    public void testLocatorCriteria() throws Exception 
    {

        ProfileLocator locator = new BaseProfile();
        locator.setMediaType("html");
        locator.setLanguage("en");
        locator.setName("default.psml");
            
        Criteria criteria = new Criteria();

        String mediaType = locator.getMediaType();
        String language = locator.getLanguage();
        String country = locator.getCountry();
        String pageName = locator.getName();
        String userName = "anon";

        assertTrue(country == null);

        if (userName != null && userName.length() > 0)
        {
            criteria.add(USER_NAME, userName) ;
        }

        if (pageName != null && pageName.length() > 0)
        {
            criteria.add(PAGE, pageName);
        }

        if (mediaType != null && mediaType.length() > 0)
        {
            criteria.add(MEDIA_TYPE, mediaType);
        }

        if (language != null && language.length() > 0)
        {
             criteria.add(LANGUAGE, language);
        }

        criteria.add(COUNTRY, country);

        String sql = criteria.toString();
        System.out.println("criteria = [" + criteria.toString() + "]");
        assertTrue(sql.indexOf("JETSPEED_USER_PROFILE.COUNTRY IS NULL") > -1);
    }

/*
    Configuration object to run Turbine outside a servlet container
    ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /**
    Sets up TurbineConfig using the system property:
    <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
            config = new TurbineConfig( "../webapp", "/WEB-INF/conf/TurbineResources.properties");
            config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

}
