/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.persistence;

import java.util.List;

import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.turbine.services.Service;
import org.apache.turbine.util.RunData;

/**
 * Defines the interface to the Portal Persistence Service for storing and
 * retrieving portlet instances.
 *
 * @author <a href="mailto:sweaver@rippe.com">Scott Weaver</a>
 * @version $Id: PortalPersistenceService.java,v 1.2 2003/03/04 00:05:08 sgala Exp $
 */
public interface PortalPersistenceService extends Service
{
    String SERVICE_NAME = "PortalPersistenceService";

    /**
     * Store a portlet instance to permenant storage.
     *
     * @param instance The portlet instance to be stored.
     * @exception PortalPersistenceException if there were problems
     * storing the PSMLDocument to persistent storage.
     * 
     */
    void store(PortletInstance instance) throws PortalPersistenceException;

    /**
     * Retrieves a portlet instance from persistent storage for the given portlet.
     *
     * @param portlet The portlet to retrieve an instance for
     * @param data Request rundata.
     * @return PortletInstance The instance for the given portlet.
     */
    PortletInstance getInstance(Portlet portlet, RunData data);

    /**
     * Retrieves a PersistentPortlet instance for this portlet.
     *
     * @param portlet The portlet to retrieve an instance for
     * @param profile Retrieve instance from this profile.
     * @return PortletInstance The instance for the given portlet.     
     */
    PortletInstance getInstance(Portlet portlet, Profile profile);

    /**
     * Retrieves a List of portlet instances for the current profile.
     *
     * @param data Request rundata.
     * @return List The list of all instances in current profile.
     */
    List getInstances(RunData data) throws PortletException;

    /**
     * Retrieves a List of portlet instances for the given profile.
     *
     * @param profile Retrieve instances from this profile.
     * @return List The list of all instances in current profile.
     */
    List getInstances(Profile profile) throws PortletException;

}