/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;


import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.ecs.*;


/**
 * Portlet for rendering HTML links
 * Can also be used for WML but no output will be created so
 * redering for wml is done in by the /wml/column.vm file
 * 
 * @author <a href="mailto:A.Kempf@web.de">Andreas Kempf</a>
 * @version $Id: LinkPortlet.java,v 1.6 2003/05/29 20:23:19 morciuch Exp $
 */
public class LinkPortlet extends AbstractPortlet
{

  // Define parameter name for a image
  public static final String L_IMAGE = "image";
  // Define parameter name for the link name
  public static final String L_NAME  = "anchor";
  // Define parameter name for the link url
  public static final String L_URL   = "link";
  // Define parameter name for the link description
  public static final String L_DESC  = "description";
  // Define the image for opening the link in an external window
  public static final String EXT_LINK_IMG  = "exlink.gif";


/**
 * Render HTML links like:
 * <bullet> <open_new_window_link+image> <link_image> <link_name> <link_description>.
 * @return org.apache.ecs.ConcreteElement
 * @param data org.apache.turbine.util.RunData
 */
public org.apache.ecs.ConcreteElement getContent(org.apache.turbine.util.RunData data)
{

  CapabilityMap cap = ((JetspeedRunData)data).getCapability();

  // only for HTML mimetype!!!
  if (cap.getPreferredType().getCode().equals(MimeType.HTML.getCode()))
  {
    String link;
    String image;
    String name;
    String desc;
    String res = "";
    String cstr = "";
    int contains = 0;
    int i = 0;

    do
    {
      if (i>0)
        cstr=String.valueOf(i);

      link = getPortletConfig().getInitParameter(L_URL+cstr);

      // Link available?
      if ((link!=null) && (link.length()>0))
      {

        // start Linklist
        if (i==0)
          res = "<ul>";

        image = getPortletConfig().getInitParameter(L_IMAGE+cstr);
        name = getPortletConfig().getInitParameter(L_NAME+cstr);
        desc = getPortletConfig().getInitParameter(L_DESC+cstr);

        // set description
        if ((desc==null) || (desc.length()<1))
          desc = "follow this link";

        // add new entry
        res += "<li>";

        // add open in new window link
        res += "<A HREF=\""+link+"\" TARGET=\"_new\"><IMG SRC=\"images/"+EXT_LINK_IMG+"\" BORDER=\"0\" ALT=\""+name+"\"></A>";

        // add link
        res += "<A HREF=\""+link+"\">";

        // add image
        if ((image != null) && (image.length()>0))
          res += "&nbsp;<IMG SRC=\""+image+"\" HSPACES=\"5\" ALT=\""+name+"\" BORDER=\"0\">&nbsp;&nbsp;";

        // add name and description
        res += name+"</A>&nbsp;&nbsp;&nbsp;&nbsp;<SMALL>"+desc+"</SMALL></li>";
        contains++;
      }
      else
        link = null;

      i++;
    }
    while (link != null);
    {
    }

    // close list
    if (contains > 0)
      res += "</ul>";

    return(new StringElement(res));
  }



    return new org.apache.jetspeed.util.JetspeedClearElement( " " );
}

}
