/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtil {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final BitSet alphanum = new BitSet(128);
    public static final BitSet schemeReserved = new BitSet(128);
    public static final BitSet authorityReserved = new BitSet(128);
    public static final BitSet userinfoReserved = new BitSet(128);
    public static final BitSet hostReserved = new BitSet(128);
    public static final BitSet pathReserved = new BitSet(128);
    public static final BitSet queryReserved = new BitSet(128);

    public static BitSet alphanum() {
        return alphanum;
    }

    public static BitSet schemeReserved() {
        return schemeReserved;
    }

    public static BitSet authorityReserved() {
        return authorityReserved;
    }

    public static BitSet userinfoReserved() {
        return userinfoReserved;
    }

    public static BitSet hostReserved() {
        return hostReserved;
    }

    public static BitSet pathReserved() {
        return pathReserved;
    }

    public static BitSet queryReserved() {
        return queryReserved;
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static String unescape(String str) {
        return str == null ? null : URIUtil.unescape(str.getBytes());
    }

    public static String unescape(byte[] bytes) {
        return URIUtil.unescape(bytes, null);
    }

    public static String unescape(byte[] bytes, int off, int len) {
        return URIUtil.unescape(bytes, off, len, null);
    }

    public static String unescape(byte[] bytes, String enc) {
        if (bytes == null) {
            return null;
        }
        return URIUtil.unescape(bytes, 0, bytes.length, enc);
    }

    public static String unescape(byte[] bytes, int off, int len, String enc) {
        if (bytes == null) {
            return null;
        }
        int end = off + len;
        int ix = off;
        int ox = off;
        while (ix < end) {
            int b;
            if ((b = bytes[ix++]) == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((URIUtil.convertHexDigit(bytes[ix++]) << 4) + URIUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        if (enc != null) {
            try {
                return new String(bytes, off, ox, enc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return new String(bytes, off, ox);
    }

    public static String escape(String str) {
        return URIUtil.escape(str, null);
    }

    public static String escape(String str, BitSet reserved) {
        return str == null ? null : URIUtil.escape(str.getBytes(), reserved);
    }

    public static String escape(byte[] bytes, BitSet reserved) {
        return bytes == null ? null : URIUtil.escape(bytes, 0, bytes.length, reserved);
    }

    public static String escape(byte[] bytes, int off, int len, BitSet reserved) {
        if (bytes == null) {
            return null;
        }
        StringBuffer rewrittenStr = new StringBuffer(len);
        int i = off;
        while (i < len) {
            char c = (char)bytes[i];
            if (alphanum.get(c)) {
                rewrittenStr.append(c);
            } else if (reserved != null && reserved.get(c)) {
                rewrittenStr.append(c);
            } else {
                byte toEscape = bytes[i];
                rewrittenStr.append('%');
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                rewrittenStr.append(hexadecimal[high]);
                rewrittenStr.append(hexadecimal[low]);
            }
            ++i;
        }
        return rewrittenStr.toString();
    }

    public static String escape(String str, BitSet reserved, String enc) {
        try {
            return URIUtil.escape(str.getBytes(enc), reserved);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return URIUtil.escape(str.getBytes(), reserved);
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            alphanum.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            alphanum.set(i2);
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            alphanum.set(i3);
            ++i3;
        }
        schemeReserved.set(43);
        schemeReserved.set(46);
        schemeReserved.set(45);
        authorityReserved.set(59);
        authorityReserved.set(58);
        authorityReserved.set(64);
        authorityReserved.set(63);
        authorityReserved.set(47);
        userinfoReserved.set(59);
        userinfoReserved.set(58);
        userinfoReserved.set(38);
        userinfoReserved.set(61);
        userinfoReserved.set(43);
        userinfoReserved.set(36);
        userinfoReserved.set(44);
        hostReserved.set(46);
        hostReserved.set(45);
        pathReserved.set(47);
        pathReserved.set(59);
        pathReserved.set(61);
        pathReserved.set(63);
        queryReserved.set(59);
        queryReserved.set(47);
        queryReserved.set(63);
        queryReserved.set(58);
        queryReserved.set(64);
        queryReserved.set(38);
        queryReserved.set(61);
        queryReserved.set(43);
        queryReserved.set(44);
        queryReserved.set(36);
    }
}

