/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.HttpStatus;

public class HttpException
extends Exception {
    protected int statusCode;
    protected String message = "";
    public static final int METHOD_NOT_PROCESSED = -1;
    public static final int NO_CREDENTIALS_GIVEN = -2;

    public HttpException(String message) {
        this.message = message;
    }

    public HttpException(int statusCode) {
        this.statusCode = statusCode;
        if (statusCode < 0) {
            switch (statusCode) {
                case -1: {
                    this.message = "Method not processed";
                    break;
                }
                case -2: {
                    this.message = "No credentials given";
                    break;
                }
            }
        } else {
            String statusText = HttpStatus.getStatusText(statusCode);
            if (statusText != null) {
                this.message = statusText;
            }
        }
    }

    public HttpException(String message, int statusCode) {
        this(message);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }
}

