/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.cactus.WebResponse;
import org.apache.cactus.util.ClientCookie;

public class AssertUtils {
    public static String getResponseAsString(HttpURLConnection theConnection) throws IOException {
        WebResponse response = new WebResponse(null, theConnection);
        return response.getText();
    }

    public static String[] getResponseAsStringArray(HttpURLConnection theConnection) throws IOException {
        WebResponse response = new WebResponse(null, theConnection);
        return response.getTextAsArray();
    }

    public static Hashtable getCookies(HttpURLConnection theConnection) {
        Hashtable<String, Vector> cookies = new Hashtable<String, Vector>();
        String headerName = ((URLConnection)theConnection).getHeaderFieldKey(0);
        String headerValue = ((URLConnection)theConnection).getHeaderField(0);
        int i = 1;
        while (headerName != null || headerValue != null) {
            block7: {
                block6: {
                    Vector cookieValues;
                    if (headerName == null || !headerName.equals("Set-Cookie")) break block6;
                    Vector clientCookies = AssertUtils.parseSetCookieHeader(headerValue);
                    if (clientCookies.isEmpty()) break block7;
                    String name = ((ClientCookie)clientCookies.elementAt(0)).getName();
                    if (cookies.containsKey(name)) {
                        cookieValues = (Vector)cookies.get(name);
                        cookieValues.addAll(clientCookies);
                    } else {
                        cookieValues = new Vector();
                        cookieValues.addAll(clientCookies);
                        cookies.put(name, cookieValues);
                    }
                }
                headerName = ((URLConnection)theConnection).getHeaderFieldKey(i);
                headerValue = ((URLConnection)theConnection).getHeaderField(i);
            }
            ++i;
        }
        return cookies;
    }

    private static Vector parseSetCookieHeader(String theHeaderValue) {
        String comment = null;
        String path = null;
        String domain = null;
        long maxAge = 0L;
        boolean isSecure = false;
        float version = 1.0f;
        Vector<ClientCookie> cookies = new Vector<ClientCookie>();
        StringTokenizer stCookies = new StringTokenizer(theHeaderValue, ",");
        while (stCookies.hasMoreTokens()) {
            String singleCookie = stCookies.nextToken();
            singleCookie = singleCookie.trim();
            StringTokenizer stParams = new StringTokenizer(singleCookie, ";");
            String param = stParams.nextToken();
            int pos = (param = param.trim()).indexOf("=");
            if (pos < 0) {
                System.err.println("Bad 'Set-Cookie' syntax, missing '=' [" + param + "]");
                continue;
            }
            String name = param.substring(0, pos).trim();
            String value = param.substring(pos + 1).trim();
            while (stParams.hasMoreTokens()) {
                String right;
                String left;
                param = stParams.nextToken();
                pos = (param = param.trim()).indexOf("=");
                if (pos < 0) {
                    left = param;
                    right = "";
                } else {
                    left = param.substring(0, pos).trim();
                    right = param.substring(pos + 1).trim();
                }
                if (left.equalsIgnoreCase("comment")) {
                    comment = right;
                    continue;
                }
                if (left.equalsIgnoreCase("domain")) {
                    domain = right;
                    continue;
                }
                if (left.equalsIgnoreCase("max-age")) {
                    maxAge = Long.parseLong(right);
                    continue;
                }
                if (left.equalsIgnoreCase("path")) {
                    path = right;
                    continue;
                }
                if (left.equalsIgnoreCase("secure")) {
                    isSecure = true;
                    continue;
                }
                if (left.equalsIgnoreCase("version")) {
                    version = Float.parseFloat(right);
                    continue;
                }
                System.err.println("Bad 'Set-Cookie' syntax, bad name [" + param + "]");
            }
            ClientCookie cookie = new ClientCookie(name, value, comment, domain, maxAge, path, isSecure, version);
            cookies.add(cookie);
        }
        return cookies;
    }
}

