/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.cactus.util.log.Log;
import org.apache.cactus.util.log.LogService;

final class AutoReadHttpURLConnection
extends HttpURLConnection {
    private static Log logger = LogService.getInstance().getLog((class$org$apache$cactus$client$AutoReadHttpURLConnection == null ? (class$org$apache$cactus$client$AutoReadHttpURLConnection = AutoReadHttpURLConnection.class$("org.apache.cactus.client.AutoReadHttpURLConnection")) : class$org$apache$cactus$client$AutoReadHttpURLConnection).getName());
    static final int DEFAULT_CHUNK_SIZE = 16384;
    int chunkSize = 16384;
    HttpURLConnection delegate;
    InputStream streamBuffer;
    static /* synthetic */ Class class$org$apache$cactus$client$AutoReadHttpURLConnection;

    AutoReadHttpURLConnection(HttpURLConnection theConnection) {
        super(null);
        this.delegate = theConnection;
    }

    public synchronized InputStream getInputStream() throws IOException {
        logger.entry("getInputStream()");
        logger.debug("Original connection = " + this.delegate);
        if (this.streamBuffer == null) {
            InputStream is = this.delegate.getInputStream();
            this.streamBuffer = this.bufferInputStream(is);
        }
        logger.exit("getInputStream");
        return this.streamBuffer;
    }

    InputStream bufferInputStream(InputStream is) throws IOException {
        logger.entry("bufferInputStream(...)");
        ByteArrayOutputStream os = new ByteArrayOutputStream(this.chunkSize);
        this.copy(is, os);
        ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
        logger.exit("bufferInputStream");
        return bais;
    }

    /*
     * WARNING - void declaration
     */
    void copy(InputStream is, OutputStream os) throws IOException {
        logger.entry("copy(...)");
        logger.debug("Content-Length : [" + this.delegate.getContentLength() + "]");
        if (this.delegate.getContentLength() != 0) {
            int count;
            byte[] buf = new byte[this.chunkSize];
            while (-1 != (count = is.read(buf))) {
                void var4_4;
                os.write(buf, 0, (int)var4_4);
            }
        }
        logger.exit("copy");
    }

    public void connect() throws IOException {
        this.delegate.connect();
    }

    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public long getDate() {
        return this.delegate.getDate();
    }

    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    public String getHeaderField(int a0) {
        return ((URLConnection)this.delegate).getHeaderField(a0);
    }

    public String getHeaderField(String a0) {
        return this.delegate.getHeaderField(a0);
    }

    public long getHeaderFieldDate(String a0, long a1) {
        return this.delegate.getHeaderFieldDate(a0, a1);
    }

    public int getHeaderFieldInt(String a0, int a1) {
        return this.delegate.getHeaderFieldInt(a0, a1);
    }

    public String getHeaderFieldKey(int a0) {
        return ((URLConnection)this.delegate).getHeaderFieldKey(a0);
    }

    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    public String getRequestProperty(String a0) {
        return this.delegate.getRequestProperty(a0);
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    public void setAllowUserInteraction(boolean a0) {
        this.delegate.setAllowUserInteraction(a0);
    }

    public void setDefaultUseCaches(boolean a0) {
        this.delegate.setDefaultUseCaches(a0);
    }

    public void setDoInput(boolean a0) {
        this.delegate.setDoInput(a0);
    }

    public void setDoOutput(boolean a0) {
        this.delegate.setDoOutput(a0);
    }

    public void setIfModifiedSince(long a0) {
        this.delegate.setIfModifiedSince(a0);
    }

    public void setRequestProperty(String a0, String a1) {
        this.delegate.setRequestProperty(a0, a1);
    }

    public void setUseCaches(boolean a0) {
        this.delegate.setUseCaches(a0);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    public void setRequestMethod(String a0) throws ProtocolException {
        this.delegate.setRequestMethod(a0);
    }

    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

