/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TemplateEngineService;
import org.apache.fulcrum.template.TurbineTemplate;

public abstract class BaseTemplateEngineService
extends BaseService
implements TemplateEngineService {
    private Hashtable configuration = new Hashtable();

    public void registerConfiguration(String defaultExt) {
        this.initConfiguration(defaultExt);
        TurbineTemplate.registerTemplateEngineService(this);
    }

    public Hashtable getTemplateEngineServiceConfiguration() {
        return this.configuration;
    }

    public String[] getAssociatedFileExtensions() {
        return (String[])this.configuration.get("template.extension");
    }

    protected void initConfiguration(String defaultExt) {
        String[] fileExtensionAssociations = this.getConfiguration().getStringArray("template.extension");
        if (fileExtensionAssociations == null || fileExtensionAssociations.length == 0) {
            fileExtensionAssociations = new String[]{this.getConfiguration().getString("template.default.extension", defaultExt)};
        }
        this.configuration.put("template.extension", fileExtensionAssociations);
        this.configuration.put("default.layout.template", this.getConfiguration().getString("default.layout.template"));
        this.configuration.put("default.page.template", this.getConfiguration().getString("default.page.template"));
    }

    public abstract boolean templateExists(String var1);

    public abstract String handleRequest(TemplateContext var1, String var2) throws ServiceException;

    public abstract void handleRequest(TemplateContext var1, String var2, OutputStream var3) throws ServiceException;

    public abstract void handleRequest(TemplateContext var1, String var2, Writer var3) throws ServiceException;
}

